/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final int bA = 16;
    public static final EnumMainHand bB = EnumMainHand.b;
    public static final int bC = 0;
    public static final int bD = 20;
    public static final int bE = 100;
    public static final int bF = 10;
    public static final int bG = 200;
    public static final float bH = 1.5f;
    public static final float bI = 0.6f;
    public static final float bJ = 0.6f;
    public static final float bK = 1.62f;
    public static final EntitySize bL = EntitySize.b(0.6f, 1.8f);
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bL).put((Object)EntityPose.c, (Object)EntityLiving.v).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f)).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f)).build();
    private static final int d = 25;
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bN = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bO = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    protected static final DataWatcherObject<NBTTagCompound> bP = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    private long cm;
    private final PlayerInventory cn = new PlayerInventory(this);
    protected InventoryEnderChest bQ = new InventoryEnderChest(this);
    public final ContainerPlayer bR;
    public Container bS;
    protected FoodMetaData bT = new FoodMetaData(this);
    protected int bU;
    public float bV;
    public float bW;
    public int bX;
    public double bY;
    public double bZ;
    public double ca;
    public double cb;
    public double cc;
    public double cd;
    public int co;
    protected boolean ce;
    private final PlayerAbilities cp = new PlayerAbilities();
    public int cf;
    public int cg;
    public float ch;
    public int ci;
    protected final float cj = 0.02f;
    private int cq;
    public GameProfile cr;
    private boolean cs;
    private net.minecraft.world.item.ItemStack ct;
    private final ItemCooldown cu;
    private Optional<GlobalPos> cv;
    @Nullable
    public EntityFishingHook ck;
    public float cl;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean elytraAeronauticsNoChunk = false;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bt, world);
        this.ct = net.minecraft.world.item.ItemStack.b;
        this.cu = this.k();
        this.cv = Optional.empty();
        this.a_(gameProfile.getId());
        this.cr = gameProfile;
        this.bR = new ContainerPlayer(this.cn, !world.B, this);
        this.bS = this.bR;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bg = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gd()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eS();
        return itemstack.b() || !itemstack.b(world.G_().d(Registries.e), new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fG() {
        return EntityLiving.dP().a(GenericAttributes.f, 1.0).a(GenericAttributes.d, 0.1f).a(GenericAttributes.h).a(GenericAttributes.k);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(e, Float.valueOf(0.0f));
        this.an.a(f, 0);
        this.an.a(bM, (byte)0);
        this.an.a(bN, (byte)bB.a());
        this.an.a(bO, new NBTTagCompound());
        this.an.a(bP, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.af = this.isCreativeFlyOrSpectator();
        if (this.isCreativeFlyOrSpectator()) {
            this.c(false);
        }
        if (this.bX > 0) {
            --this.bX;
        }
        if (this.fC()) {
            ++this.co;
            if (this.co == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.co = Integer.MIN_VALUE;
            }
            if (this.co > 100) {
                this.co = 100;
            }
            if (!this.dL().B && this.dL().N()) {
                this.a(false, true);
            }
        } else if (this.co > 0) {
            ++this.co;
            if (this.co >= 110) {
                this.co = 0;
            }
        }
        this.fK();
        super.l();
        if (!this.dL().B && this.bS != null && !this.bS.a(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bS = this.bR;
        }
        this.t();
        if (!this.dL().B) {
            this.bT.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bv()) {
                this.a(StatisticList.m);
            }
            if (this.bU()) {
                this.a(StatisticList.o);
            }
            if (!this.fC()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dq(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dw(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dq() || d1 != this.dw()) {
            this.e(d0, this.ds(), d1);
        }
        ++this.aP;
        net.minecraft.world.item.ItemStack itemstack = this.eS();
        if (!net.minecraft.world.item.ItemStack.a(this.ct, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.ct, itemstack)) {
                this.gl();
            }
            this.ct = itemstack.p();
        }
        this.s();
        this.cu.a();
        this.fL();
    }

    public boolean fH() {
        return this.bR();
    }

    protected boolean fI() {
        return this.bR();
    }

    protected boolean fJ() {
        return this.bR();
    }

    protected boolean fK() {
        this.ce = ((Entity)this).a(TagsFluid.a);
        return this.ce;
    }

    private void s() {
        net.minecraft.world.item.ItemStack itemstack = this.c(EnumItemSlot.f);
        if (itemstack.a(Items.nC) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void t() {
        this.bY = this.cb;
        this.bZ = this.cc;
        this.ca = this.cd;
        double d0 = this.dq() - this.cb;
        double d1 = this.ds() - this.cc;
        double d2 = this.dw() - this.cd;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.bY = this.cb = this.dq();
        }
        if (d2 > 10.0) {
            this.ca = this.cd = this.dw();
        }
        if (d1 > 10.0) {
            this.bZ = this.cc = this.ds();
        }
        if (d0 < -10.0) {
            this.bY = this.cb = this.dq();
        }
        if (d2 < -10.0) {
            this.ca = this.cd = this.dw();
        }
        if (d1 < -10.0) {
            this.bZ = this.cc = this.ds();
        }
        this.cb += d0 * 0.25;
        this.cd += d2 * 0.25;
        this.cc += d1 * 0.25;
    }

    protected void fL() {
        if (this.g(EntityPose.d)) {
            EntityPose entitypose = this.fv() ? EntityPose.b : (this.fC() ? EntityPose.c : (this.bY() ? EntityPose.d : (this.fi() ? EntityPose.e : (this.bR() && !this.cp.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.isCreativeFlyOrSpectator() || this.bN() || this.g(entitypose)) ? (this.g(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    protected boolean g(EntityPose pose) {
        return this.dL().a((Entity)this, this.a(pose).a(this.dj()).h(1.0E-7));
    }

    @Override
    public int av() {
        return this.cp.a ? 1 : 80;
    }

    @Override
    protected SoundEffect aL() {
        return SoundEffects.sI;
    }

    @Override
    protected SoundEffect aM() {
        return SoundEffects.sG;
    }

    @Override
    protected SoundEffect aN() {
        return SoundEffects.sH;
    }

    @Override
    public int bI() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dL().a(this, this.dq(), this.ds(), this.dw(), sound, this.da(), volume, pitch);
    }

    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.h;
    }

    @Override
    public int db() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.ad_();
        } else if (status == 23) {
            this.cs = false;
        } else if (status == 22) {
            this.cs = true;
        } else if (status == 43) {
            this.a(Particles.f);
        } else {
            super.b(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dL().a(parameters, this.d(1.0), this.dt() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.q();
        this.bS = this.bR;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bS = this.bR;
    }

    public void q() {
        this.bS = this.bR;
    }

    protected void r() {
    }

    @Override
    public void by() {
        if (!this.dL().B && this.fI() && this.bN()) {
            this.aa();
            if (!this.bN()) {
                this.f(false);
                return;
            }
        }
        double d0 = this.dq();
        double d1 = this.ds();
        double d2 = this.dw();
        super.by();
        this.bV = this.bW;
        this.bW = 0.0f;
        this.s(this.dq() - d0, this.ds() - d1, this.dw() - d2);
    }

    @Override
    protected void fg() {
        super.fg();
        this.eP();
        this.aW = this.dB();
    }

    @Override
    public void b_() {
        if (this.bU > 0) {
            --this.bU;
        }
        if (this.dL().ai() == EnumDifficulty.a && this.dL().X().b(GameRules.j)) {
            if (this.eu() < this.eL() && this.ah % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.bT.c() && this.ah % 10 == 0) {
                this.bT.a(this.bT.a() + 1);
            }
        }
        this.cn.j();
        this.bV = this.bW;
        super.b_();
        this.w((float)this.b(GenericAttributes.d));
        float f2 = this.aA() && !this.ev() && !this.bY() ? Math.min(0.1f, (float)this.do().h()) : 0.0f;
        this.bW += (f2 - this.bW) * 0.4f;
        if (this.eu() > 0.0f && !this.isCreativeFlyOrSpectator()) {
            AxisAlignedBB axisalignedbb = this.bN() && !this.cY().dG() ? this.cG().b(this.cY().cG()).c(1.0, 0.0, 1.0) : this.cG().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dL().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ag() == EntityTypes.J) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dG()) continue;
                this.c(entity);
            }
            if (!list1.isEmpty()) {
                this.c((Entity)SystemUtils.a(list1, this.ag));
            }
        }
        this.c(this.gi());
        this.c(this.gj());
        if ((!this.dL().B && (this.ab > 0.5f || this.aX()) || this.cp.b || this.fC() || this.aA) && !this.dL().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gf();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.dL().z.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.at).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dL(), this)) {
                    this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), EntityParrot.a(this.dL(), this.dL().z), this.da(), 1.0f, EntityParrot.a(this.dL().z));
                }
            });
        }
    }

    private void c(Entity entity) {
        entity.b_(this);
    }

    public int fM() {
        return this.an.b(f);
    }

    public void r(int score) {
        this.an.b(f, score);
    }

    public void s(int score) {
        int j2 = this.fM();
        this.an.b(f, j2 + score);
    }

    public void t(int riptideTicks) {
        this.by = riptideTicks;
        if (!this.dL().B) {
            this.gf();
            this.c(4, true);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.ap();
        if (!this.M_()) {
            this.dropAllDeathLoot(damageSource);
        }
        if (damageSource != null) {
            this.o(-MathHelper.b((this.eD() + this.dB()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eD() + this.dB()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.o(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.ay();
        this.a_(false);
        this.a(Optional.of(GlobalPos.a(this.dL().ac(), this.dl())));
    }

    @Override
    protected void ex() {
        super.ex();
        if (!this.dL().X().b(GameRules.d)) {
            this.fN();
            this.cn.k();
        }
    }

    protected void fN() {
        for (int i2 = 0; i2 < this.cn.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.cn.a(i2);
            if (itemstack.b() || !EnchantmentManager.e(itemstack)) continue;
            this.cn.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return source.j().d().a();
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.sy;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        if (itemstack.b()) {
            return null;
        }
        if (this.dL().B) {
            this.a(EnumHand.a);
        }
        double d0 = this.du() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.p();
        itemstack.f(0);
        itemstack = tmp;
        EntityItem entityitem = new EntityItem(this.dL(), this.dq(), d0, this.dw(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.c(this.cv());
        }
        if (flag) {
            float f2 = this.ag.i() * 0.5f;
            float f1 = this.ag.i() * ((float)Math.PI * 2);
            entityitem.o(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dD() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dD() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dB() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dB() * ((float)Math.PI / 180));
            float f5 = this.ag.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.ag.i();
            entityitem.o((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.ag.i() - this.ag.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.d() == Items.rf && (worldmap = ItemWorldMap.a(itemstack, this.dL())) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    public float d(IBlockData block) {
        float f2 = this.cn.a(block);
        if (f2 > 1.0f) {
            int i2 = EnchantmentManager.g(this);
            net.minecraft.world.item.ItemStack itemstack = this.eS();
            if (i2 > 0 && !itemstack.b()) {
                f2 += (float)(i2 * i2 + 1);
            }
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.a(MobEffects.d)) {
            f2 *= (switch (this.b(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (((Entity)this).a(TagsFluid.a) && !EnchantmentManager.i(this)) {
            f2 /= 5.0f;
        }
        if (!this.aA()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean e(IBlockData state) {
        return !state.y() || this.cn.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(this.cr.getId());
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.cn.b(nbttaglist);
        this.cn.l = nbt.h("SelectedItemSlot");
        this.co = nbt.g("SleepTimer");
        this.ch = nbt.j("XpP");
        this.cf = nbt.h("XpLevel");
        this.cg = nbt.h("XpTotal");
        this.ci = nbt.h("XpSeed");
        if (this.ci == 0) {
            this.ci = this.ag.f();
        }
        this.r(nbt.h("Score"));
        this.bT.a(nbt);
        this.cp.b(nbt);
        this.a(GenericAttributes.d).a(this.cp.b());
        if (nbt.b("EnderItems", 9)) {
            this.bQ.a(nbt.c("EnderItems", 10));
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.g(nbt);
        nbt.a("Inventory", this.cn.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.cn.l);
        nbt.a("SleepTimer", (short)this.co);
        nbt.a("XpP", this.ch);
        nbt.a("XpLevel", this.cf);
        nbt.a("XpTotal", this.cg);
        nbt.a("XpSeed", this.ci);
        nbt.a("Score", this.fM());
        this.bT.b(nbt);
        this.cp.a(nbt);
        nbt.a("EnderItems", this.bQ.g());
        if (!this.gi().g()) {
            nbt.a("ShoulderEntityLeft", this.gi());
        }
        if (!this.gj().g()) {
            nbt.a("ShoulderEntityRight", this.gj());
        }
        this.gq().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.a.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource.a(DamageTypeTags.n) ? !this.dL().X().b(GameRules.C) : (damageSource.a(DamageTypeTags.m) ? !this.dL().X().b(GameRules.D) : (damageSource.a(DamageTypeTags.i) ? !this.dL().X().b(GameRules.E) : (damageSource.a(DamageTypeTags.o) ? !this.dL().X().b(GameRules.F) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.cp.a && !source.a(DamageTypeTags.d)) {
            return false;
        }
        this.bb = 0;
        if (this.ev()) {
            return false;
        }
        if (!this.dL().B) {
            // empty if block
        }
        if (source.f()) {
            if (this.dL().ai() == EnumDifficulty.a) {
                return false;
            }
            if (this.dL().ai() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.dL().ai() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.gf();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.fF()) {
            this.s(true);
        }
    }

    @Override
    public boolean en() {
        return !this.fS().a && super.en();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.dL().getCraftServer().getOfflinePlayer(player.cx());
            team = player.dL().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dL().getCraftServer().getOfflinePlayer(this.cx()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.cn.a(source, amount, PlayerInventory.g);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.cn.a(source, amount, PlayerInventory.h);
    }

    @Override
    protected void u(float amount) {
        if (this.bv.a(Items.uy)) {
            if (!this.dL().B) {
                this.b(StatisticList.c.b(this.bv.d()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.fn();
                this.bv.a(i2, this, (T entityhuman) -> entityhuman.d(enumhand));
                if (this.bv.b()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.b);
                    }
                    this.bv = net.minecraft.world.item.ItemStack.b;
                    this.a(SoundEffects.uR, 0.8f, 0.8f + this.dL().z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean damageEntity0(DamageSource damagesource, float f2) {
        return super.damageEntity0(damagesource, f2);
    }

    @Override
    protected boolean dT() {
        return !this.cp.b && super.dT();
    }

    public boolean W() {
        return false;
    }

    public void a(TileEntitySign sign, boolean front) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.M_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.d;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.p();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.cp.d && itemstack == this.b(hand) && itemstack.L() < itemstack1.L()) {
                itemstack.f(itemstack1.L());
            }
            return enuminteractionresult;
        }
        if (!itemstack.b() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cp.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.dL().a(GameEvent.r, entity.dj(), GameEvent.a.a(this));
                if (itemstack.b() && !this.cp.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.b);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.d;
    }

    @Override
    protected float l(Entity vehicle) {
        return -0.6f;
    }

    @Override
    public void bB() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        this.J = 0;
    }

    @Override
    protected boolean eX() {
        return super.eX() || this.fC() || this.dG() || !this.valid;
    }

    @Override
    public boolean dZ() {
        return !this.cp.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        if (!this.cp.b && movement.d <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fJ() && this.y()) {
            double d0 = movement.c;
            double d1 = movement.e;
            double d2 = 0.05;
            while (d0 != 0.0 && this.dL().a((Entity)this, this.cG().d(d0, -this.dF(), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.dL().a((Entity)this, this.cG().d(0.0, -this.dF(), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.dL().a((Entity)this, this.cG().d(d0, -this.dF(), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            movement = new Vec3D(d0, movement.d, d1);
        }
        return movement;
    }

    private boolean y() {
        return this.aA() || this.ab < this.dF() && !this.dL().a((Entity)this, this.cG().d(0.0, this.ab - this.dF(), 0.0));
    }

    public void d(Entity target) {
        boolean willAttack = target.cp() && !target.u(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = (float)this.b(GenericAttributes.f);
            float f1 = target instanceof EntityLiving ? EnchantmentManager.a(this.eS(), ((EntityLiving)target).eR()) : EnchantmentManager.a(this.eS(), EnumMonsterType.a);
            float f22 = this.B(0.5f);
            f1 *= f22;
            if ((f2 *= 0.2f + f22 * f22 * 0.8f) > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack;
                boolean flag = f22 > 0.9f;
                boolean flag1 = false;
                int b0 = 0;
                int i2 = b0 + EnchantmentManager.c(this);
                if (this.bX() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.sq, this.da(), 1.0f, 1.0f);
                    ++i2;
                    flag1 = true;
                }
                boolean flag2 = flag && this.ab > 0.0f && !this.aA() && !this.c_() && !this.aX() && !this.a(MobEffects.o) && !this.bN() && target instanceof EntityLiving;
                flag2 = flag2 && !this.dL().paperConfig().entities.behavior.disablePlayerCrits;
                boolean bl = flag2 = flag2 && !this.bX();
                if (flag2) {
                    f2 *= 1.5f;
                }
                f2 += f1;
                boolean flag3 = false;
                double d0 = this.Y - this.X;
                if (flag && !flag2 && !flag1 && this.aA() && d0 < (double)this.fe() && (itemstack = this.b(EnumHand.a)).d() instanceof ItemSword) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                boolean flag4 = false;
                int j2 = EnchantmentManager.d(this);
                if (target instanceof EntityLiving) {
                    f3 = ((EntityLiving)target).eu();
                    if (j2 > 0 && !target.bM()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            target.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3D vec3d = target.do();
                boolean flag5 = target.a(this.dM().a(this).critical(flag2), f2);
                if (flag5) {
                    if (i2 > 0) {
                        if (target instanceof EntityLiving) {
                            ((EntityLiving)target).knockback((float)i2 * 0.5f, MathHelper.a(this.dB() * ((float)Math.PI / 180)), -MathHelper.b(this.dB() * ((float)Math.PI / 180)), this);
                        } else {
                            target.push(-MathHelper.a(this.dB() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, 0.1, MathHelper.b(this.dB() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, this);
                        }
                        this.f(this.do().d(0.6, 1.0, 0.6));
                        if (!this.dL().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.g(false);
                        }
                    }
                    if (flag3) {
                        float f4 = 1.0f + EnchantmentManager.a(this) * f2;
                        List<EntityLiving> list = this.dL().a(EntityLiving.class, target.cG().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving : list) {
                            if (entityliving == this || entityliving == target || this.s(entityliving) || entityliving instanceof EntityArmorStand && ((EntityArmorStand)entityliving).y() || !(this.f((Entity)entityliving) < 9.0) || !entityliving.a(this.dM().a(this).sweep().critical(flag2), f4)) continue;
                            entityliving.knockback(0.4f, MathHelper.a(this.dB() * ((float)Math.PI / 180)), -MathHelper.b(this.dB() * ((float)Math.PI / 180)), this);
                        }
                        EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.st, this.da(), 1.0f, 1.0f);
                        this.fO();
                    }
                    if (target instanceof EntityPlayer && target.T) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).c.b(new PacketPlayOutEntityVelocity(target));
                            target.T = false;
                            target.f(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.sp, this.da(), 1.0f, 1.0f);
                        this.a(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.ss, this.da(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.su, this.da(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.b(target);
                    }
                    this.A(target);
                    if (target instanceof EntityLiving) {
                        EnchantmentManager.a((EntityLiving)target, (Entity)this);
                    }
                    EnchantmentManager.b(this, target);
                    net.minecraft.world.item.ItemStack itemstack1 = this.eS();
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    if (!this.dL().B && !itemstack1.b() && object instanceof EntityLiving) {
                        itemstack1.a((EntityLiving)object, this);
                        if (itemstack1.b()) {
                            this.a(EnumHand.a, net.minecraft.world.item.ItemStack.b);
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f5 = f3 - ((EntityLiving)target).eu();
                        this.a(StatisticList.G, Math.round(f5 * 10.0f));
                        if (j2 > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), j2 * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                target.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.dL() instanceof WorldServer && f5 > 2.0f) {
                            int k2 = (int)((double)f5 * 0.5);
                            ((WorldServer)this.dL()).a(Particles.h, target.dq(), target.e(0.5), target.dw(), k2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dL().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dq(), this.ds(), this.dw(), SoundEffects.sr, this.da(), 1.0f, 1.0f);
                    if (flag4) {
                        target.ay();
                    }
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void g(EntityLiving target) {
        this.d((Entity)target);
    }

    public void s(boolean sprinting) {
        float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
        if (sprinting) {
            f2 += 0.75f;
        }
        if (this.ag.i() < f2) {
            this.gm().a(Items.uy, 100);
            this.fs();
            this.dL().a((Entity)this, (byte)30);
        }
    }

    public void a(Entity target) {
    }

    public void b(Entity target) {
    }

    public void fO() {
        double d0 = -MathHelper.a(this.dB() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dB() * ((float)Math.PI / 180));
        if (this.dL() instanceof WorldServer) {
            ((WorldServer)this.dL()).a(Particles.ad, this.dq() + d0, this.e(0.5), this.dw() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fP() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.bR.b(this);
        if (this.bS != null && this.fT()) {
            this.r();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fQ() {
        return this.cr;
    }

    public PlayerInventory fR() {
        return this.cn;
    }

    public PlayerAbilities fS() {
        return this.cp;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean fT() {
        return this.bS != this.bR;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.co = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fD();
        if (this.dL() instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.dL()).e();
        }
        this.co = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fD() {
        this.a(true, true);
    }

    public static Optional<Vec3D> a(WorldServer world, BlockPosition pos, float angle, boolean forced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (forced || iblockdata.c(BlockRespawnAnchor.c) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bt, world, pos);
            if (!forced && !alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.c, iblockdata.c(BlockRespawnAnchor.c) - 1), 3);
            }
            return optional;
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bt, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aC), angle);
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = world.a_(pos.c());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5)) : Optional.empty();
    }

    public boolean fU() {
        return this.fC() && this.co >= 100;
    }

    public int fV() {
        return this.co;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void a(MinecraftKey[] ids) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void fa() {
        super.fa();
        this.a(StatisticList.E);
        if (this.bX()) {
            this.causeFoodExhaustion(this.dL().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dL().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        double d3;
        double d0 = this.dq();
        double d1 = this.ds();
        double d2 = this.dw();
        if (this.bY() && !this.bN()) {
            double d4;
            d3 = this.bE().d;
            double d5 = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.bj || !this.dL().a_(BlockPosition.a(this.dq(), this.ds() + 1.0 - 0.1, this.dw())).u().c()) {
                Vec3D vec3d1 = this.do();
                this.f(vec3d1.b(0.0, (d3 - vec3d1.d) * d4, 0.0));
            }
        }
        if (this.cp.b && !this.bN()) {
            d3 = this.do().d;
            super.h(movementInput);
            Vec3D vec3d2 = this.do();
            this.o(vec3d2.c, d3 * 0.6, vec3d2.e);
            this.n();
            if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.h(movementInput);
        }
        this.r(this.dq() - d0, this.ds() - d1, this.dw() - d2);
    }

    @Override
    public void bd() {
        if (this.cp.b) {
            this.h(false);
        } else {
            super.bd();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dL().a_(pos).o(this.dL(), pos);
    }

    @Override
    public float fe() {
        return (float)this.b(GenericAttributes.d);
    }

    public void r(double dx, double dy, double dz) {
        if (!this.bN()) {
            if (this.bY()) {
                int i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dL().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dL().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.aX()) {
                int i4 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dL().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.c_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.aA()) {
                int i5 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i5 > 0) {
                    if (this.bX()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dL().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.bW()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dL().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dL().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fv()) {
                int i6 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void s(double dx, double dy, double dz) {
        int i2;
        if (this.bN() && (i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f)) > 0) {
            Entity entity = this.cY();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.cp.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    public boolean fW() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.aA() && !this.fv() && !this.aX() && !this.a(MobEffects.y) && (itemstack = this.c(EnumItemSlot.e)).a(Items.nh) && ItemElytra.d(itemstack)) {
            this.fX();
            return true;
        }
        return false;
    }

    public void fX() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void fY() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bg() {
        if (!this.M_()) {
            super.bg();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.aX()) {
            this.aP();
            this.b(state);
        } else {
            BlockPosition blockposition1 = this.e(pos);
            if (!pos.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dL().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bn)) {
                    this.a(iblockdata1, state);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eF() {
        return new EntityLiving.a(SoundEffects.sF, SoundEffects.sv);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.ag()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.cp.b) {
            super.a(state, multiplier);
        }
    }

    public void d(int experience) {
        this.s(experience);
        this.ch += (float)experience / (float)this.ga();
        this.cg = MathHelper.a(this.cg + experience, 0, Integer.MAX_VALUE);
        while (this.ch < 0.0f) {
            float f2 = this.ch * (float)this.ga();
            if (this.cf > 0) {
                this.c(-1);
                this.ch = 1.0f + f2 / (float)this.ga();
                continue;
            }
            this.c(-1);
            this.ch = 0.0f;
        }
        while (this.ch >= 1.0f) {
            this.ch = (this.ch - 1.0f) * (float)this.ga();
            this.c(1);
            this.ch /= (float)this.ga();
        }
    }

    public int fZ() {
        return this.ci;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cf -= experienceLevels;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        this.ci = this.ag.f();
    }

    public void c(int levels) {
        this.cf += levels;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        if (levels > 0 && this.cf % 5 == 0 && (float)this.cq < (float)this.ah - 100.0f) {
            float f2 = this.cf > 30 ? 1.0f : (float)this.cf / 30.0f;
            this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.sE, this.da(), f2 * 0.75f, 1.0f);
            this.cq = this.ah;
        }
    }

    public int ga() {
        return this.cf >= 30 ? 112 + (this.cf - 30) * 9 : (this.cf >= 15 ? 37 + (this.cf - 15) * 5 : 7 + this.cf * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dL().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            ((EntityPlayer)fromEntity).c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ag.g()));
        }
    }

    public void A(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cp.a || this.dL().B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bT.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> Y() {
        return Optional.empty();
    }

    public FoodMetaData gb() {
        return this.bT;
    }

    public boolean t(boolean ignoreHunger) {
        return this.cp.a || ignoreHunger || this.bT.c();
    }

    public boolean gc() {
        return this.eu() > 0.0f && this.eu() < this.eL();
    }

    public boolean gd() {
        return this.cp.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cp.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dL(), blockposition1, false);
        return stack.a(this.dL().G_().d(Registries.e), shapedetectorblock);
    }

    @Override
    public int ed() {
        if (!this.dL().X().b(GameRules.d) && !this.M_()) {
            int i2 = this.cf * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean ee() {
        return true;
    }

    @Override
    public boolean cB() {
        return true;
    }

    @Override
    protected Entity.MovementEmission aU() {
        return !this.cp.b && (!this.aA() || !this.bU()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent ab() {
        return IChatBaseComponent.b(this.cr.getName());
    }

    public InventoryEnderChest ge() {
        return this.bQ;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.cn.f() : (slot == EnumItemSlot.b ? this.cn.k.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.cn.j.get(slot.b()) : net.minecraft.world.item.ItemStack.b));
    }

    @Override
    protected boolean a(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.cn.i.set(this.cn.l, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.cn.k.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.cn.j.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.cn.e(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bJ() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eS(), this.eT()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bK() {
        return this.cn.j;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bN() && this.aA() && !this.aX() && !this.aA) {
            if (this.gi().g()) {
                this.i(entityNbt);
                this.cm = this.dL().V();
                return true;
            }
            if (this.gj().g()) {
                this.j(entityNbt);
                this.cm = this.dL().V();
                return true;
            }
            return false;
        }
        return false;
    }

    public void gf() {
        if (this.cm + 20L < this.dL().V()) {
            if (this.respawnEntityOnShoulder(this.gi())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gj())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gi());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gj());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(NBTTagCompound nbttagcompound) {
        if (!this.dL().B && nbttagcompound != null && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dL()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ay);
                }
                entity.e(this.dq(), this.ds() + (double)0.7f, this.dw());
                boolean addedToWorld = ((WorldServer)this.dL()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean M_();

    public boolean isCreativeFlyOrSpectator() {
        return this.M_() || LeavesConfig.creativeNoClip && this.f() && this.fS().b;
    }

    @Override
    public boolean bq() {
        return !this.M_() && super.bq();
    }

    @Override
    public boolean bY() {
        return !this.cp.b && !this.M_() && super.bY();
    }

    public abstract boolean f();

    @Override
    public boolean cy() {
        return !this.cp.b;
    }

    public Scoreboard gg() {
        return this.dL().I();
    }

    @Override
    public IChatBaseComponent N_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cf(), this.ab());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fQ().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cF()).a(s2));
    }

    @Override
    public String cx() {
        return this.fQ().getName();
    }

    @Override
    public float b(EntityPose pose, EntitySize dimensions) {
        switch (pose) {
            case d: 
            case b: 
            case e: {
                return 0.4f;
            }
            case f: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    protected void z(float absorptionAmount) {
        this.al().b(e, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fj() {
        return this.al().b(e).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.al().b(bM) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < this.cn.i.size()) {
            return SlotAccess.a(this.cn, mappedIndex);
        }
        int j2 = mappedIndex - 200;
        return j2 >= 0 && j2 < this.bQ.b() ? SlotAccess.a(this.bQ, j2) : super.a_(mappedIndex);
    }

    public boolean gh() {
        return this.cs;
    }

    public void u(boolean reducedDebugInfo) {
        this.cs = reducedDebugInfo;
    }

    @Override
    public void h(int fireTicks) {
        super.h(this.cp.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fl() {
        return this.an.b(bN) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.an.b(bN, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gi() {
        return this.an.b(bO);
    }

    public void i(NBTTagCompound entityNbt) {
        this.an.b(bO, entityNbt);
    }

    public NBTTagCompound gj() {
        return this.an.b(bP);
    }

    public void j(NBTTagCompound entityNbt) {
        this.an.b(bP, entityNbt);
    }

    public float gk() {
        return (float)(1.0 / this.b(GenericAttributes.h) * 20.0);
    }

    public float B(float baseTime) {
        return MathHelper.a(((float)this.aP + baseTime) / this.gk(), 0.0f, 1.0f);
    }

    public void gl() {
        this.aP = 0;
    }

    public ItemCooldown gm() {
        return this.cu;
    }

    @Override
    protected float aJ() {
        return !this.cp.b && !this.fv() ? super.aJ() : 1.0f;
    }

    public float gn() {
        return (float)this.b(GenericAttributes.k);
    }

    public boolean go() {
        return this.cp.d && this.D() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b();
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return c.getOrDefault((Object)pose, bL);
    }

    @Override
    public ImmutableList<EntityPose> fz() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.d() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.b;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.d()).e().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.b()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.d()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.cn.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.cn.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.cp.d ? new net.minecraft.world.item.ItemStack(Items.nH) : net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack) {
        this.gb().a(stack.d(), stack);
        this.b(StatisticList.c.b(stack.d()));
        world.a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.sx, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.z.a((EntityPlayer)this, stack);
        }
        return super.a(world, stack);
    }

    @Override
    protected boolean c(IBlockData landingState) {
        return this.cp.b || super.c(landingState);
    }

    @Override
    public Vec3D q(float delta) {
        float f3;
        double d0 = 0.22 * (this.fl() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dD(), this.O) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aV, this.aU) * ((float)Math.PI / 180);
        if (!this.fv() && !this.fi()) {
            if (this.bZ()) {
                return this.l(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cG().c() - 1.0;
            double d1 = this.bW() ? -0.2 : 0.07;
            return this.l(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.f(delta);
        Vec3D vec3d1 = this.do();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.l(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dK() {
        return true;
    }

    public boolean gp() {
        return this.fm() && this.fo().a(Items.qj);
    }

    @Override
    public boolean dJ() {
        return false;
    }

    public Optional<GlobalPos> gq() {
        return this.cv;
    }

    public void a(Optional<GlobalPos> lastDeathPos) {
        this.cv = lastDeathPos;
    }

    @Override
    public float eD() {
        return this.cl;
    }

    @Override
    public void m(float yaw) {
        super.m(yaw);
        this.cl = yaw;
    }

    @Override
    public boolean dE() {
        return true;
    }

    @Override
    protected float fd() {
        return this.cp.b && !this.bN() ? (this.bX() ? this.cp.a() * 2.0f : this.cp.a()) : (this.bX() ? 0.025999999f : 0.02f);
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

