/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public abstract class EntityFireball
extends IProjectile {
    public double b;
    public double c;
    public double d;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, double directionX, double directionY, double directionZ, World world) {
        this(type, world);
        this.b(x2, y2, z2, this.dB(), this.dD());
        this.ap();
        this.setDirection(directionX, directionY, directionZ);
    }

    public void setDirection(double d3, double d4, double d5) {
        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
        if (d6 != 0.0) {
            this.b = d3 / d6 * 0.1;
            this.c = d4 / d6 * 0.1;
            this.d = d5 / d6 * 0.1;
        }
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, EntityLiving owner, double directionX, double directionY, double directionZ, World world) {
        this(type, owner.dq(), owner.ds(), owner.dw(), directionX, directionY, directionZ, world);
        this.b((Entity)owner);
        this.a(owner.dB(), owner.dD());
    }

    @Override
    protected void a_() {
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cG().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public void l() {
        Entity entity = this.v();
        if (!this.dL().B && (entity != null && entity.dG() || !this.dL().A(this.dl()))) {
            this.ak();
        } else {
            MovingObjectPosition movingobjectposition;
            super.l();
            if (this.ae_()) {
                this.g(1);
            }
            if ((movingobjectposition = ProjectileHelper.a((Entity)this, this::a)).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                this.preOnHit(movingobjectposition);
                if (this.dG()) {
                    // empty if block
                }
            }
            this.aO();
            Vec3D vec3d = this.do();
            double d0 = this.dq() + vec3d.c;
            double d1 = this.ds() + vec3d.d;
            double d2 = this.dw() + vec3d.e;
            ProjectileHelper.a((Entity)this, 0.2f);
            float f2 = this.t();
            if (this.aX()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    float f1 = 0.25f;
                    this.dL().a(Particles.e, d0 - vec3d.c * 0.25, d1 - vec3d.d * 0.25, d2 - vec3d.e * 0.25, vec3d.c, vec3d.d, vec3d.e);
                }
                f2 = 0.8f;
            }
            this.f(vec3d.b(this.b, this.c, this.d).a((double)f2));
            this.dL().a(this.s(), d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            this.e(d0, d1, d2);
        }
    }

    @Override
    public boolean a(Entity entity) {
        return super.a(entity) && !entity.af;
    }

    protected boolean ae_() {
        return true;
    }

    protected ParticleParam s() {
        return Particles.Z;
    }

    protected float t() {
        return 0.95f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("power", this.a(new double[]{this.b, this.c, this.d}));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("power", 9) && (nbttaglist = nbt.c("power", 6)).size() == 3) {
            this.b = nbttaglist.h(0);
            this.c = nbttaglist.h(1);
            this.d = nbttaglist.h(2);
        }
    }

    @Override
    public boolean br() {
        return true;
    }

    @Override
    public float bD() {
        return 1.0f;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bo();
        Entity entity = source.d();
        if (entity != null) {
            if (!this.dL().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                    return false;
                }
                Vec3D vec3d = entity.bE();
                this.f(vec3d);
                this.b = vec3d.c * 0.1;
                this.c = vec3d.d * 0.1;
                this.d = vec3d.e * 0.1;
                this.b(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public float bm() {
        return 1.0f;
    }

    @Override
    public Packet<PacketListenerPlayOut> di() {
        Entity entity = this.v();
        int i2 = entity == null ? 0 : entity.ah();
        return new PacketPlayOutSpawnEntity(this.ah(), this.cv(), this.dq(), this.ds(), this.dw(), this.dD(), this.dB(), this.ag(), i2, new Vec3D(this.b, this.c, this.d), 0.0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double d0 = packet.i();
        double d1 = packet.j();
        double d2 = packet.k();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.b = d0 / d3 * 0.1;
            this.c = d1 / d3 * 0.1;
            this.d = d2 / d3 * 0.1;
        }
    }
}

