/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<OptionalInt> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.u);
    public static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    public int e;
    public int f;
    @Nullable
    public EntityLiving g;
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    public EntityFireworks(World world, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.M, world);
        this.e = 0;
        this.e(x2, y2, z2);
        int i2 = 1;
        if (!stack.b() && stack.u()) {
            this.an.b(b, stack.p());
            i2 += stack.a("Fireworks").f("Flight");
        }
        this.o(this.ag.a(0.0, 0.002297), 0.05, this.ag.a(0.0, 0.002297));
        this.f = 10 * i2 + this.ag.a(6) + this.ag.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double x2, double y2, double z2, ItemStack stack) {
        this(world, x2, y2, z2, stack);
        this.b(entity);
    }

    public EntityFireworks(World world, ItemStack stack, EntityLiving shooter) {
        this(world, shooter, shooter.dq(), shooter.ds(), shooter.dw(), stack);
        this.an.b(c, OptionalInt.of(shooter.ah()));
        this.g = shooter;
    }

    public EntityFireworks(World world, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, x2, y2, z2, stack);
        this.an.b(d, shotAtAngle);
    }

    public EntityFireworks(World world, ItemStack stack, Entity entity, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, stack, x2, y2, z2, shotAtAngle);
        this.b(entity);
    }

    @Override
    public void inactiveTick() {
        ++this.e;
        if (!this.dL().B && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.t();
        }
        super.inactiveTick();
    }

    @Override
    protected void a_() {
        this.an.a(b, ItemStack.b);
        this.an.a(c, OptionalInt.empty());
        this.an.a(d, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.y();
    }

    @Override
    public boolean k(double cameraX, double cameraY, double cameraZ) {
        return super.k(cameraX, cameraY, cameraZ) && !this.y();
    }

    @Override
    public void l() {
        super.l();
        if (this.y()) {
            if (this.g == null) {
                this.an.b(c).ifPresent(i2 -> {
                    Entity entity = this.dL().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.g = (EntityLiving)entity;
                    }
                });
            }
            if (this.g != null) {
                Vec3D vec3d;
                if (this.g.fv()) {
                    Vec3D vec3d1 = this.g.bE();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.g.do();
                    this.g.f(vec3d2.b(vec3d1.c * 0.1 + (vec3d1.c * 1.5 - vec3d2.c) * 0.5, vec3d1.d * 0.1 + (vec3d1.d * 1.5 - vec3d2.d) * 0.5, vec3d1.e * 0.1 + (vec3d1.e * 1.5 - vec3d2.e) * 0.5));
                    vec3d = this.g.a(Items.tA);
                } else {
                    vec3d = Vec3D.b;
                }
                this.e(this.g.dq() + vec3d.c, this.g.ds() + vec3d.d, this.g.dw() + vec3d.e);
                this.f(this.g.do());
            }
        } else {
            if (!this.s()) {
                double d2 = this.P ? 1.0 : 1.15;
                this.f(this.do().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d = this.do();
            this.a(EnumMoveType.a, vec3d);
            this.f(vec3d);
        }
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
        if (!this.af) {
            this.preOnHit(movingobjectposition);
            this.au = true;
        }
        this.H();
        if (this.e == 0 && !this.aS()) {
            this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.hI, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.e;
        if (this.dL().B && this.e % 2 < 2) {
            this.dL().a(Particles.A, this.dq(), this.ds(), this.dw(), this.ag.k() * 0.05, -this.do().d * 0.5, this.ag.k() * 0.05);
        }
        if (!this.dL().B && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.t();
        }
    }

    private void t() {
        this.dL().a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.v());
        this.x();
        this.ak();
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.dL().B && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.t();
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        BlockPosition blockposition = new BlockPosition(blockHitResult.a());
        this.dL().a_(blockposition).a(this.dL(), blockposition, (Entity)this);
        if (!this.dL().w_() && this.w() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.t();
        }
        super.a(blockHitResult);
    }

    @Override
    private boolean w() {
        ItemStack itemstack = this.an.b(b);
        NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
        NBTTagList nbttaglist = nbttagcompound != null ? nbttagcompound.c("Explosions", 10) : null;
        return nbttaglist != null && !nbttaglist.isEmpty();
    }

    private void x() {
        NBTTagList nbttaglist;
        float f2 = 0.0f;
        ItemStack itemstack = this.an.b(b);
        NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
        NBTTagList nBTTagList = nbttaglist = nbttagcompound != null ? nbttagcompound.c("Explosions", 10) : null;
        if (nbttaglist != null && !nbttaglist.isEmpty()) {
            f2 = 5.0f + (float)(nbttaglist.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.g != null) {
                CraftEventFactory.entityDamage = this;
                this.g.a(this.dM().a(this, this.v()), 5.0f + (float)(nbttaglist.size() * 2));
                CraftEventFactory.entityDamage = null;
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dj();
            List<EntityLiving> list = this.dL().a(EntityLiving.class, this.cG().g(5.0));
            for (EntityLiving entityliving : list) {
                if (entityliving == this.g || !(this.f(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dq(), entityliving.e(0.5 * (double)i2), entityliving.dw());
                    MovingObjectPositionBlock movingobjectpositionblock = this.dL().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (movingobjectpositionblock.c() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.e(entityliving)) / 5.0);
                CraftEventFactory.entityDamage = this;
                entityliving.a(this.dM().a(this, this.v()), f1);
                CraftEventFactory.entityDamage = null;
            }
        }
    }

    private boolean y() {
        return this.an.b(c).isPresent();
    }

    public boolean s() {
        return this.an.b(d);
    }

    @Override
    public void b(byte status) {
        if (status == 17 && this.dL().B) {
            if (!this.w()) {
                for (int i2 = 0; i2 < this.ag.a(3) + 2; ++i2) {
                    this.dL().a(Particles.W, this.dq(), this.ds(), this.dw(), this.ag.k() * 0.05, 0.005, this.ag.k() * 0.05);
                }
            } else {
                ItemStack itemstack = this.an.b(b);
                NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
                Vec3D vec3d = this.do();
                this.dL().a(this.dq(), this.ds(), this.dw(), vec3d.c, vec3d.d, vec3d.e, nbttagcompound);
            }
        }
        super.b(status);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Life", this.e);
        nbt.a("LifeTime", this.f);
        ItemStack itemstack = this.an.b(b);
        if (!itemstack.b()) {
            nbt.a("FireworksItem", itemstack.b(new NBTTagCompound()));
        }
        nbt.a("ShotAtAngle", this.an.b(d));
        if (this.spawningEntity != null) {
            nbt.a("SpawningEntity", this.spawningEntity);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Life");
        this.f = nbt.h("LifeTime");
        ItemStack itemstack = ItemStack.a(nbt.p("FireworksItem"));
        if (!itemstack.b()) {
            this.an.b(b, itemstack);
        }
        if (nbt.e("ShotAtAngle")) {
            this.an.b(d, nbt.q("ShotAtAngle"));
        }
        if (nbt.b("SpawningEntity")) {
            this.spawningEntity = nbt.a("SpawningEntity");
        }
    }

    @Override
    public ItemStack q() {
        ItemStack itemstack = this.an.b(b);
        return itemstack.b() ? new ItemStack(Items.tA) : itemstack;
    }

    @Override
    public boolean cp() {
        return false;
    }
}

