/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.jetbrains.annotations.Nullable;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double b = 4.0;
    private static final double d = 16.0;
    public static final Predicate<EntityLiving> c = entityliving -> entityliving.ff() || entityliving.bM();
    private static final Predicate<EntityLiving> APPLY_WATER_GET_ENTITIES_PREDICATE = c.or(Axolotl.class::isInstance);

    public EntityPotion(EntityTypes<? extends EntityPotion> type, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, world);
    }

    public EntityPotion(World world, EntityLiving owner) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aA, owner, world);
    }

    public EntityPotion(World world, double x2, double y2, double z2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aA, x2, y2, z2, world);
    }

    @Override
    protected Item s() {
        return Items.uu;
    }

    @Override
    protected float w() {
        return 0.05f;
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        if (!this.dL().B) {
            ItemStack itemstack = this.q();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean flag = potionregistry == Potions.c && list.isEmpty();
            EnumDirection enumdirection = blockHitResult.b();
            BlockPosition blockposition = blockHitResult.a();
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (flag) {
                this.a(blockposition1);
                this.a(blockposition1.a(enumdirection.g()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockposition1.a(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        this.splash(hitResult);
    }

    public void splash(@Nullable MovingObjectPosition hitResult) {
        if (!this.dL().B) {
            ItemStack itemstack = this.q();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean flag = potionregistry == Potions.c && list.isEmpty();
            boolean showParticles = true;
            showParticles = flag ? this.applyWater() : (this.y() ? this.makeAreaOfEffectCloud(itemstack, potionregistry, hitResult) : this.applySplash(list, hitResult != null && hitResult.c() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)hitResult).a() : null, hitResult));
            if (showParticles) {
                int i2 = potionregistry.b() ? 2007 : 2002;
                this.dL().c(i2, this.dl(), PotionUtil.c(itemstack));
            }
            this.ak();
        }
    }

    private boolean applyWater() {
        AxisAlignedBB axisalignedbb = this.cG().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.dL().a(EntityLiving.class, axisalignedbb, APPLY_WATER_GET_ENTITIES_PREDICATE);
        HashMap<CraftLivingEntity, Double> affected = new HashMap<CraftLivingEntity, Double>();
        HashSet<org.bukkit.entity.Axolotl> rehydrate = new HashSet<org.bukkit.entity.Axolotl>();
        HashSet<CraftLivingEntity> extinguish = new HashSet<CraftLivingEntity>();
        for (EntityLiving entityliving : list) {
            double d0;
            if (entityliving instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)entityliving;
                rehydrate.add((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity());
            }
            if (!((d0 = this.f(entityliving)) < 16.0)) continue;
            if (entityliving.ff()) {
                affected.put(entityliving.getBukkitLivingEntity(), 1.0);
            }
            if (!entityliving.bM() || !entityliving.bv()) continue;
            extinguish.add(entityliving.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = new WaterBottleSplashEvent((ThrownPotion)this.getBukkitEntity(), affected, rehydrate, extinguish);
        if (event.callEvent()) {
            for (LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().a(this.dM().c(this, this.v()), 1.0f);
            }
            for (LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().aD();
            }
            for (LivingEntity toRehydrate : event.getToRehydrate()) {
                EntityLiving entityLiving = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(entityLiving instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)entityLiving;
                axolotl.s();
            }
        }
        return !event.isCancelled();
    }

    private boolean applySplash(List<MobEffect> list, @javax.annotation.Nullable Entity entity, @javax.annotation.Nullable MovingObjectPosition position) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.cG().c(4.0, 2.0, 4.0);
        List<EntityLiving> list1 = this.dL().a(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list1.isEmpty()) {
            Entity entity1 = this.G();
            for (EntityLiving entityliving : list1) {
                double d0;
                if (!entityliving.fx() || !((d0 = this.f(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, position, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.G();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : list) {
                    MobEffectList mobeffectlist = mobeffect.c();
                    if (!this.dL().pvpMode && this.v() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.v() && (mobeffectlist == MobEffects.b || mobeffectlist == MobEffects.d || mobeffectlist == MobEffects.g || mobeffectlist == MobEffects.o || mobeffectlist == MobEffects.q || mobeffectlist == MobEffects.r || mobeffectlist == MobEffects.s)) continue;
                    if (mobeffectlist.a()) {
                        mobeffectlist.a(this, this.v(), entityliving, mobeffect.e(), d1);
                        continue;
                    }
                    int i2 = mobeffect.a(j2 -> (int)(d1 * (double)j2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(mobeffectlist, i2, mobeffect.e(), mobeffect.f(), mobeffect.g());
                    if (mobeffect1.a(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
        return !event.isCancelled();
    }

    private boolean makeAreaOfEffectCloud(ItemStack itemstack, PotionRegistry potionregistry, @javax.annotation.Nullable MovingObjectPosition position) {
        LingeringPotionSplashEvent event;
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dL(), this.dq(), this.ds(), this.dw());
        Entity entity = this.v();
        if (entity instanceof EntityLiving) {
            entityareaeffectcloud.a((EntityLiving)entity);
        }
        entityareaeffectcloud.a(3.0f);
        entityareaeffectcloud.b(-0.5f);
        entityareaeffectcloud.d(10);
        entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.m());
        entityareaeffectcloud.a(potionregistry);
        Iterator<MobEffect> iterator = PotionUtil.b(itemstack).iterator();
        boolean noEffects = potionregistry.a().isEmpty();
        while (iterator.hasNext()) {
            MobEffect mobeffect = iterator.next();
            entityareaeffectcloud.a(new MobEffect(mobeffect));
            noEffects = false;
        }
        NBTTagCompound nbttagcompound = itemstack.v();
        if (nbttagcompound != null && nbttagcompound.b("CustomPotionColor", 99)) {
            entityareaeffectcloud.a(nbttagcompound.h("CustomPotionColor"));
        }
        if (!((event = CraftEventFactory.callLingeringPotionSplashEvent(this, position, entityareaeffectcloud)).isCancelled() || entityareaeffectcloud.dG() || !event.allowsEmptyCreation() && noEffects && entityareaeffectcloud.o.isEmpty() && entityareaeffectcloud.t().a().isEmpty())) {
            this.dL().b(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.ak();
        }
        return !event.isCancelled();
    }

    public boolean y() {
        return this.q().a(Items.ux);
    }

    private void a(BlockPosition pos) {
        IBlockData iblockdata = this.dL().a_(pos);
        if (iblockdata.a(TagsBlock.aJ)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, iblockdata.u().g())) {
                this.dL().a(pos, false, this);
            }
        } else if (AbstractCandleBlock.c(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.a(AbstractCandleBlock.b, false))) {
                AbstractCandleBlock.a((EntityHuman)null, iblockdata, (GeneratorAccess)this.dL(), pos);
            }
        } else if (BlockCampfire.g(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.a(BlockCampfire.b, false))) {
            this.dL().a((EntityHuman)null, 1009, pos, 0);
            BlockCampfire.a(this.v(), (GeneratorAccess)this.dL(), pos, iblockdata);
            this.dL().b(pos, (IBlockData)iblockdata.a(BlockCampfire.b, false));
        }
    }
}

