/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityRaider.class, DataWatcherRegistry.k);
    static final Predicate<EntityItem> b = entityitem -> !entityitem.y() && entityitem.bv() && ItemStack.a(entityitem.q(), LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s());
    @Nullable
    protected Raid d;
    private int e;
    private boolean bT;
    private int bU;

    protected EntityRaider(EntityTypes<? extends EntityRaider> type, World world) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)type, world);
    }

    @Override
    protected void z() {
        super.z();
        this.bO.a(1, new b(this, this));
        this.bO.a(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.bO.a(4, new d(this, 1.05f, 1));
        this.bO.a(5, new c(this));
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(c, false);
    }

    public abstract void a(int var1, boolean var2);

    public boolean gq() {
        return this.bT;
    }

    public void z(boolean ableToJoinRaid) {
        this.bT = ableToJoinRaid;
    }

    @Override
    public void b_() {
        if (this.dL() instanceof WorldServer && this.bv()) {
            Raid raid = this.gr();
            if (this.gq()) {
                if (raid == null) {
                    Raid raid1;
                    if (this.dL().V() % 20L == 0L && (raid1 = ((WorldServer)this.dL()).c(this.dl())) != null && PersistentRaid.a(this, raid1)) {
                        raid1.a(raid1.k(), this, null, true);
                    }
                } else {
                    EntityLiving entityliving = this.q();
                    if (entityliving != null && (entityliving.ag() == EntityTypes.bt || entityliving.ag() == EntityTypes.ac)) {
                        this.bb = 0;
                    }
                }
            }
        }
        super.b_();
    }

    @Override
    protected void gi() {
        this.bb += 2;
    }

    @Override
    public void a(DamageSource damageSource) {
        if (this.dL() instanceof WorldServer) {
            Entity entity = damageSource.d();
            Raid raid = this.gr();
            if (raid != null) {
                if (this.gh()) {
                    raid.c(this.gt());
                }
                if (entity != null && entity.ag() == EntityTypes.bt) {
                    raid.a(entity);
                }
                raid.a(this, false);
            }
            if (this.gh() && (LeavesConfig.skipSelfRaidCheck || raid == null) && ((WorldServer)this.dL()).c(this.dl()) == null) {
                ItemStack itemstack = this.c(EnumItemSlot.f);
                EntityHuman entityhuman = null;
                if (entity instanceof EntityHuman) {
                    entityhuman = (EntityHuman)entity;
                } else if (entity instanceof EntityWolf) {
                    EntityWolf entitywolf = (EntityWolf)entity;
                    EntityLiving entityliving = entitywolf.O_();
                    if (entitywolf.s() && entityliving instanceof EntityHuman) {
                        entityhuman = (EntityHuman)entityliving;
                    }
                }
                if (!itemstack.b() && ItemStack.a(itemstack, LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s()) && entityhuman != null) {
                    int i2;
                    MobEffect mobeffect = entityhuman.b(MobEffects.E);
                    int b0 = 1;
                    if (mobeffect != null) {
                        i2 = b0 + mobeffect.e();
                        entityhuman.c(MobEffects.E);
                    } else {
                        i2 = b0 - 1;
                    }
                    i2 = MathHelper.a(i2, 0, 4);
                    MobEffect mobeffect1 = new MobEffect(MobEffects.E, 120000, i2, false, false, true);
                    if (!this.dL().X().b(GameRules.z)) {
                        entityhuman.addEffect(mobeffect1, EntityPotionEffectEvent.Cause.PATROL_CAPTAIN);
                    }
                }
            }
        }
        super.a(damageSource);
    }

    @Override
    public boolean gk() {
        return !this.gs();
    }

    public void a(@Nullable Raid raid) {
        this.d = raid;
    }

    @Nullable
    public Raid gr() {
        return this.d;
    }

    public boolean gs() {
        return this.gr() != null && this.gr().v();
    }

    public void b(int wave) {
        this.e = wave;
    }

    public int gt() {
        return this.e;
    }

    public boolean gu() {
        return this.an.b(c);
    }

    public void A(boolean celebrating) {
        this.an.b(c, celebrating);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Wave", this.e);
        nbt.a("CanJoinRaid", this.bT);
        if (this.d != null) {
            nbt.a("RaidId", this.d.u());
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Wave");
        this.bT = nbt.q("CanJoinRaid");
        if (nbt.b("RaidId", 3)) {
            if (this.dL() instanceof WorldServer) {
                this.d = ((WorldServer)this.dL()).x().a(nbt.h("RaidId"));
            }
            if (this.d != null) {
                this.d.a(this.e, this, false);
                if (this.gh()) {
                    this.d.a(this.e, this);
                }
            }
        }
    }

    @Override
    protected void b(EntityItem item) {
        boolean flag;
        ItemStack itemstack = item.q();
        boolean bl = flag = this.gs() && this.gr().b(this.gt()) != null;
        if (this.gs() && !flag && ItemStack.a(itemstack, LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s())) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, item, 0, false).isCancelled()) {
                return;
            }
            EnumItemSlot enumitemslot = EnumItemSlot.f;
            ItemStack itemstack1 = this.c(enumitemslot);
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.ag.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            this.a(item);
            this.a(enumitemslot, itemstack);
            this.a((Entity)item, itemstack.L());
            item.ak();
            this.gr().a(this.gt(), this);
            this.w(true);
        } else {
            super.b(item);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return this.gr() == null ? super.h(distanceSquared) : false;
    }

    @Override
    public boolean U() {
        return super.U() || this.gr() != null;
    }

    public int gv() {
        return this.bU;
    }

    public void c(int outOfRaidCounter) {
        this.bU = outOfRaidCounter;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.gs()) {
            this.gr().p();
        }
        return super.a(source, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.z(this.ag() != EntityTypes.bj || spawnReason != EnumMobSpawn.a);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public abstract SoundEffect ac_();

    public static class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T b;
        final /* synthetic */ EntityRaider this$0;

        public b(T entityraider) {
            this.this$0 = this$0;
            this.b = entityraider;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!((Entity)this.b).dL().X().b(GameRules.c) || !((EntityInsentient)this.b).fJ()) {
                return false;
            }
            Raid raid = ((EntityRaider)this.b).gr();
            if (((EntityRaider)this.b).gs() && !((EntityRaider)this.b).gr().a() && ((EntityMonsterPatrolling)this.b).ge() && !ItemStack.a(((EntityInsentient)this.b).c(EnumItemSlot.f), LeavesConfig.cacheOminousBannerItem ? Raid.LEADER_BANNER : Raid.s())) {
                List<EntityItem> list;
                EntityRaider entityraider = raid.b(((EntityRaider)this.b).gt());
                if (!(entityraider != null && entityraider.bv() || (list = ((Entity)this.b).dL().a(EntityItem.class, ((Entity)this.b).cG().c(16.0, 8.0, 16.0), b)).isEmpty())) {
                    return ((EntityInsentient)this.b).L().a((Entity)list.get(0), (double)1.15f);
                }
                return false;
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list;
            if (((EntityInsentient)this.b).L().h().a(((Entity)this.b).dj(), 1.414) && !(list = ((Entity)this.b).dL().a(EntityItem.class, ((Entity)this.b).cG().c(4.0, 4.0, 4.0), b)).isEmpty()) {
                ((EntityRaider)this.b).b(list.get(0));
            }
        }
    }

    private static class d
    extends PathfinderGoal {
        private final EntityRaider a;
        private final double b;
        private BlockPosition c;
        private final List<BlockPosition> d = Lists.newArrayList();
        private final int e;
        private boolean f;

        public d(EntityRaider raider, double speed, int distance) {
            this.a = raider;
            this.b = speed;
            this.e = distance;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.k();
            return this.h() && this.i() && this.a.q() == null;
        }

        private boolean h() {
            return this.a.gs() && !this.a.gr().a();
        }

        private boolean i() {
            WorldServer worldserver = (WorldServer)this.a.dL();
            BlockPosition blockposition = this.a.dl();
            Optional<BlockPosition> optional = worldserver.w().a(holder -> holder.a(PoiTypes.n), this::a, VillagePlace.Occupancy.c, blockposition, 48, this.a.ag);
            if (optional.isEmpty()) {
                return false;
            }
            this.c = optional.get().i();
            return true;
        }

        @Override
        public boolean b() {
            return this.a.L().l() ? false : this.a.q() == null && !this.c.a(this.a.dj(), (double)(this.a.df() + (float)this.e)) && !this.f;
        }

        @Override
        public void d() {
            if (this.c.a(this.a.dj(), (double)this.e)) {
                this.d.add(this.c);
            }
        }

        @Override
        public void c() {
            super.c();
            this.a.o(0);
            this.a.L().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), this.b);
            this.f = false;
        }

        @Override
        public void e() {
            if (this.a.L().l()) {
                Vec3D vec3d = Vec3D.c(this.c);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 7, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.f = true;
                    return;
                }
                this.a.L().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }

        private boolean a(BlockPosition pos) {
            BlockPosition blockposition1;
            Iterator<BlockPosition> iterator = this.d.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!Objects.equals(pos, blockposition1 = iterator.next()));
            return false;
        }

        private void k() {
            if (this.d.size() > 2) {
                this.d.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider b;

        c(EntityRaider entityraider) {
            this.b = entityraider;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            Raid raid = this.b.gr();
            return this.b.bv() && this.b.q() == null && raid != null && raid.f();
        }

        @Override
        public void c() {
            this.b.A(true);
            super.c();
        }

        @Override
        public void d() {
            this.b.A(false);
            super.d();
        }

        @Override
        public void e() {
            if (!this.b.aS() && this.b.ag.a(this.a(100)) == 0) {
                EntityRaider.this.a(EntityRaider.this.ac_(), EntityRaider.this.eV(), EntityRaider.this.eW());
            }
            if (!this.b.bN() && this.b.ag.a(this.a(50)) == 0) {
                this.b.K().a();
            }
            super.e();
        }
    }

    protected class a
    extends PathfinderGoal {
        private final EntityRaider c;
        private final float d;
        public final PathfinderTargetCondition a = PathfinderTargetCondition.b().a(8.0).d().e();

        public a(EntityIllagerAbstract entityillagerabstract, float f2) {
            this.c = entityillagerabstract;
            this.d = f2 * f2;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.c.eg();
            return this.c.gr() == null && this.c.gm() && this.c.q() != null && !this.c.fV() && (entityliving == null || entityliving.ag() != EntityTypes.bt);
        }

        @Override
        public void c() {
            super.c();
            this.c.L().n();
            List<EntityRaider> list = this.c.dL().a(EntityRaider.class, this.a, this.c, this.c.cG().c(8.0, 8.0, 8.0));
            for (EntityRaider entityraider : list) {
                entityraider.setTarget(this.c.q(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        @Override
        public void d() {
            super.d();
            EntityLiving entityliving = this.c.q();
            if (entityliving != null) {
                List<EntityRaider> list = this.c.dL().a(EntityRaider.class, this.a, this.c, this.c.cG().c(8.0, 8.0, 8.0));
                for (EntityRaider entityraider : list) {
                    entityraider.setTarget(this.c.q(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    entityraider.v(true);
                }
                this.c.v(true);
            }
        }

        @Override
        public boolean Q_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.c.q();
            if (entityliving != null) {
                if (this.c.f((Entity)entityliving) > (double)this.d) {
                    this.c.G().a(entityliving, 30.0f, 30.0f);
                    if (this.c.ag.a(50) == 0) {
                        this.c.P();
                    }
                } else {
                    this.c.v(true);
                }
                super.e();
            }
        }
    }
}

