/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperContainerEntityLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements ContainerEntity {
    private NonNullList<ItemStack> c;
    @Nullable
    public MinecraftKey d;
    public long e;
    public List<HumanEntity> transaction;
    private int maxStack;

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public PaperLootableInventoryData getLootableData() {
        return this.lootableData;
    }

    @Override
    public List<ItemStack> getContents() {
        return this.c;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        CraftEntity cart = this.getBukkitEntity();
        if (cart instanceof InventoryHolder) {
            return (InventoryHolder)cart;
        }
        return null;
    }

    @Override
    public int ag_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.getBukkitEntity().getLocation();
    }

    protected EntityMinecartContainer(EntityTypes<?> type, World world) {
        super(type, world);
        this.lootableData = new PaperLootableInventoryData(new PaperContainerEntityLootableInventory(this));
        this.transaction = new ArrayList<HumanEntity>();
        this.maxStack = 64;
        this.c = NonNullList.a(this.b(), ItemStack.b);
    }

    protected EntityMinecartContainer(EntityTypes<?> type, double x2, double y2, double z2, World world) {
        super(type, world, x2, y2, z2);
        this.lootableData = new PaperLootableInventoryData(new PaperContainerEntityLootableInventory(this));
        this.transaction = new ArrayList<HumanEntity>();
        this.maxStack = 64;
        this.c = NonNullList.a(this.b(), ItemStack.b);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.a(damageSource, this.dL(), this);
    }

    @Override
    public ItemStack a(int slot) {
        return this.f_(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        return this.b(slot, amount);
    }

    @Override
    public ItemStack b(int slot) {
        return this.e_(slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.c(slot, stack);
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return this.g_(mappedIndex);
    }

    @Override
    public void e() {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncEntityToClient(this);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.g(player);
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        if (!this.dL().B && reason.a()) {
            InventoryUtils.a(this.dL(), this, (IInventory)this);
        }
        super.a(reason);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.lootableData.saveNbt(nbt);
        this.c(nbt);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.lootableData.loadNbt(nbt);
        this.b_(nbt);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return this.c_(player);
    }

    @Override
    protected void v() {
        float f2 = 0.98f;
        if (this.d == null) {
            int i2 = 15 - Container.b(this);
            f2 += (float)i2 * 0.001f;
        }
        if (this.aX()) {
            f2 *= 0.95f;
        }
        this.f(this.do().d(f2, 0.0, f2));
    }

    @Override
    public void a() {
        this.f();
    }

    public void a(MinecraftKey id, long lootSeed) {
        this.d = id;
        this.e = lootSeed;
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
        if (this.d != null && player.M_()) {
            return null;
        }
        this.f(playerInventory.m);
        return this.a(syncId, playerInventory);
    }

    protected abstract Container a(int var1, PlayerInventory var2);

    @Override
    @Nullable
    public MinecraftKey G() {
        return this.d;
    }

    @Override
    public void a(@Nullable MinecraftKey lootTableId) {
        this.d = lootTableId;
    }

    @Override
    public long H() {
        return this.e;
    }

    @Override
    public void a(long lootTableSeed) {
        this.e = lootTableSeed;
    }

    @Override
    public NonNullList<ItemStack> I() {
        return this.c;
    }

    @Override
    public void K() {
        this.c = NonNullList.a(this.b(), ItemStack.b);
    }
}

