/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;

public class ItemArmor
extends Item
implements Equipable {
    private static final EnumMap<a, UUID> e = SystemUtils.a(new EnumMap(a.class), (? super T enummap) -> {
        enummap.put(net.minecraft.world.item.ItemArmor$a.d, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        enummap.put(net.minecraft.world.item.ItemArmor$a.c, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        enummap.put(net.minecraft.world.item.ItemArmor$a.b, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        enummap.put(net.minecraft.world.item.ItemArmor$a.a, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public static final IDispenseBehavior a = new DispenseBehaviorItem(){

        @Override
        protected ItemStack a(SourceBlock pointer, ItemStack stack) {
            return ItemArmor.a(pointer, stack) ? stack : super.a(pointer, stack);
        }
    };
    protected final a b;
    private final int f;
    private final float g;
    protected final float c;
    protected final ArmorMaterial d;
    private final Multimap<AttributeBase, AttributeModifier> h;

    public static boolean a(SourceBlock pointer, ItemStack armor) {
        BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.a));
        List<Entity> list = pointer.b().a(EntityLiving.class, new AxisAlignedBB(blockposition), IEntitySelector.f.and(new IEntitySelector.EntitySelectorEquipable(armor)));
        if (list.isEmpty()) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)list.get(0);
        EnumItemSlot enumitemslot = EntityInsentient.h(armor);
        ItemStack itemstack1 = armor.c(1);
        WorldServer world = pointer.b();
        CraftBlock block = CraftBlock.at(world, pointer.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (org.bukkit.inventory.ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityliving.getBukkitEntity()));
        if (!BlockDispenser.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.d.get(eventStack.d());
            if (idispensebehavior != IDispenseBehavior.b && idispensebehavior != a) {
                idispensebehavior.dispense(pointer, eventStack);
                return true;
            }
        }
        entityliving.a(enumitemslot, CraftItemStack.asNMSCopy(event.getItem()));
        if (entityliving instanceof EntityInsentient) {
            ((EntityInsentient)entityliving).a(enumitemslot, 2.0f);
            ((EntityInsentient)entityliving).fI();
        }
        if (shrink) {
            armor.h(1);
        }
        return true;
    }

    public ItemArmor(ArmorMaterial material, a type, Item.Info settings) {
        super(settings.b(material.a(type)));
        this.d = material;
        this.b = type;
        this.f = material.b(type);
        this.g = material.f();
        this.c = material.g();
        BlockDispenser.a(this, a);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = e.get((Object)type);
        builder.put((Object)GenericAttributes.i, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.f, AttributeModifier.Operation.a));
        builder.put((Object)GenericAttributes.j, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.g, AttributeModifier.Operation.a));
        if (material == EnumArmorMaterial.g) {
            builder.put((Object)GenericAttributes.c, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.c, AttributeModifier.Operation.a));
        }
        this.h = builder.build();
    }

    public a b() {
        return this.b;
    }

    @Override
    public int c() {
        return this.d.a();
    }

    public ArmorMaterial d() {
        return this.d;
    }

    @Override
    public boolean a(ItemStack stack, ItemStack ingredient) {
        return this.d.d().a(ingredient) || super.a(stack, ingredient);
    }

    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        return this.a(this, world, user, hand);
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        return slot == this.b.a() ? this.h : super.a(slot);
    }

    public int e() {
        return this.f;
    }

    public float f() {
        return this.g;
    }

    @Override
    public EnumItemSlot g() {
        return this.b.a();
    }

    @Override
    public SoundEffect ao_() {
        return this.d().b();
    }

    public static enum a {
        a(EnumItemSlot.f, "helmet"),
        b(EnumItemSlot.e, "chestplate"),
        c(EnumItemSlot.d, "leggings"),
        d(EnumItemSlot.c, "boots");

        private final EnumItemSlot e;
        private final String f;

        private a(EnumItemSlot enumitemslot, String s2) {
            this.e = enumitemslot;
            this.f = s2;
        }

        public EnumItemSlot a() {
            return this.e;
        }

        public String b() {
            return this.f;
        }
    }
}

