/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.inventory.recipe.RecipeBookExactChoiceRecipe;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.NotImplementedException;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import top.leavesmc.leaves.util.ArrayConstants;

public class ShapedRecipes
extends RecipeBookExactChoiceRecipe<InventoryCrafting>
implements RecipeCrafting {
    final int a;
    final int b;
    final NonNullList<RecipeItemStack> c;
    final ItemStack d;
    final String e;
    final CraftingBookCategory f;
    final boolean g;

    public ShapedRecipes(String group, CraftingBookCategory category, int width, int height, NonNullList<RecipeItemStack> ingredients, ItemStack result, boolean showNotification) {
        this.e = group;
        this.f = category;
        this.a = width;
        this.b = height;
        this.c = ingredients;
        this.d = result;
        this.g = showNotification;
        this.checkExactIngredients();
    }

    public ShapedRecipes(String group, CraftingBookCategory category, int width, int height, NonNullList<RecipeItemStack> ingredients, ItemStack result) {
        this(group, category, width, height, ingredients, result, true);
    }

    public ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.e);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        block0 : switch (this.b) {
            case 1: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (RecipeItemStack list : this.c) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != null) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<?> an_() {
        return RecipeSerializer.a;
    }

    @Override
    public String c() {
        return this.e;
    }

    @Override
    public CraftingBookCategory d() {
        return this.f;
    }

    @Override
    public ItemStack a(IRegistryCustom registryManager) {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.c;
    }

    @Override
    public boolean h() {
        return this.g;
    }

    @Override
    public boolean a(int width, int height) {
        return width >= this.a && height >= this.b;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        for (int i2 = 0; i2 <= inventory.f() - this.a; ++i2) {
            for (int j2 = 0; j2 <= inventory.g() - this.b; ++j2) {
                if (this.a(inventory, i2, j2, true)) {
                    return true;
                }
                if (!this.a(inventory, i2, j2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(InventoryCrafting inv, int offsetX, int offsetY, boolean flipped) {
        for (int k2 = 0; k2 < inv.f(); ++k2) {
            for (int l2 = 0; l2 < inv.g(); ++l2) {
                int i1 = k2 - offsetX;
                int j1 = l2 - offsetY;
                RecipeItemStack recipeitemstack = RecipeItemStack.a;
                if (i1 >= 0 && j1 >= 0 && i1 < this.a && j1 < this.b) {
                    recipeitemstack = flipped ? this.c.get(this.a - i1 - 1 + j1 * this.a) : this.c.get(i1 + j1 * this.a);
                }
                if (recipeitemstack.a(inv.a(k2 + l2 * inv.f()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack a(InventoryCrafting inventory, IRegistryCustom registryManager) {
        return this.a(registryManager).p();
    }

    public int j() {
        return this.a;
    }

    public int k() {
        return this.b;
    }

    @VisibleForTesting
    static String[] a(List<String> pattern) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int i1 = 0; i1 < pattern.size(); ++i1) {
            String s2 = pattern.get(i1);
            i2 = Math.min(i2, ShapedRecipes.a(s2));
            int j1 = ShapedRecipes.b(s2);
            j2 = Math.max(j2, j1);
            if (j1 < 0) {
                if (k2 == i1) {
                    ++k2;
                }
                ++l2;
                continue;
            }
            l2 = 0;
        }
        if (pattern.size() == l2) {
            return ArrayConstants.emptyStringArray;
        }
        String[] astring = new String[pattern.size() - l2 - k2];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = pattern.get(k1 + k2).substring(i2, j2 + 1);
        }
        return astring;
    }

    @Override
    public boolean i() {
        NonNullList<RecipeItemStack> nonnulllist = this.a();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(recipeitemstack -> !recipeitemstack.c()).anyMatch(recipeitemstack -> recipeitemstack.a().length == 0);
    }

    private static int a(String line) {
        int i2;
        for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String pattern) {
        int i2;
        for (i2 = pattern.length() - 1; i2 >= 0 && pattern.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        static final Codec<List<String>> x = Codec.STRING.listOf().flatXmap(list -> {
            String s2;
            if (list.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (list.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i2 = ((String)list.get(0)).length();
            Iterator iterator = list.iterator();
            do {
                if (!iterator.hasNext()) {
                    return DataResult.success((Object)list);
                }
                s2 = (String)iterator.next();
                if (s2.length() <= 3) continue;
                return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
            } while (i2 == s2.length());
            return DataResult.error(() -> "Invalid pattern: each row must be the same width");
        }, DataResult::success);
        static final Codec<String> y = Codec.STRING.flatXmap(s2 -> s2.length() != 1 ? DataResult.error(() -> "Invalid key entry: '" + s2 + "' is an invalid symbol (must be 1 character only).") : (" ".equals(s2) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)s2)), DataResult::success);
        private static final Codec<ShapedRecipes> z = RawShapedRecipe.a.flatXmap(shapedrecipes_serializer_rawshapedrecipe -> {
            String[] astring = ShapedRecipes.a(shapedrecipes_serializer_rawshapedrecipe.e);
            int i2 = astring[0].length();
            int j2 = astring.length;
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2 * j2, RecipeItemStack.a);
            HashSet set = Sets.newHashSet(shapedrecipes_serializer_rawshapedrecipe.d.keySet());
            for (int k2 = 0; k2 < astring.length; ++k2) {
                String s2 = astring[k2];
                for (int l2 = 0; l2 < s2.length(); ++l2) {
                    RecipeItemStack recipeitemstack;
                    String s1 = s2.substring(l2, l2 + 1);
                    RecipeItemStack recipeItemStack = recipeitemstack = s1.equals(" ") ? RecipeItemStack.a : shapedrecipes_serializer_rawshapedrecipe.d.get(s1);
                    if (recipeitemstack == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + s1 + "' but it's not defined in the key");
                    }
                    set.remove(s1);
                    nonnulllist.set(l2 + i2 * k2, recipeitemstack);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + set);
            }
            ShapedRecipes shapedrecipes = new ShapedRecipes(shapedrecipes_serializer_rawshapedrecipe.b, shapedrecipes_serializer_rawshapedrecipe.c, i2, j2, nonnulllist, shapedrecipes_serializer_rawshapedrecipe.f, shapedrecipes_serializer_rawshapedrecipe.g);
            return DataResult.success((Object)shapedrecipes);
        }, shapedrecipes -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        @Override
        public Codec<ShapedRecipes> a() {
            return z;
        }

        public ShapedRecipes b(PacketDataSerializer buf) {
            int i2 = buf.m();
            int j2 = buf.m();
            String s2 = buf.r();
            CraftingBookCategory craftingbookcategory = buf.b(CraftingBookCategory.class);
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2 * j2, RecipeItemStack.a);
            for (int k2 = 0; k2 < nonnulllist.size(); ++k2) {
                nonnulllist.set(k2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.q();
            boolean flag = buf.readBoolean();
            return new ShapedRecipes(s2, craftingbookcategory, i2, j2, nonnulllist, itemstack, flag);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapedRecipes recipe) {
            buf.c(recipe.a);
            buf.c(recipe.b);
            buf.a(recipe.e);
            buf.a(recipe.f);
            for (RecipeItemStack recipeitemstack : recipe.c) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.d);
            buf.a(recipe.g);
        }

        private static final class RawShapedRecipe
        extends Record {
            private final String b;
            private final CraftingBookCategory c;
            private final Map<String, RecipeItemStack> d;
            private final List<String> e;
            private final ItemStack f;
            private final boolean g;
            public static final Codec<RawShapedRecipe> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(Codec.STRING, "group", "").forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.b), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.c), (App)ExtraCodecs.d(y, RecipeItemStack.c).fieldOf("key").forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.d), (App)x.fieldOf("pattern").forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.e), (App)CraftingRecipeCodecs.a.fieldOf("result").forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.f), (App)ExtraCodecs.a(Codec.BOOL, "show_notification", true).forGetter(shapedrecipes_serializer_rawshapedrecipe -> shapedrecipes_serializer_rawshapedrecipe.g)).apply((Applicative)instance, RawShapedRecipe::new));

            private RawShapedRecipe(String group, CraftingBookCategory category, Map<String, RecipeItemStack> key, List<String> pattern, ItemStack result, boolean showNotification) {
                this.b = group;
                this.c = category;
                this.d = key;
                this.e = pattern;
                this.f = result;
                this.g = showNotification;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "b", "c", "d", "e", "f", "g"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "b", "c", "d", "e", "f", "g"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RawShapedRecipe.class, "group;category;key;pattern;result;showNotification", "b", "c", "d", "e", "f", "g"}, this, o2);
            }

            public String a() {
                return this.b;
            }

            public CraftingBookCategory b() {
                return this.c;
            }

            public Map<String, RecipeItemStack> c() {
                return this.d;
            }

            public List<String> d() {
                return this.e;
            }

            public ItemStack e() {
                return this.f;
            }

            public boolean f() {
                return this.g;
            }
        }
    }
}

