/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.CoordinateUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private final boolean c;
    private final Effect d;
    private final RandomSource e = RandomSource.a();
    private final World f;
    private final double g;
    private final double h;
    private final double i;
    @Nullable
    public final net.minecraft.world.entity.Entity j;
    private final float k;
    private final DamageSource l;
    private final ExplosionDamageCalculator m;
    private final ObjectArrayList<BlockPosition> n = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> o = Maps.newHashMap();
    public boolean wasCanceled = false;
    private static final double[] CACHED_RAYS;
    private static final int CHUNK_CACHE_SHIFT = 2;
    private static final int CHUNK_CACHE_MASK = 3;
    private static final int CHUNK_CACHE_WIDTH = 4;
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    private static final Float ZERO_RESISTANCE;
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    private long[] chunkPosCache = null;
    private Chunk[] chunkCache = null;

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, List<BlockPosition> affectedBlocks) {
        this(world, entity, x2, y2, z2, power, false, Effect.c, affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType, List<BlockPosition> affectedBlocks) {
        this(world, entity, x2, y2, z2, power, createFire, destructionType);
        this.n.addAll(affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType) {
        this(world, entity, null, null, x2, y2, z2, power, createFire, destructionType);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType) {
        this.f = world;
        this.j = entity;
        this.k = (float)Math.max((double)power, 0.0);
        this.g = x2;
        this.h = y2;
        this.i = z2;
        this.c = createFire;
        this.d = destructionType;
        this.l = damageSource == null ? world.ag().a(this) : damageSource;
        this.m = behavior == null ? this.a(entity) : behavior;
    }

    private ExplosionBlockCache getOrCacheExplosionBlock(int x2, int y2, int z2, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        if (!this.f.j(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            Chunk chunk;
            int chunkCacheKey = x2 >> 4 & 3 | z2 >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x2 >> 4, z2 >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.f.d(x2 >> 4, z2 >> 4);
            }
            IBlockData blockState = chunk.getBlockStateFinal(x2, y2, z2);
            Fluid fluidState = blockState.u();
            Optional<Float> resistance = !calculateResistance ? Optional.empty() : this.m.a(this, (IBlockAccess)this.f, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    private boolean clipsAnything(Vec3D from, Vec3D to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition currPos) {
        double adjX = 1.0E-7 * (from.c - to.c);
        double adjY = 1.0E-7 * (from.d - to.d);
        double adjZ = 1.0E-7 * (from.e - to.e);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.c - adjX;
        double toYAdj = to.d - adjY;
        double toZAdj = to.e - adjZ;
        double fromXAdj = from.c + adjX;
        double fromYAdj = from.d + adjY;
        double fromZAdj = from.e + adjZ;
        int currX = MathHelper.a(fromXAdj);
        int currY = MathHelper.a(fromYAdj);
        int currZ = MathHelper.a(fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.e(fromXAdj) : MathHelper.e(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.e(fromYAdj) : MathHelper.e(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.e(fromZAdj) : MathHelper.e(fromZAdj));
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            long key = BlockPosition.a(currX, currY, currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !blockState.emptyCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = blockState.getConstantCollisionShape();
                    if (collision == null) {
                        collision = blockState.b((IBlockAccess)this.f, (BlockPosition)currPos, context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.c() && collision.a(from, to, currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    private float getSeenFraction(Vec3D source, net.minecraft.world.entity.Entity target, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition blockPos) {
        AxisAlignedBB boundingBox = target.cG();
        double diffX = boundingBox.d - boundingBox.a;
        double diffY = boundingBox.e - boundingBox.b;
        double diffZ = boundingBox.f - boundingBox.c;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.a;
        double offY = boundingBox.b;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.c;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3D from = new Vec3D(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    private ExplosionDamageCalculator a(@Nullable net.minecraft.world.entity.Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D source, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cG();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = MathHelper.d(d5, axisalignedbb.a, axisalignedbb.d);
                        double d9 = MathHelper.d(d6, axisalignedbb.b, axisalignedbb.e);
                        double d10 = MathHelper.d(d7, axisalignedbb.c, axisalignedbb.f);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dL().a(new RayTrace(vec3d1, source, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public void a() {
        if (this.k < 0.1f) {
            return;
        }
        this.f.a(this.j, GameEvent.w, new Vec3D(this.g, this.h, this.i));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkCoordIntPair.a);
        this.chunkCache = new Chunk[16];
        ExplosionBlockCache[] blockCache = new ExplosionBlockCache[512];
        int blockX = MathHelper.a(this.g);
        int blockY = MathHelper.a(this.h);
        int blockZ = MathHelper.a(this.i);
        long key = BlockPosition.a(blockX, blockY, blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double d0 = CACHED_RAYS[ray];
            double d1 = CACHED_RAYS[ray + 1];
            double d2 = CACHED_RAYS[ray + 2];
            ray += 3;
            double d4 = this.g;
            double d5 = this.h;
            double d6 = this.i;
            float f1 = 0.3f;
            for (float f2 = this.k * (0.7f + this.f.z.i() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2 = MathHelper.a(d4);
                long key2 = BlockPosition.a(blockX2, blockY2 = MathHelper.a(d5), blockZ2 = MathHelper.a(d6));
                if (cachedBlock.key != key2 && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                BlockPosition blockposition = cachedBlock.immutablePos;
                IBlockData iblockdata = cachedBlock.blockState;
                if (!iblockdata.isDestroyable()) continue;
                if ((f2 -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = this.m.a(this, (IBlockAccess)this.f, cachedBlock.immutablePos, cachedBlock.blockState, f2);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.c || !cachedBlock.blockState.i())) {
                        TileEntityPiston blockEntity;
                        TileEntity extension;
                        set.add(blockposition);
                        if (!GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons && iblockdata.b() == Blocks.bQ && (extension = this.f.c_(blockposition)) instanceof TileEntityPiston && (blockEntity = (TileEntityPiston)extension).f()) {
                            EnumDirection direction = iblockdata.c(BlockDirectional.a);
                            set.add(blockposition.a(direction.g()));
                        }
                    }
                }
                d4 += d0;
                d5 += d1;
                d6 += d2;
            }
        }
        this.n.addAll((Collection)set);
        float f2 = this.k * 2.0f;
        int i2 = MathHelper.a(this.g - (double)f2 - 1.0);
        int j2 = MathHelper.a(this.g + (double)f2 + 1.0);
        int l2 = MathHelper.a(this.h - (double)f2 - 1.0);
        int i1 = MathHelper.a(this.h + (double)f2 + 1.0);
        int j1 = MathHelper.a(this.i - (double)f2 - 1.0);
        int k1 = MathHelper.a(this.i + (double)f2 + 1.0);
        List<net.minecraft.world.entity.Entity> list = this.f.a(this.j, new AxisAlignedBB(i2, l2, j1, j2, i1, k1), (Predicate<? super net.minecraft.world.entity.Entity>)((com.google.common.base.Predicate)entity -> entity.bv() && !entity.M_()));
        Vec3D vec3d = new Vec3D(this.g, this.h, this.i);
        Iterator<net.minecraft.world.entity.Entity> iterator = list.iterator();
        BlockPosition.MutableBlockPosition blockPos = new BlockPosition.MutableBlockPosition();
        while (iterator.hasNext()) {
            EntityHuman entityhuman;
            double d14;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            net.minecraft.world.entity.Entity entity2 = iterator.next();
            if (entity2.cL() || !((d7 = Math.sqrt(entity2.e(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity2.dq() - this.g) * d8 + (d9 = (entity2 instanceof EntityTNTPrimed ? entity2.ds() : entity2.du()) - this.h) * d9 + (d10 = entity2.dw() - this.i) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            double d12 = this.getBlockDensity(vec3d, entity2, blockCache, blockPos);
            double d13 = (1.0 - d7) * d12;
            if (entity2 instanceof EntityComplexPart) continue;
            CraftEventFactory.entityDamage = this.j;
            entity2.lastDamageCancelled = false;
            if (entity2 instanceof EntityEnderDragon) {
                for (EntityComplexPart entityComplexPart : ((EntityEnderDragon)entity2).cf) {
                    double d2;
                    if (!list.contains(entityComplexPart)) continue;
                    double d7part = Math.sqrt(entityComplexPart.e(vec3d)) / (double)f2;
                    if (!(d2 <= 1.0)) continue;
                    double d13part = (1.0 - d7part) * (double)this.getSeenFraction(vec3d, entityComplexPart, blockCache, blockPos);
                    entityComplexPart.a(this.c(), (float)((int)((d13part * d13part + d13part) / 2.0 * 7.0 * (double)f2 + 1.0)));
                }
            } else {
                entity2.a(this.c(), (float)((int)((d13 * d13 + d13) / 2.0 * 7.0 * (double)f2 + 1.0)));
            }
            CraftEventFactory.entityDamage = null;
            if (entity2.lastDamageCancelled) continue;
            if (entity2 instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity2;
                d14 = entity2 instanceof EntityHuman && this.f.paperConfig().environment.disableExplosionKnockback ? 0.0 : EnchantmentProtection.a(entityliving, d13);
            } else {
                d14 = d13;
            }
            Vec3D vec3d1 = new Vec3D(d8 *= d14, d9 *= d14, d10 *= d14);
            entity2.f(entity2.do().e(vec3d1));
            if (!(entity2 instanceof EntityHuman) || (entityhuman = (EntityHuman)entity2).M_() || entityhuman.f() && entityhuman.fS().b || this.f.paperConfig().environment.disableExplosionKnockback) continue;
            this.o.put(entityhuman, vec3d1);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
    }

    public void a(boolean particles) {
        if (this.f.B) {
            this.f.a(this.g, this.h, this.i, SoundEffects.iX, SoundCategory.e, 4.0f, (1.0f + (this.f.z.i() - this.f.z.i()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.b();
        if (particles) {
            if (this.k >= 2.0f && flag1) {
                this.f.a(Particles.w, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            } else {
                this.f.a(Particles.x, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            }
        }
        if (flag1) {
            float yield;
            List bukkitBlocks;
            boolean cancelled;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag2 = this.e() instanceof EntityHuman;
            SystemUtils.b(this.n, this.f.z);
            ObjectListIterator objectlistiterator = this.n.iterator();
            CraftWorld bworld = this.f.getWorld();
            CraftEntity explode = this.j == null ? null : this.j.getBukkitEntity();
            Location location = new Location((org.bukkit.World)bworld, this.g, this.h, this.i);
            ObjectArrayList blockList = new ObjectArrayList();
            for (int i1 = this.n.size() - 1; i1 >= 0; --i1) {
                BlockPosition cpos = (BlockPosition)this.n.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (explode != null) {
                event = new EntityExplodeEvent((Entity)explode, location, (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            } else {
                event = new BlockExplodeEvent(location.getBlock(), (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f, this.l.explodedBlockState);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            }
            this.n.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.n.add((Object)coords);
            }
            if (cancelled) {
                this.wasCanceled = true;
                return;
            }
            for (BlockPosition blockposition : this.n) {
                World world;
                IBlockData iblockdata = this.f.a_(blockposition);
                Block block = iblockdata.b();
                if (block instanceof BlockTNT) {
                    BlockPosition sourceBlock;
                    net.minecraft.world.entity.Entity sourceEntity = this.j == null ? null : this.j;
                    BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.a(this.g, this.h, this.i) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.f.a(blockposition, Blocks.a.n(), iblockdata, 3);
                        continue;
                    }
                }
                if (iblockdata.i() || !iblockdata.isDestroyable()) continue;
                BlockPosition blockposition1 = blockposition.i();
                this.f.ad().a("explosion_blocks");
                if (block.a(this) && (world = this.f) instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    TileEntity tileentity = iblockdata.t() ? this.f.c_(blockposition) : null;
                    LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.b).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, this.j);
                    if (yield < 1.0f) {
                        lootparams_a.a(LootContextParameters.j, Float.valueOf(1.0f / yield));
                    }
                    iblockdata.a(worldserver, blockposition, ItemStack.b, flag2);
                    iblockdata.a(lootparams_a).forEach(itemstack -> Explosion.a((ObjectArrayList<Pair<ItemStack, BlockPosition>>)objectarraylist, itemstack, blockposition1));
                }
                this.f.a(blockposition, Blocks.a.n(), 3);
                block.a(this.f, blockposition, this);
                this.f.ad().c();
            }
            for (Pair pair : objectarraylist) {
                Block.a(this.f, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
        }
        if (this.c) {
            for (BlockPosition blockposition2 : this.n) {
                if (this.e.a(3) != 0 || !this.f.a_(blockposition2).i() || !this.f.a_(blockposition2.d()).i(this.f, blockposition2.d()) || CraftEventFactory.callBlockIgniteEvent(this.f, blockposition2.u(), blockposition2.v(), blockposition2.w(), this).isCancelled()) continue;
                this.f.b(blockposition2, BlockFireAbstract.a(this.f, blockposition2));
            }
        }
    }

    public boolean b() {
        return this.d != Effect.a;
    }

    private static void a(ObjectArrayList<Pair<ItemStack, BlockPosition>> stacks, ItemStack stack, BlockPosition pos) {
        if (stack.b()) {
            return;
        }
        int i2 = stacks.size();
        for (int j2 = 0; j2 < i2; ++j2) {
            Pair pair = (Pair)stacks.get(j2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!EntityItem.a(itemstack1, stack)) continue;
            ItemStack itemstack2 = EntityItem.a(itemstack1, stack, 16);
            stacks.set(j2, (Object)Pair.of((Object)itemstack2, (Object)((BlockPosition)pair.getSecond())));
            if (!stack.b()) continue;
            return;
        }
        stacks.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public DamageSource c() {
        return this.l;
    }

    public Map<EntityHuman, Vec3D> d() {
        return this.o;
    }

    @Nullable
    public EntityLiving e() {
        IProjectile iprojectile;
        if (this.j == null) {
            return null;
        }
        net.minecraft.world.entity.Entity entity = this.j;
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            return entitytntprimed.q();
        }
        entity = this.j;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving;
        }
        entity = this.j;
        if (entity instanceof IProjectile && (entity = (iprojectile = (IProjectile)entity).v()) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity f() {
        return this.j;
    }

    public void g() {
        this.n.clear();
    }

    public List<BlockPosition> h() {
        return this.n;
    }

    private float getBlockDensity(Vec3D vec3d, net.minecraft.world.entity.Entity entity, ExplosionBlockCache[] blockCache, BlockPosition.MutableBlockPosition blockPos) {
        if (!this.f.paperConfig().environment.optimizeExplosions) {
            return this.getSeenFraction(vec3d, entity, blockCache, blockPos);
        }
        CacheKey key = new CacheKey(this, entity.cG());
        Float blockDensity = this.f.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(this.getSeenFraction(vec3d, entity, blockCache, blockPos));
            this.f.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x2 = 0; x2 <= 15; ++x2) {
            for (int y2 = 0; y2 <= 15; ++y2) {
                for (int z2 = 0; z2 <= 15; ++z2) {
                    if (x2 != 0 && x2 != 15 && y2 != 0 && y2 != 15 && z2 != 0 && z2 != 15) continue;
                    double xDir = (float)x2 / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y2 / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z2 / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }

    public static enum Effect {
        a,
        b,
        c;

    }

    public static final class ExplosionBlockCache {
        public final long key;
        public final BlockPosition immutablePos;
        public final IBlockData blockState;
        public final Fluid fluidState;
        public final float resistance;
        public final boolean outOfWorld;
        public Boolean shouldExplode;
        public VoxelShape cachedCollisionShape;

        public ExplosionBlockCache(long key, BlockPosition immutablePos, IBlockData blockState, Fluid fluidState, float resistance, boolean outOfWorld) {
            this.key = key;
            this.immutablePos = immutablePos;
            this.blockState = blockState;
            this.fluidState = fluidState;
            this.resistance = resistance;
            this.outOfWorld = outOfWorld;
        }
    }

    static class CacheKey {
        private final World world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AxisAlignedBB aabb) {
            this.world = explosion.f;
            this.posX = explosion.g;
            this.posY = explosion.h;
            this.posZ = explosion.i;
            this.minX = aabb.a;
            this.minY = aabb.b;
            this.minZ = aabb.c;
            this.maxX = aabb.d;
            this.maxY = aabb.e;
            this.maxZ = aabb.f;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

