/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface ICollisionAccess
extends IBlockAccess {
    public WorldBorder B_();

    @Nullable
    public IBlockAccess c(int var1, int var2);

    default public boolean a(@Nullable Entity except, VoxelShape shape) {
        return true;
    }

    default public boolean a(IBlockData state, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape = state.b((IBlockAccess)this, pos, context);
        return voxelShape.c() || this.a((Entity)null, voxelShape.a(pos.u(), (double)pos.v(), (double)pos.w()));
    }

    default public boolean f(Entity entity) {
        return this.a(entity, VoxelShapes.a(entity.cG()));
    }

    default public boolean noCollision(Entity entity, AxisAlignedBB box, boolean loadChunks) {
        return this.a(entity, box);
    }

    default public boolean b(AxisAlignedBB box) {
        return this.a((Entity)null, box);
    }

    default public boolean g(Entity entity) {
        return this.a(entity, entity.cG());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean a(@Nullable Entity entity, AxisAlignedBB box) {
        try {
            if (entity != null) {
                entity.collisionLoadChunks = true;
            }
            for (VoxelShape voxelShape : this.e(entity, box)) {
                if (voxelShape.c()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (entity != null) {
                entity.collisionLoadChunks = false;
            }
        }
        if (!this.c(entity, box).isEmpty()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        VoxelShape voxelShape2 = this.h(entity, box);
        return voxelShape2 == null || !VoxelShapes.c(voxelShape2, VoxelShapes.a(box), OperatorBoolean.i);
    }

    default public boolean b(@Nullable Entity entity, AxisAlignedBB box) {
        for (VoxelShape voxelShape : this.e(entity, box)) {
            if (voxelShape.c()) continue;
            return false;
        }
        return true;
    }

    public List<VoxelShape> c(@Nullable Entity var1, AxisAlignedBB var2);

    default public Iterable<VoxelShape> d(@Nullable Entity entity, AxisAlignedBB box) {
        List<VoxelShape> list = this.c(entity, box);
        Iterable iterable = this.e(entity, box);
        return list.isEmpty() ? iterable : Iterables.concat(list, iterable);
    }

    default public Iterable<VoxelShape> e(@Nullable Entity entity, AxisAlignedBB box) {
        return () -> new VoxelShapeSpliterator<VoxelShape>(this, entity, box, false, (pos, voxelShape) -> voxelShape);
    }

    @Nullable
    private VoxelShape h(Entity entity, AxisAlignedBB box) {
        WorldBorder worldBorder = this.B_();
        return worldBorder.a(entity, box) ? worldBorder.c() : null;
    }

    default public boolean f(@Nullable Entity entity, AxisAlignedBB box) {
        VoxelShapeSpliterator<VoxelShape> blockCollisions = new VoxelShapeSpliterator<VoxelShape>(this, entity, box, true, (pos, voxelShape) -> voxelShape);
        while (blockCollisions.hasNext()) {
            if (((VoxelShape)blockCollisions.next()).c()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPosition> g(Entity entity, AxisAlignedBB box) {
        BlockPosition blockPos = null;
        double d2 = Double.MAX_VALUE;
        VoxelShapeSpliterator<BlockPosition> blockCollisions = new VoxelShapeSpliterator<BlockPosition>(this, entity, box, false, (pos, voxelShape) -> pos);
        while (blockCollisions.hasNext()) {
            BlockPosition blockPos2 = (BlockPosition)blockCollisions.next();
            double e2 = blockPos2.b(entity.dj());
            if (!(e2 < d2) && (e2 != d2 || blockPos != null && blockPos.i(blockPos2) >= 0)) continue;
            blockPos = blockPos2.i();
            d2 = e2;
        }
        return Optional.ofNullable(blockPos);
    }

    default public Optional<Vec3D> a(@Nullable Entity entity, VoxelShape shape, Vec3D target, double x2, double y2, double z2) {
        if (shape.c()) {
            return Optional.empty();
        }
        AxisAlignedBB aABB = shape.a().c(x2, y2, z2);
        VoxelShape voxelShape = StreamSupport.stream(this.e(entity, aABB).spliterator(), false).filter(voxelShapex -> this.B_() == null || this.B_().a(voxelShapex.a())).flatMap(voxelShapex -> voxelShapex.e().stream()).map(aABBx -> aABBx.c(x2 / 2.0, y2 / 2.0, z2 / 2.0)).map(VoxelShapes::a).reduce(VoxelShapes.a(), VoxelShapes::a);
        VoxelShape voxelShape2 = VoxelShapes.a(shape, voxelShape, OperatorBoolean.e);
        return voxelShape2.a(target);
    }
}

