/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.MCUtil;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    public static final String b = "SpawnData";
    private static final Logger a = LogUtils.getLogger();
    private static final int c = 1;
    public int d = 20;
    public SimpleWeightedRandomList<MobSpawnerData> e = SimpleWeightedRandomList.b();
    @Nullable
    public MobSpawnerData f;
    private double g;
    private double h;
    public int i = 200;
    public int j = 800;
    public int k = 4;
    @Nullable
    private Entity l;
    public int m = 6;
    public int n = 16;
    public int o = 4;
    private int tickDelay = 0;

    static <B, T extends B> EntityTypeTest<B, T> forExactClass(final Class<T> clazz) {
        return new EntityTypeTest<B, T>(){

            @Override
            @Nullable
            public T a(B entity) {
                return clazz.equals(entity.getClass()) ? entity : null;
            }

            @Override
            public Class<? extends B> a() {
                return clazz;
            }
        };
    }

    public void a(EntityTypes<?> type, @Nullable World world, RandomSource random, BlockPosition pos) {
        this.b(world, random, pos).a().a("id", BuiltInRegistries.h.b(type).toString());
        this.e = SimpleWeightedRandomList.b();
    }

    public boolean b(World world, BlockPosition pos) {
        return world.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, this.n);
    }

    public void a(World world, BlockPosition pos) {
        if (!this.b(world, pos)) {
            this.h = this.g;
        } else if (this.l != null) {
            RandomSource randomsource = world.D_();
            double d0 = (double)pos.u() + randomsource.j();
            double d1 = (double)pos.v() + randomsource.j();
            double d2 = (double)pos.w() + randomsource.j();
            world.a(Particles.Z, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(Particles.C, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.d > 0) {
                --this.d;
            }
            this.h = this.g;
            this.g = (this.g + (double)(1000.0f / ((float)this.d + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer world, BlockPosition pos) {
        if (this.k <= 0 || this.m <= 0) {
            return;
        }
        if (this.d > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = world.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.b(world, pos)) {
            if (this.d < -this.tickDelay) {
                this.c(world, pos);
            }
            if (this.d > 0) {
                this.d -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = world.D_();
                MobSpawnerData mobspawnerdata = this.b(world, randomsource, pos);
                for (int i2 = 0; i2 < this.k; ++i2) {
                    PreSpawnerSpawnEvent event;
                    MobSpawnerData.a mobspawnerdata_a;
                    double d2;
                    NBTTagCompound nbttagcompound = mobspawnerdata.a();
                    Optional<EntityTypes<?>> optional = EntityTypes.a(nbttagcompound);
                    if (optional.isEmpty()) {
                        this.c(world, pos);
                        return;
                    }
                    NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
                    int j2 = nbttaglist.size();
                    double d0 = j2 >= 1 ? nbttaglist.h(0) : (double)pos.u() + (randomsource.j() - randomsource.j()) * (double)this.o + 0.5;
                    double d1 = j2 >= 2 ? nbttaglist.h(1) : (double)(pos.v() + randomsource.a(3) - 1);
                    double d3 = d2 = j2 >= 3 ? nbttaglist.h(2) : (double)pos.w() + (randomsource.j() - randomsource.j()) * (double)this.o + 0.5;
                    if (!world.b(optional.get().a(d0, d1, d2))) continue;
                    BlockPosition blockposition1 = BlockPosition.a(d0, d1, d2);
                    if (!mobspawnerdata.b().isPresent() ? !EntityPositionTypes.a(optional.get(), world, EnumMobSpawn.c, blockposition1, world.D_()) : !optional.get().f().d() && world.ai() == EnumDifficulty.a || !(mobspawnerdata_a = mobspawnerdata.b().get()).a().a(world.a(EnumSkyBlock.b, blockposition1)) || !mobspawnerdata_a.b().a(world.a(EnumSkyBlock.a, blockposition1))) continue;
                    EntityTypes<?> entityType = optional.get();
                    String key = EntityTypes.a(entityType).a();
                    EntityType type = EntityType.fromName((String)key);
                    if (type != null && !(event = new PreSpawnerSpawnEvent(MCUtil.toLocation(world, d0, d1, d2), type, MCUtil.toLocation(world, pos))).callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityTypes.a(nbttagcompound, world, entity1 -> {
                        entity1.b(d0, d1, d2, entity1.dB(), entity1.dD());
                        return entity1;
                    });
                    if (entity == null) {
                        this.c(world, pos);
                        return;
                    }
                    int k2 = world.a(MobSpawnerAbstract.forExactClass(entity.getClass()), new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1).g(this.o), IEntitySelector.f).size();
                    if (k2 >= this.m) {
                        this.c(world, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.b(entity.dq(), entity.ds(), entity.dw(), randomsource.i() * 360.0f, 0.0f);
                    if (entity instanceof EntityInsentient) {
                        EntityInsentient entityinsentient = (EntityInsentient)entity;
                        if (mobspawnerdata.b().isEmpty() && !entityinsentient.a((GeneratorAccess)world, EnumMobSpawn.c) || !entityinsentient.a((IWorldReader)world)) continue;
                        if (mobspawnerdata.a().f() == 1 && mobspawnerdata.a().b("id", 8)) {
                            ((EntityInsentient)entity).a(world, world.d_(entity.dl()), EnumMobSpawn.c, (GroupDataEntity)null, null);
                        }
                        if (entityinsentient.dL().spigotConfig.nerfSpawnerMobs) {
                            entityinsentient.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                    if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.c(world, pos);
                        return;
                    }
                    world.c(2004, pos, 0);
                    world.a(entity, GameEvent.t, blockposition1);
                    if (!(entity instanceof EntityInsentient)) continue;
                    ((EntityInsentient)entity).Q();
                }
                if (flag) {
                    this.c(world, pos);
                }
            }
        }
    }

    public void c(World world, BlockPosition pos) {
        RandomSource randomsource = world.z;
        this.d = this.j <= this.i ? this.i : this.i + randomsource.a(this.j - this.i);
        this.e.b(randomsource).ifPresent(weightedentry_b -> this.a(world, pos, (MobSpawnerData)weightedentry_b.b()));
        this.a(world, pos, 1);
    }

    public void a(@Nullable World world, BlockPosition pos, NBTTagCompound nbt) {
        boolean flag1;
        this.d = nbt.e("Paper.Delay") ? nbt.h("Paper.Delay") : (int)nbt.g("Delay");
        boolean flag = nbt.b(b, 10);
        if (flag) {
            MobSpawnerData mobspawnerdata = MobSpawnerData.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p(b)).resultOrPartial(s2 -> a.warn("Invalid SpawnData: {}", s2)).orElseGet(MobSpawnerData::new);
            this.a(world, pos, mobspawnerdata);
        }
        if (flag1 = nbt.b("SpawnPotentials", 9)) {
            NBTTagList nbttaglist = nbt.c("SpawnPotentials", 10);
            this.e = MobSpawnerData.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttaglist).resultOrPartial(s2 -> a.warn("Invalid SpawnPotentials list: {}", s2)).orElseGet(SimpleWeightedRandomList::b);
        } else {
            this.e = SimpleWeightedRandomList.a(this.f != null ? this.f : new MobSpawnerData());
        }
        if (nbt.b("Paper.MinSpawnDelay", 99)) {
            this.i = nbt.h("Paper.MinSpawnDelay");
            this.j = nbt.h("Paper.MaxSpawnDelay");
            this.k = nbt.g("SpawnCount");
        } else if (nbt.b("MinSpawnDelay", 99)) {
            this.i = nbt.h("MinSpawnDelay");
            this.j = nbt.h("MaxSpawnDelay");
            this.k = nbt.g("SpawnCount");
        }
        if (nbt.b("MaxNearbyEntities", 99)) {
            this.m = nbt.g("MaxNearbyEntities");
            this.n = nbt.g("RequiredPlayerRange");
        }
        if (nbt.b("SpawnRange", 99)) {
            this.o = nbt.g("SpawnRange");
        }
        this.l = null;
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        if (this.d > Short.MAX_VALUE) {
            nbt.a("Paper.Delay", this.d);
        }
        nbt.a("Delay", (short)Math.min(Short.MAX_VALUE, this.d));
        if (this.i > Short.MAX_VALUE || this.j > Short.MAX_VALUE) {
            nbt.a("Paper.MinSpawnDelay", this.i);
            nbt.a("Paper.MaxSpawnDelay", this.j);
        }
        nbt.a("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.i));
        nbt.a("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.j));
        nbt.a("SpawnCount", (short)this.k);
        nbt.a("MaxNearbyEntities", (short)this.m);
        nbt.a("RequiredPlayerRange", (short)this.n);
        nbt.a("SpawnRange", (short)this.o);
        if (this.f != null) {
            nbt.a(b, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        nbt.a("SpawnPotentials", (NBTBase)MobSpawnerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, this.e).result().orElseThrow());
        return nbt;
    }

    @Nullable
    public Entity a(World world, RandomSource random, BlockPosition pos) {
        if (this.l == null) {
            NBTTagCompound nbttagcompound = this.b(world, random, pos).a();
            if (!nbttagcompound.b("id", 8)) {
                return null;
            }
            this.l = EntityTypes.a(nbttagcompound, world, Function.identity());
            if (nbttagcompound.f() != 1 || this.l instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.l;
    }

    public boolean a(World world, int status) {
        if (status == 1) {
            if (world.B) {
                this.d = this.i;
            }
            return true;
        }
        return false;
    }

    public void a(@Nullable World world, BlockPosition pos, MobSpawnerData spawnEntry) {
        this.f = spawnEntry;
    }

    private MobSpawnerData b(@Nullable World world, RandomSource random, BlockPosition pos) {
        if (this.f != null) {
            return this.f;
        }
        this.a(world, pos, this.e.b(random).map(WeightedEntry.b::b).orElseGet(MobSpawnerData::new));
        return this.f;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.g;
    }

    public double b() {
        return this.h;
    }
}

