/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public class Climate {
    private static final boolean b = false;
    private static final float c = 10000.0f;
    @VisibleForTesting
    protected static final int a = 7;

    public static h a(float temperatureNoise, float humidityNoise, float continentalnessNoise, float erosionNoise, float depth, float weirdnessNoise) {
        return new h(Climate.a(temperatureNoise), Climate.a(humidityNoise), Climate.a(continentalnessNoise), Climate.a(erosionNoise), Climate.a(depth), Climate.a(weirdnessNoise));
    }

    public static d a(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        return new d(net.minecraft.world.level.biome.Climate$b.a(temperature), net.minecraft.world.level.biome.Climate$b.a(humidity), net.minecraft.world.level.biome.Climate$b.a(continentalness), net.minecraft.world.level.biome.Climate$b.a(erosion), net.minecraft.world.level.biome.Climate$b.a(depth), net.minecraft.world.level.biome.Climate$b.a(weirdness), Climate.a(offset));
    }

    public static d a(b temperature, b humidity, b continentalness, b erosion, b depth, b weirdness, float offset) {
        return new d(temperature, humidity, continentalness, erosion, depth, weirdness, Climate.a(offset));
    }

    public static long a(float value) {
        return (long)(value * 10000.0f);
    }

    public static float a(long value) {
        return (float)value / 10000.0f;
    }

    public static Sampler a() {
        DensityFunction densityFunction = DensityFunctions.a();
        return new Sampler(densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, List.of());
    }

    public static BlockPosition a(List<d> noises, Sampler sampler) {
        return new g(noises, (Sampler)sampler).a.a();
    }

    public static final class h
    extends Record {
        private final long a;
        private final long b;
        private final long c;
        private final long d;
        private final long e;
        private final long f;

        public h(long l2, long m2, long n2, long o2, long p2, long q2) {
            this.a = l2;
            this.b = m2;
            this.c = n2;
            this.d = o2;
            this.e = p2;
            this.f = q2;
        }

        @VisibleForTesting
        protected long[] a() {
            return new long[]{this.a, this.b, this.c, this.d, this.e, this.f, 0L};
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "temperature;humidity;continentalness;erosion;depth;weirdness", "a", "b", "c", "d", "e", "f"}, this, object);
        }

        public long b() {
            return this.a;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.c;
        }

        public long e() {
            return this.d;
        }

        public long f() {
            return this.e;
        }

        public long g() {
            return this.f;
        }
    }

    public record d(b b, b c, b d, b e, b f, b g, long h) {
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("temperature").forGetter(parameterPoint -> parameterPoint.b), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("humidity").forGetter(parameterPoint -> parameterPoint.c), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("continentalness").forGetter(parameterPoint -> parameterPoint.d), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("erosion").forGetter(parameterPoint -> parameterPoint.e), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("depth").forGetter(parameterPoint -> parameterPoint.f), (App)net.minecraft.world.level.biome.Climate$b.a.fieldOf("weirdness").forGetter(parameterPoint -> parameterPoint.g), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::a, Climate::a).forGetter(parameterPoint -> parameterPoint.h)).apply((Applicative)instance, d::new));

        long a(h point) {
            return MathHelper.a(this.b.a(point.a)) + MathHelper.a(this.c.a(point.b)) + MathHelper.a(this.d.a(point.c)) + MathHelper.a(this.e.a(point.d)) + MathHelper.a(this.f.a(point.e)) + MathHelper.a(this.g.a(point.f)) + MathHelper.a(this.h);
        }

        protected List<b> a() {
            return ImmutableList.of((Object)this.b, (Object)this.c, (Object)this.d, (Object)this.e, (Object)this.f, (Object)this.g, (Object)new b(this.h, this.h));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "temperature;humidity;continentalness;erosion;depth;weirdness;offset", "b", "c", "d", "e", "f", "g", "h"}, this, object);
        }
    }

    public static final class b
    extends Record {
        private final long b;
        private final long c;
        public static final Codec<b> a = ExtraCodecs.a(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (min, max) -> {
            if (min.compareTo((Float)max) > 0) {
                return DataResult.error(() -> "Cannon construct interval, min > max (" + min + " > " + max + ")");
            }
            return DataResult.success((Object)new b(Climate.a(min.floatValue()), Climate.a(max.floatValue())));
        }, parameter -> Float.valueOf(Climate.a(parameter.a())), parameter -> Float.valueOf(Climate.a(parameter.b())));

        public b(long l2, long m2) {
            this.b = l2;
            this.c = m2;
        }

        public static b a(float point) {
            return net.minecraft.world.level.biome.Climate$b.a(point, point);
        }

        public static b a(float min, float max) {
            if (min > max) {
                throw new IllegalArgumentException("min > max: " + min + " " + max);
            }
            return new b(Climate.a(min), Climate.a(max));
        }

        public static b a(b min, b max) {
            if (min.a() > max.b()) {
                throw new IllegalArgumentException("min > max: " + min + " " + max);
            }
            return new b(min.a(), max.b());
        }

        @Override
        @Override
        public String toString() {
            return this.b == this.c ? String.format(Locale.ROOT, "%d", this.b) : String.format(Locale.ROOT, "[%d-%d]", this.b, this.c);
        }

        public long a(long noise) {
            long l2 = noise - this.c;
            long m2 = this.b - noise;
            if (l2 > 0L) {
                return l2;
            }
            return Math.max(m2, 0L);
        }

        public long a(b other) {
            long l2 = other.a() - this.c;
            long m2 = this.b - other.b();
            if (l2 > 0L) {
                return l2;
            }
            return Math.max(m2, 0L);
        }

        public b b(@Nullable b other) {
            return other == null ? this : new b(Math.min(this.b, other.a()), Math.max(this.c, other.b()));
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "min;max", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "min;max", "b", "c"}, this, object);
        }

        public long a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }
    }

    public record Sampler(DensityFunction a, DensityFunction b, DensityFunction c, DensityFunction d, DensityFunction e, DensityFunction f, List<d> g) {
        private final DensityFunction a;
        private final DensityFunction b;
        private final DensityFunction c;
        private final DensityFunction d;
        private final DensityFunction e;
        private final DensityFunction f;
        private final List<d> g;

        public h a(int x2, int y2, int z2) {
            int i2 = QuartPos.c(x2);
            int j2 = QuartPos.c(y2);
            int k2 = QuartPos.c(z2);
            DensityFunction.e singlePointContext = new DensityFunction.e(i2, j2, k2);
            return Climate.a((float)this.a.a(singlePointContext), (float)this.b.a(singlePointContext), (float)this.c.a(singlePointContext), (float)this.d.a(singlePointContext), (float)this.e.a(singlePointContext), (float)this.f.a(singlePointContext));
        }

        public BlockPosition a() {
            if (this.g.isEmpty()) {
                return BlockPosition.b;
            }
            return Climate.a(this.g, this);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Sampler.class, "temperature;humidity;continentalness;erosion;depth;weirdness;spawnTarget", "a", "b", "c", "d", "e", "f", "g"}, this, object);
        }

        public DensityFunction b() {
            return this.a;
        }

        public DensityFunction c() {
            return this.b;
        }

        public DensityFunction d() {
            return this.c;
        }

        public DensityFunction e() {
            return this.d;
        }

        public DensityFunction f() {
            return this.e;
        }

        public DensityFunction g() {
            return this.f;
        }

        public List<d> h() {
            return this.g;
        }
    }

    static class g {
        a a;

        g(List<d> noises, Sampler sampler) {
            this.a = g.a(noises, sampler, 0, 0);
            this.a(noises, sampler, 2048.0f, 512.0f);
            this.a(noises, sampler, 512.0f, 32.0f);
        }

        private void a(List<d> noises, Sampler sampler, float maxDistance, float step) {
            float f2 = 0.0f;
            float g2 = step;
            BlockPosition blockPos = this.a.a();
            while (g2 <= maxDistance) {
                int j2;
                int i2 = blockPos.u() + (int)(Math.sin(f2) * (double)g2);
                a result = g.a(noises, sampler, i2, j2 = blockPos.w() + (int)(Math.cos(f2) * (double)g2));
                if (result.b() < this.a.b()) {
                    this.a = result;
                }
                if (!((double)(f2 += step / g2) > Math.PI * 2)) continue;
                f2 = 0.0f;
                g2 += step;
            }
        }

        private static a a(List<d> noises, Sampler sampler, int x2, int z2) {
            double d2 = MathHelper.k(2500.0);
            int i2 = 2;
            long l2 = (long)((double)MathHelper.k(10000.0f) * Math.pow((double)(MathHelper.a((long)x2) + MathHelper.a((long)z2)) / d2, 2.0));
            h targetPoint = sampler.a(QuartPos.a(x2), 0, QuartPos.a(z2));
            h targetPoint2 = new h(targetPoint.b(), targetPoint.c(), targetPoint.d(), targetPoint.e(), 0L, targetPoint.g());
            long m2 = Long.MAX_VALUE;
            for (d parameterPoint : noises) {
                m2 = Math.min(m2, parameterPoint.a(targetPoint2));
            }
            return new a(new BlockPosition(x2, 0, z2), l2 + m2);
        }

        record a(BlockPosition a, long b) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "location;fitness", "a", "b"}, this, object);
            }
        }
    }

    public static class c<T> {
        private final List<Pair<d, T>> a;
        private final e<T> b;

        public static <T> Codec<c<T>> a(MapCodec<T> entryCodec) {
            return ExtraCodecs.a(RecordCodecBuilder.create(instance -> instance.group((App)d.a.fieldOf("parameters").forGetter(Pair::getFirst), (App)entryCodec.forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(c::new, c::a);
        }

        public c(List<Pair<d, T>> entries) {
            this.a = entries;
            this.b = e.a(entries);
        }

        public List<Pair<d, T>> a() {
            return this.a;
        }

        public T a(h point) {
            return this.c(point);
        }

        @VisibleForTesting
        public T b(h point) {
            Iterator<Pair<d, T>> iterator = this.a().iterator();
            Pair<d, T> pair = iterator.next();
            long l2 = ((d)pair.getFirst()).a(point);
            Object object = pair.getSecond();
            while (iterator.hasNext()) {
                Pair<d, T> pair2 = iterator.next();
                long m2 = ((d)pair2.getFirst()).a(point);
                if (m2 >= l2) continue;
                l2 = m2;
                object = pair2.getSecond();
            }
            return (T)object;
        }

        public T c(h point) {
            return this.a(point, e.b::a);
        }

        protected T a(h point, a<T> distanceFunction) {
            return this.b.a(point, distanceFunction);
        }
    }

    protected static final class e<T> {
        private static final int a = 6;
        private final b<T> b;
        private final ThreadLocal<a<T>> c = new ThreadLocal();

        private e(b<T> firstNode) {
            this.b = firstNode;
        }

        public static <T> e<T> a(List<Pair<d, T>> entries) {
            if (entries.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int i2 = ((d)entries.get(0).getFirst()).a().size();
            if (i2 != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + i2);
            }
            List list = entries.stream().map(entry -> new a<Object>((d)entry.getFirst(), entry.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new e<T>(e.a(i2, list));
        }

        private static <T> b<T> a(int parameterNumber, List<? extends b<T>> subTree) {
            if (subTree.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (subTree.size() == 1) {
                return subTree.get(0);
            }
            if (subTree.size() <= 6) {
                subTree.sort(Comparator.comparingLong(node -> {
                    long l2 = 0L;
                    for (int j2 = 0; j2 < parameterNumber; ++j2) {
                        net.minecraft.world.level.biome.Climate$b parameter = node.a[j2];
                        l2 += Math.abs((parameter.a() + parameter.b()) / 2L);
                    }
                    return l2;
                }));
                return new c(subTree);
            }
            long l2 = Long.MAX_VALUE;
            int i2 = -1;
            List<c<T>> list = null;
            for (int j2 = 0; j2 < parameterNumber; ++j2) {
                e.a(subTree, parameterNumber, j2, false);
                List<c<T>> list2 = e.b(subTree);
                long m2 = 0L;
                for (c<T> subTree2 : list2) {
                    m2 += e.a(subTree2.a);
                }
                if (l2 <= m2) continue;
                l2 = m2;
                i2 = j2;
                list = list2;
            }
            e.a(list, parameterNumber, i2, true);
            return new c(list.stream().map(node -> e.a(parameterNumber, Arrays.asList(node.b))).collect(Collectors.toList()));
        }

        private static <T> void a(List<? extends b<T>> subTree, int parameterNumber, int currentParameter, boolean abs) {
            Comparator<b<b<T>>> comparator = e.a(currentParameter, abs);
            for (int i2 = 1; i2 < parameterNumber; ++i2) {
                comparator = comparator.thenComparing(e.a((currentParameter + i2) % parameterNumber, abs));
            }
            subTree.sort(comparator);
        }

        private static <T> Comparator<b<T>> a(int currentParameter, boolean abs) {
            return Comparator.comparingLong(node -> {
                net.minecraft.world.level.biome.Climate$b parameter = node.a[currentParameter];
                long l2 = (parameter.a() + parameter.b()) / 2L;
                return abs ? Math.abs(l2) : l2;
            });
        }

        private static <T> List<c<T>> b(List<? extends b<T>> nodes) {
            ArrayList list = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            int i2 = (int)Math.pow(6.0, Math.floor(Math.log((double)nodes.size() - 0.01) / Math.log(6.0)));
            for (b<T> node : nodes) {
                list2.add(node);
                if (list2.size() < i2) continue;
                list.add(new c(list2));
                list2 = Lists.newArrayList();
            }
            if (!list2.isEmpty()) {
                list.add(new c(list2));
            }
            return list;
        }

        private static long a(net.minecraft.world.level.biome.Climate$b[] parameters) {
            long l2 = 0L;
            for (net.minecraft.world.level.biome.Climate$b parameter : parameters) {
                l2 += Math.abs(parameter.b() - parameter.a());
            }
            return l2;
        }

        static <T> List<net.minecraft.world.level.biome.Climate$b> c(List<? extends b<T>> subTree) {
            if (subTree.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i2 = 7;
            ArrayList list = Lists.newArrayList();
            for (int j2 = 0; j2 < 7; ++j2) {
                list.add(null);
            }
            for (b<T> node : subTree) {
                for (int k2 = 0; k2 < 7; ++k2) {
                    list.set(k2, node.a[k2].b((net.minecraft.world.level.biome.Climate$b)list.get(k2)));
                }
            }
            return list;
        }

        public T a(h point, net.minecraft.world.level.biome.Climate$a<T> distanceFunction) {
            long[] ls = point.a();
            a<T> leaf = this.b.a(ls, this.c.get(), distanceFunction);
            this.c.set(leaf);
            return leaf.b;
        }

        static abstract class b<T> {
            protected final net.minecraft.world.level.biome.Climate$b[] a;

            protected b(List<net.minecraft.world.level.biome.Climate$b> parameters) {
                this.a = parameters.toArray(new net.minecraft.world.level.biome.Climate$b[0]);
            }

            protected abstract a<T> a(long[] var1, @Nullable a<T> var2, net.minecraft.world.level.biome.Climate$a<T> var3);

            protected long a(long[] otherParameters) {
                long l2 = 0L;
                for (int i2 = 0; i2 < 7; ++i2) {
                    l2 += MathHelper.a(this.a[i2].a(otherParameters[i2]));
                }
                return l2;
            }

            @Override
            public String toString() {
                return Arrays.toString(this.a);
            }
        }

        static final class c<T>
        extends b<T> {
            final b<T>[] b;

            protected c(List<? extends b<T>> subTree) {
                this(e.c(subTree), subTree);
            }

            protected c(List<net.minecraft.world.level.biome.Climate$b> parameters, List<? extends b<T>> subTree) {
                super(parameters);
                this.b = subTree.toArray(new b[0]);
            }

            @Override
            @Override
            protected a<T> a(long[] otherParameters, @Nullable a<T> alternative, net.minecraft.world.level.biome.Climate$a<T> distanceFunction) {
                long l2 = alternative == null ? Long.MAX_VALUE : distanceFunction.distance(alternative, otherParameters);
                a<T> leaf = alternative;
                for (b<T> node : this.b) {
                    long n2;
                    long m2 = distanceFunction.distance(node, otherParameters);
                    if (l2 <= m2) continue;
                    a<T> leaf2 = node.a(otherParameters, leaf, distanceFunction);
                    long l3 = n2 = node == leaf2 ? m2 : distanceFunction.distance(leaf2, otherParameters);
                    if (l2 <= n2) continue;
                    l2 = n2;
                    leaf = leaf2;
                }
                return leaf;
            }
        }

        static final class a<T>
        extends b<T> {
            final T b;

            a(d parameters, T value) {
                super(parameters.a());
                this.b = value;
            }

            @Override
            @Override
            protected a<T> a(long[] otherParameters, @Nullable a<T> alternative, net.minecraft.world.level.biome.Climate$a<T> distanceFunction) {
                return this;
            }
        }
    }

    static interface a<T> {
        public long distance(e.b<T> var1, long[] var2);
    }
}

