/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public abstract class BlockDirtSnowSpreadable
extends BlockDirtSnow {
    protected BlockDirtSnowSpreadable(BlockBase.Info settings) {
        super(settings);
    }

    private static boolean b(IBlockData state, IWorldReader world, BlockPosition pos) {
        return BlockDirtSnowSpreadable.canBeGrass(world.x(pos), state, world, pos);
    }

    private static boolean canBeGrass(IChunkAccess chunk, IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata1 = chunk.a_(blockposition1);
        if (iblockdata1.a(Blocks.dN) && iblockdata1.c(BlockSnow.b) == 1) {
            return true;
        }
        if (iblockdata1.u().e() == 8) {
            return false;
        }
        int i2 = LightEngine.a(world, state, pos, iblockdata1, blockposition1, EnumDirection.b, iblockdata1.b(world, blockposition1));
        return i2 < world.M();
    }

    private static boolean c(IBlockData state, IWorldReader world, BlockPosition pos) {
        return BlockDirtSnowSpreadable.canPropagate(world.x(pos), state, world, pos);
    }

    private static boolean canPropagate(IChunkAccess chunk, IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        return BlockDirtSnowSpreadable.canBeGrass(chunk, state, world, pos) && !chunk.b_(blockposition1).a(TagsFluid.a);
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (this instanceof BlockGrass && world.paperConfig().tickRates.grassSpread != 1 && (world.paperConfig().tickRates.grassSpread < 1 || (MinecraftServer.currentTick + pos.hashCode()) % world.paperConfig().tickRates.grassSpread != 0)) {
            return;
        }
        Chunk cachedBlockChunk = world.getChunkIfLoaded(pos);
        if (cachedBlockChunk == null) {
            return;
        }
        if (!BlockDirtSnowSpreadable.canBeGrass(cachedBlockChunk, state, world, pos)) {
            if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.j.n()).isCancelled()) {
                return;
            }
            world.b(pos, Blocks.j.n());
        } else if (world.z(pos.c()) >= 9) {
            IBlockData iblockdata1 = this.n();
            for (int i2 = 0; i2 < 4; ++i2) {
                Chunk access;
                BlockPosition blockposition1 = pos.b(random.a(3) - 1, random.a(5) - 3, random.a(3) - 1);
                if (pos.u() == blockposition1.u() && pos.v() == blockposition1.v() && pos.w() == blockposition1.w() || !(access = cachedBlockChunk.locX == blockposition1.u() >> 4 && cachedBlockChunk.locZ == blockposition1.w() >> 4 ? cachedBlockChunk : world.l(blockposition1)).a_(blockposition1).a(Blocks.j) || !BlockDirtSnowSpreadable.canPropagate(access, iblockdata1, world, blockposition1)) continue;
                CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, (IBlockData)iblockdata1.a(BlockDirtSnow.a, access.a_(blockposition1.c()).a(Blocks.dN)));
            }
        }
    }
}

