/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.slf4j.Logger;

public class BlockDispenser
extends BlockTileEntity {
    private static final Logger c = LogUtils.getLogger();
    public static final BlockStateDirection a = BlockDirectional.a;
    public static final BlockStateBoolean b = BlockProperties.A;
    public static final Map<Item, IDispenseBehavior> d = (Map)SystemUtils.a(new Object2ObjectOpenHashMap(), (? super T object2objectopenhashmap) -> object2objectopenhashmap.defaultReturnValue((Object)new DispenseBehaviorItem()));
    private static final int e = 4;
    public static boolean eventFired = false;

    public static void a(IMaterial provider, IDispenseBehavior behavior) {
        d.put(provider.k(), behavior);
    }

    protected BlockDispenser(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.C.b().a(a, EnumDirection.c)).a(b, false));
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityDispenser) {
            player.a((TileEntityDispenser)tileentity);
            if (tileentity instanceof TileEntityDropper) {
                player.a(StatisticList.ac);
            } else {
                player.a(StatisticList.ae);
            }
        }
        return EnumInteractionResult.b;
    }

    public void a(WorldServer world, IBlockData state, BlockPosition pos) {
        TileEntityDispenser tileentitydispenser = world.a(pos, TileEntityTypes.f).orElse(null);
        if (tileentitydispenser == null) {
            c.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)pos);
        } else {
            SourceBlock sourceblock = new SourceBlock(world, pos, state, tileentitydispenser);
            int i2 = tileentitydispenser.a(world.z);
            if (i2 < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(world, pos)) {
                    world.c(1001, pos, 0);
                    world.a(GameEvent.a, pos, GameEvent.a.a(tileentitydispenser.q()));
                }
            } else {
                ItemStack itemstack = tileentitydispenser.a(i2);
                IDispenseBehavior idispensebehavior = this.a(itemstack);
                if (idispensebehavior != IDispenseBehavior.b) {
                    if (!CraftEventFactory.handleBlockPreDispenseEvent(world, pos, itemstack, i2)) {
                        return;
                    }
                    eventFired = false;
                    tileentitydispenser.a(i2, idispensebehavior.dispense(sourceblock, itemstack));
                }
            }
        }
    }

    protected IDispenseBehavior a(ItemStack stack) {
        return d.get(stack.d());
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1 = world.B(pos) || world.B(pos.c());
        boolean flag2 = state.c(b);
        if (flag1 && !flag2) {
            world.a(pos, (Block)this, 4);
            world.a(pos, (IBlockData)state.a(b, true), 2);
        } else if (!flag1 && flag2) {
            world.a(pos, (IBlockData)state.a(b, false), 2);
        }
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        this.a(world, state, pos);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDispenser(pos, state);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.n().a(a, ctx.d().g());
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity tileentity;
        if (itemStack.A() && (tileentity = world.c_(pos)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)tileentity).a(itemStack.y());
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof TileEntityDispenser) {
                InventoryUtils.a(world, pos, (IInventory)((TileEntityDispenser)tileentity));
                world.c(pos, this);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    public static IPosition a(SourceBlock pointer) {
        EnumDirection enumdirection = pointer.d().c(a);
        return pointer.a().b(0.7 * (double)enumdirection.j(), 0.7 * (double)enumdirection.k(), 0.7 * (double)enumdirection.l());
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b);
    }
}

