/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import top.leavesmc.leaves.LeavesConfig;

public class BlockFire
extends BlockFireAbstract {
    public static final int c = 15;
    public static final BlockStateInteger d = BlockProperties.aw;
    public static final BlockStateBoolean e = BlockSprawling.a;
    public static final BlockStateBoolean f = BlockSprawling.b;
    public static final BlockStateBoolean g = BlockSprawling.c;
    public static final BlockStateBoolean h = BlockSprawling.d;
    public static final BlockStateBoolean i = BlockSprawling.e;
    private static final Map<EnumDirection, BlockStateBoolean> j = BlockSprawling.g.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    private static final VoxelShape k = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape m = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape n = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape D = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> E;
    private static final int F = 60;
    private static final int G = 30;
    private static final int H = 15;
    private static final int I = 5;
    private static final int J = 100;
    private static final int K = 60;
    private static final int L = 20;
    private static final int M = 5;
    public final Object2IntMap<Block> N = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> O = new Object2IntOpenHashMap();

    public BlockFire(BlockBase.Info settings) {
        super(settings, 1.0f);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().a(d, 0)).a(e, false)).a(f, false)).a(g, false)).a(h, false)).a(i, false));
        this.E = ImmutableMap.copyOf(this.C.a().stream().filter(iblockdata -> iblockdata.c(d) == 0).collect(Collectors.toMap(Function.identity(), BlockFire::h)));
    }

    private static VoxelShape h(IBlockData state) {
        VoxelShape voxelshape = VoxelShapes.a();
        if (state.c(i).booleanValue()) {
            voxelshape = k;
        }
        if (state.c(e).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, n);
        }
        if (state.c(g).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, D);
        }
        if (state.c(f).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, m);
        }
        if (state.c(h).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, l);
        }
        return voxelshape.c() ? BlockFireAbstract.b : voxelshape;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!(world instanceof WorldServer)) {
            return this.a(state, world, pos) ? this.a(world, pos, (int)state.c(d)) : Blocks.a.n();
        }
        if (!this.a(state, world, pos)) {
            if (!(world instanceof World)) {
                return Blocks.a.n();
            }
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, pos);
            blockState.setData(Blocks.a.n());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            ((World)world).getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.a(world, pos, (int)state.c(d));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.E.get(state.a(d, 0));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.b(ctx.q(), ctx.a());
    }

    protected IBlockData b(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!this.f(iblockdata) && !iblockdata.d(world, blockposition1, EnumDirection.b)) {
            IBlockData iblockdata1 = this.n();
            for (EnumDirection enumdirection : EnumDirection.values()) {
                BlockStateBoolean blockstateboolean = j.get(enumdirection);
                if (blockstateboolean == null) continue;
                iblockdata1 = (IBlockData)iblockdata1.a(blockstateboolean, this.f(world.a_(pos.a(enumdirection))));
            }
            return iblockdata1;
        }
        return this.n();
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        return world.a_(blockposition1).d(world, blockposition1, EnumDirection.b) || this.d(world, pos);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        world.a(pos, (Block)this, BlockFire.getFireTickDelay(world));
        if (world.X().b(GameRules.b)) {
            if (!state.a((IWorldReader)world, pos)) {
                this.fireExtinguished(world, pos);
            }
            IBlockData iblockdata1 = world.a_(pos.d());
            boolean flag = iblockdata1.a(world.C_().q());
            int i2 = state.c(d);
            if (!flag && world.Z() && this.a(world, pos) && random.i() < 0.2f + (float)i2 * 0.03f) {
                this.fireExtinguished(world, pos);
            } else {
                boolean flag1;
                int j2 = Math.min(15, i2 + random.a(3) / 2);
                if (i2 != j2) {
                    state = (IBlockData)state.a(d, j2);
                    world.a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.d(world, pos)) {
                        BlockPosition blockposition1 = pos.d();
                        if (!world.a_(blockposition1).d(world, blockposition1, EnumDirection.b) || i2 > 3) {
                            this.fireExtinguished(world, pos);
                        }
                        return;
                    }
                    if (i2 == 15 && random.a(4) == 0 && !this.f(world.a_(pos.d()))) {
                        this.fireExtinguished(world, pos);
                        return;
                    }
                }
                int k2 = (flag1 = world.s(pos).a(BiomeTags.ac)) ? -50 : 0;
                this.trySpread(world, pos.h(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.g(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.d(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.c(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.e(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.f(), 300 + k2, random, i2, pos);
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                Object2IntOpenHashMap blockPositionIgniteCache = new Object2IntOpenHashMap();
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l2 == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockposition_mutableblockposition.a(pos, l2, j1, i1);
                            int l1 = this.getIgniteOdds(world, blockposition_mutableblockposition, (Object2IntOpenHashMap<BlockPosition>)(LeavesConfig.cacheIgniteOdds ? blockPositionIgniteCache : null));
                            if (l1 <= 0) continue;
                            int i22 = (l1 + 40 + world.ai().a() * 7) / (i2 + 30);
                            if (flag1) {
                                i22 /= 2;
                            }
                            if (i22 <= 0 || random.a(k1) > i22 || world.Z() && this.a(world, (BlockPosition)blockposition_mutableblockposition)) continue;
                            int j22 = Math.min(15, i2 + random.a(5) / 4);
                            if (world.a_(blockposition_mutableblockposition).b() == Blocks.cr || CraftEventFactory.callBlockIgniteEvent((World)world, (BlockPosition)blockposition_mutableblockposition, pos).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition_mutableblockposition, this.a((GeneratorAccess)world, (BlockPosition)blockposition_mutableblockposition, j22), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean a(World world, BlockPosition pos) {
        return world.q(pos) || world.q(pos.g()) || world.q(pos.h()) || world.q(pos.e()) || world.q(pos.f());
    }

    private int n(IBlockData state) {
        return state.b(BlockProperties.C) && state.c(BlockProperties.C) != false ? 0 : this.O.getInt((Object)state.b());
    }

    private int o(IBlockData state) {
        return state.b(BlockProperties.C) && state.c(BlockProperties.C) != false ? 0 : this.N.getInt((Object)state.b());
    }

    private void trySpread(World world, BlockPosition blockposition, int i2, RandomSource randomsource, int j2, BlockPosition sourceposition) {
        int k2 = this.n(world.a_(blockposition));
        if (randomsource.a(i2) < k2) {
            IBlockData iblockdata = world.a_(blockposition);
            org.bukkit.block.Block theBlock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            org.bukkit.block.Block sourceBlock = world.getWorld().getBlockAt(sourceposition.u(), sourceposition.v(), sourceposition.w());
            BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (iblockdata.b() instanceof BlockTNT && !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.FIRE, null, sourceposition)) {
                return;
            }
            if (randomsource.a(j2 + 10) < 5 && !world.q(blockposition)) {
                int l2 = Math.min(j2 + randomsource.a(5) / 4, 15);
                world.a(blockposition, this.a((GeneratorAccess)world, blockposition, l2), 3);
            } else if (iblockdata.b() != Blocks.ck) {
                world.a(blockposition, false);
            }
            Block block = iblockdata.b();
            if (block instanceof BlockTNT) {
                org.bukkit.block.Block tntBlock = MCUtil.toBukkitBlock(world, blockposition);
                if (!new TNTPrimeEvent(tntBlock, TNTPrimeEvent.PrimeReason.FIRE, null).callEvent()) {
                    return;
                }
                world.a(blockposition, false);
                BlockTNT.a(world, blockposition);
            }
        }
    }

    private IBlockData a(GeneratorAccess world, BlockPosition pos, int age) {
        IBlockData iblockdata = BlockFire.a(world, pos);
        return iblockdata.a(Blocks.cr) ? (IBlockData)iblockdata.a(d, age) : iblockdata;
    }

    private boolean d(IBlockAccess world, BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.f(world.a_(pos.a(enumdirection)))) continue;
            return true;
        }
        return false;
    }

    private int a(IWorldReader world, BlockPosition pos) {
        return this.getIgniteOdds(world, pos, null);
    }

    private int getIgniteOdds(IWorldReader world, BlockPosition pos, Object2IntOpenHashMap<BlockPosition> cache) {
        if (!world.t(pos)) {
            return 0;
        }
        int i2 = 0;
        EnumDirection[] aenumdirection = EnumDirection.values();
        int j2 = aenumdirection.length;
        for (int k2 = 0; k2 < j2; ++k2) {
            if (cache != null) {
                int finalK = k2;
                i2 = Math.max(cache.computeIfAbsent((Object)pos, key -> {
                    EnumDirection enumdirection = aenumdirection[finalK];
                    IBlockData iblockdata = world.a_(pos.a(enumdirection));
                    return this.o(iblockdata);
                }), i2);
                continue;
            }
            EnumDirection enumdirection = aenumdirection[k2];
            IBlockData iblockdata = world.a_(pos.a(enumdirection));
            i2 = Math.max(this.o(iblockdata), i2);
        }
        return i2;
    }

    @Override
    protected boolean f(IBlockData state) {
        return this.o(state) > 0;
    }

    @Override
    public void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext itemActionContext) {
        super.onPlace(iblockdata, world, blockposition, iblockdata1, flag, itemActionContext);
        world.a(blockposition, (Block)this, BlockFire.getFireTickDelay(world));
    }

    private static int getFireTickDelay(World world) {
        return world.paperConfig().environment.fireTickDelay + world.z.a(10);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(d, e, f, g, h, i);
    }

    private void a(Block block, int burnChance, int spreadChance) {
        this.N.put((Object)block, burnChance);
        this.O.put((Object)block, spreadChance);
    }

    public static void a() {
        BlockFire blockfire = (BlockFire)Blocks.cr;
        blockfire.a(Blocks.n, 5, 20);
        blockfire.a(Blocks.o, 5, 20);
        blockfire.a(Blocks.p, 5, 20);
        blockfire.a(Blocks.q, 5, 20);
        blockfire.a(Blocks.r, 5, 20);
        blockfire.a(Blocks.s, 5, 20);
        blockfire.a(Blocks.t, 5, 20);
        blockfire.a(Blocks.u, 5, 20);
        blockfire.a(Blocks.v, 5, 20);
        blockfire.a(Blocks.w, 5, 20);
        blockfire.a(Blocks.jt, 5, 20);
        blockfire.a(Blocks.ju, 5, 20);
        blockfire.a(Blocks.jv, 5, 20);
        blockfire.a(Blocks.jw, 5, 20);
        blockfire.a(Blocks.jx, 5, 20);
        blockfire.a(Blocks.jy, 5, 20);
        blockfire.a(Blocks.jz, 5, 20);
        blockfire.a(Blocks.jA, 5, 20);
        blockfire.a(Blocks.jB, 5, 20);
        blockfire.a(Blocks.jC, 5, 20);
        blockfire.a(Blocks.fh, 5, 20);
        blockfire.a(Blocks.jV, 5, 20);
        blockfire.a(Blocks.jW, 5, 20);
        blockfire.a(Blocks.jX, 5, 20);
        blockfire.a(Blocks.jY, 5, 20);
        blockfire.a(Blocks.jZ, 5, 20);
        blockfire.a(Blocks.ka, 5, 20);
        blockfire.a(Blocks.kb, 5, 20);
        blockfire.a(Blocks.kc, 5, 20);
        blockfire.a(Blocks.dU, 5, 20);
        blockfire.a(Blocks.kd, 5, 20);
        blockfire.a(Blocks.ke, 5, 20);
        blockfire.a(Blocks.kf, 5, 20);
        blockfire.a(Blocks.kg, 5, 20);
        blockfire.a(Blocks.kh, 5, 20);
        blockfire.a(Blocks.ki, 5, 20);
        blockfire.a(Blocks.kj, 5, 20);
        blockfire.a(Blocks.kk, 5, 20);
        blockfire.a(Blocks.cu, 5, 20);
        blockfire.a(Blocks.fL, 5, 20);
        blockfire.a(Blocks.fK, 5, 20);
        blockfire.a(Blocks.fM, 5, 20);
        blockfire.a(Blocks.hP, 5, 20);
        blockfire.a(Blocks.hQ, 5, 20);
        blockfire.a(Blocks.hR, 5, 20);
        blockfire.a(Blocks.hS, 5, 20);
        blockfire.a(Blocks.hT, 5, 20);
        blockfire.a(Blocks.hU, 5, 20);
        blockfire.a(Blocks.U, 5, 5);
        blockfire.a(Blocks.V, 5, 5);
        blockfire.a(Blocks.W, 5, 5);
        blockfire.a(Blocks.X, 5, 5);
        blockfire.a(Blocks.Y, 5, 5);
        blockfire.a(Blocks.Z, 5, 5);
        blockfire.a(Blocks.aa, 5, 5);
        blockfire.a(Blocks.ab, 5, 5);
        blockfire.a(Blocks.ae, 5, 5);
        blockfire.a(Blocks.al, 5, 5);
        blockfire.a(Blocks.af, 5, 5);
        blockfire.a(Blocks.ag, 5, 5);
        blockfire.a(Blocks.ah, 5, 5);
        blockfire.a(Blocks.ai, 5, 5);
        blockfire.a(Blocks.aj, 5, 5);
        blockfire.a(Blocks.ak, 5, 5);
        blockfire.a(Blocks.am, 5, 5);
        blockfire.a(Blocks.an, 5, 5);
        blockfire.a(Blocks.aw, 5, 5);
        blockfire.a(Blocks.ax, 5, 5);
        blockfire.a(Blocks.ay, 5, 5);
        blockfire.a(Blocks.az, 5, 5);
        blockfire.a(Blocks.aA, 5, 5);
        blockfire.a(Blocks.aB, 5, 5);
        blockfire.a(Blocks.aC, 5, 5);
        blockfire.a(Blocks.aD, 5, 5);
        blockfire.a(Blocks.ao, 5, 5);
        blockfire.a(Blocks.ap, 5, 5);
        blockfire.a(Blocks.aq, 5, 5);
        blockfire.a(Blocks.ar, 5, 5);
        blockfire.a(Blocks.as, 5, 5);
        blockfire.a(Blocks.at, 5, 5);
        blockfire.a(Blocks.au, 5, 5);
        blockfire.a(Blocks.av, 5, 5);
        blockfire.a(Blocks.ac, 5, 20);
        blockfire.a(Blocks.aE, 30, 60);
        blockfire.a(Blocks.aF, 30, 60);
        blockfire.a(Blocks.aG, 30, 60);
        blockfire.a(Blocks.aH, 30, 60);
        blockfire.a(Blocks.aI, 30, 60);
        blockfire.a(Blocks.aJ, 30, 60);
        blockfire.a(Blocks.aK, 30, 60);
        blockfire.a(Blocks.aL, 30, 60);
        blockfire.a(Blocks.cl, 30, 20);
        blockfire.a(Blocks.ck, 15, 100);
        blockfire.a(Blocks.bt, 60, 100);
        blockfire.a(Blocks.bu, 60, 100);
        blockfire.a(Blocks.bv, 60, 100);
        blockfire.a(Blocks.iD, 60, 100);
        blockfire.a(Blocks.iE, 60, 100);
        blockfire.a(Blocks.iF, 60, 100);
        blockfire.a(Blocks.iG, 60, 100);
        blockfire.a(Blocks.iH, 60, 100);
        blockfire.a(Blocks.iI, 60, 100);
        blockfire.a(Blocks.bR, 60, 100);
        blockfire.a(Blocks.bT, 60, 100);
        blockfire.a(Blocks.bU, 60, 100);
        blockfire.a(Blocks.bV, 60, 100);
        blockfire.a(Blocks.bW, 60, 100);
        blockfire.a(Blocks.bX, 60, 100);
        blockfire.a(Blocks.bY, 60, 100);
        blockfire.a(Blocks.bZ, 60, 100);
        blockfire.a(Blocks.ca, 60, 100);
        blockfire.a(Blocks.cb, 60, 100);
        blockfire.a(Blocks.cc, 60, 100);
        blockfire.a(Blocks.ce, 60, 100);
        blockfire.a(Blocks.bS, 60, 100);
        blockfire.a(Blocks.kC, 60, 100);
        blockfire.a(Blocks.cd, 60, 100);
        blockfire.a(Blocks.rA, 60, 100);
        blockfire.a(Blocks.bA, 30, 60);
        blockfire.a(Blocks.bB, 30, 60);
        blockfire.a(Blocks.bC, 30, 60);
        blockfire.a(Blocks.bD, 30, 60);
        blockfire.a(Blocks.bE, 30, 60);
        blockfire.a(Blocks.bF, 30, 60);
        blockfire.a(Blocks.bG, 30, 60);
        blockfire.a(Blocks.bH, 30, 60);
        blockfire.a(Blocks.bI, 30, 60);
        blockfire.a(Blocks.bJ, 30, 60);
        blockfire.a(Blocks.bK, 30, 60);
        blockfire.a(Blocks.bL, 30, 60);
        blockfire.a(Blocks.bM, 30, 60);
        blockfire.a(Blocks.bN, 30, 60);
        blockfire.a(Blocks.bO, 30, 60);
        blockfire.a(Blocks.bP, 30, 60);
        blockfire.a(Blocks.ff, 15, 100);
        blockfire.a(Blocks.iB, 5, 5);
        blockfire.a(Blocks.ij, 60, 20);
        blockfire.a(Blocks.pd, 15, 20);
        blockfire.a(Blocks.ik, 60, 20);
        blockfire.a(Blocks.il, 60, 20);
        blockfire.a(Blocks.im, 60, 20);
        blockfire.a(Blocks.in, 60, 20);
        blockfire.a(Blocks.io, 60, 20);
        blockfire.a(Blocks.ip, 60, 20);
        blockfire.a(Blocks.iq, 60, 20);
        blockfire.a(Blocks.ir, 60, 20);
        blockfire.a(Blocks.is, 60, 20);
        blockfire.a(Blocks.it, 60, 20);
        blockfire.a(Blocks.iu, 60, 20);
        blockfire.a(Blocks.iv, 60, 20);
        blockfire.a(Blocks.iw, 60, 20);
        blockfire.a(Blocks.ix, 60, 20);
        blockfire.a(Blocks.iy, 60, 20);
        blockfire.a(Blocks.iz, 60, 20);
        blockfire.a(Blocks.me, 30, 60);
        blockfire.a(Blocks.mZ, 60, 60);
        blockfire.a(Blocks.nS, 60, 60);
        blockfire.a(Blocks.oa, 30, 20);
        blockfire.a(Blocks.pc, 5, 20);
        blockfire.a(Blocks.oi, 60, 100);
        blockfire.a(Blocks.pf, 5, 20);
        blockfire.a(Blocks.pe, 30, 20);
        blockfire.a(Blocks.aM, 30, 60);
        blockfire.a(Blocks.aN, 30, 60);
        blockfire.a(Blocks.ru, 15, 60);
        blockfire.a(Blocks.rv, 15, 60);
        blockfire.a(Blocks.rw, 60, 100);
        blockfire.a(Blocks.rx, 30, 60);
        blockfire.a(Blocks.ry, 30, 60);
        blockfire.a(Blocks.rC, 60, 100);
        blockfire.a(Blocks.rD, 60, 100);
        blockfire.a(Blocks.rE, 60, 100);
        blockfire.a(Blocks.rF, 30, 60);
        blockfire.a(Blocks.fg, 15, 100);
    }
}

