/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public class BlockFluids
extends Block
implements IFluidSource {
    public static final BlockStateInteger a = BlockProperties.aP;
    protected final FluidTypeFlowing b;
    private final List<Fluid> e;
    public static final VoxelShape c = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final ImmutableList<EnumDirection> d = ImmutableList.of((Object)EnumDirection.a, (Object)EnumDirection.d, (Object)EnumDirection.c, (Object)EnumDirection.f, (Object)EnumDirection.e);

    protected BlockFluids(FluidTypeFlowing fluid, BlockBase.Info settings) {
        super(settings);
        this.b = fluid;
        this.e = Lists.newArrayList();
        this.e.add(fluid.a(false));
        for (int i2 = 1; i2 < 8; ++i2) {
            this.e.add(fluid.a(8 - i2, false));
        }
        this.e.add(fluid.a(8, true));
        this.k((IBlockData)this.C.b().a(a, 0));
    }

    @Override
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return context.a(c, pos, true) && state.c(a) == 0 && context.a(world.b_(pos.c()), state.u()) ? c : VoxelShapes.a();
    }

    @Override
    public boolean e_(IBlockData state) {
        return state.u().f();
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        state.u().b(world, pos, random);
    }

    @Override
    public boolean c(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return !this.b.a(TagsFluid.b);
    }

    @Override
    public Fluid c_(IBlockData state) {
        int i2 = state.c(a);
        return this.e.get(Math.min(i2, 8));
    }

    @Override
    public boolean a(IBlockData state, IBlockData stateFrom, EnumDirection direction) {
        return stateFrom.u().a().a(this.b);
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.a;
    }

    @Override
    public List<ItemStack> a(IBlockData state, LootParams.a builder) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.a();
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (this.a(world, pos, state)) {
            world.a(pos, state.u().a(), this.getFlowSpeed(world, pos));
        }
    }

    public int getFlowSpeed(World world, BlockPosition blockposition) {
        if (BuiltInRegistries.d.d(this.b).a(TagsFluid.a) && (BlockFluids.isLava(world, blockposition.d(1)) || BlockFluids.isLava(world, blockposition.e(1)) || BlockFluids.isLava(world, blockposition.f(1)) || BlockFluids.isLava(world, blockposition.g(1)))) {
            return world.paperConfig().environment.waterOverLavaFlowSpeed;
        }
        return this.b.a((IWorldReader)world);
    }

    private static boolean isLava(World world, BlockPosition blockPos) {
        Fluid fluidState = world.getFluidIfLoaded(blockPos);
        return fluidState != null && fluidState.a(TagsFluid.b);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.u().b() || neighborState.u().b()) {
            world.a(pos, state.u().a(), this.b.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        if (this.a(world, pos, state)) {
            world.a(pos, state.u().a(), this.getFlowSpeed(world, pos));
        }
    }

    private boolean a(World world, BlockPosition pos, IBlockData state) {
        if (this.b.a(TagsFluid.b)) {
            boolean flag = world.a_(pos.d()).a(Blocks.dY);
            for (EnumDirection enumdirection : d) {
                BlockPosition blockposition1 = pos.a(enumdirection.g());
                if (world.b_(blockposition1).a(TagsFluid.a)) {
                    Block block;
                    Block block2 = block = world.b_(pos).b() ? Blocks.co : Blocks.m;
                    if (CraftEventFactory.handleBlockFormEvent(world, pos, block.n())) {
                        this.a(world, pos);
                    }
                    return false;
                }
                if (!flag || !world.a_(blockposition1).a(Blocks.mW)) continue;
                if (CraftEventFactory.handleBlockFormEvent(world, pos, Blocks.dZ.n())) {
                    this.a(world, pos);
                }
                return false;
            }
        }
        return true;
    }

    private void a(GeneratorAccess world, BlockPosition pos) {
        world.c(1501, pos, 0);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{a});
    }

    @Override
    public ItemStack a(@Nullable EntityHuman player, GeneratorAccess world, BlockPosition pos, IBlockData state) {
        if (state.c(a) == 0) {
            world.a(pos, Blocks.a.n(), 11);
            return new ItemStack(this.b.a());
        }
        return ItemStack.b;
    }

    @Override
    public Optional<SoundEffect> aq_() {
        return this.b.j();
    }
}

