/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    protected static final float a = 3.0f;
    protected static final VoxelShape b = Block.a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final ResourceKey<WorldGenFeatureConfigured<?, ?>> c;

    public BlockMushroom(BlockBase.Info settings, ResourceKey<WorldGenFeatureConfigured<?, ?>> featureKey) {
        super(settings);
        this.c = featureKey;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (random.i() < (float)world.spigotConfig.mushroomModifier / 2500.0f) {
            int i2 = 5;
            boolean flag = true;
            for (BlockPosition blockposition1 : BlockPosition.a(pos.b(-4, -1, -4), pos.b(4, 1, 4))) {
                if (!world.a_(blockposition1).a(this) || --i2 > 0) continue;
                return;
            }
            BlockPosition blockposition2 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            BlockPosition sourcePos = pos;
            for (int j2 = 0; j2 < 4; ++j2) {
                if (world.t(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                    pos = blockposition2;
                }
                blockposition2 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            }
            if (world.t(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                CraftEventFactory.handleBlockSpreadEvent(world, sourcePos, blockposition2, state, 2);
            }
        }
    }

    @Override
    protected boolean d(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.i(world, pos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata1 = world.a_(blockposition1);
        return iblockdata1.a(TagsBlock.aZ) ? true : world.b(pos, 0) < 13 && this.d(iblockdata1, world, blockposition1);
    }

    public boolean a(WorldServer world, BlockPosition pos, IBlockData state, RandomSource random) {
        Optional<Holder.c<WorldGenFeatureConfigured<?, ?>>> optional = world.G_().d(Registries.as).b(this.c);
        if (optional.isEmpty()) {
            return false;
        }
        world.a(pos, false);
        TreeType treeType = BlockSapling.treeType = this == Blocks.cf ? TreeType.BROWN_MUSHROOM : TreeType.RED_MUSHROOM;
        if (((WorldGenFeatureConfigured)((Holder)optional.get()).a()).a(world, world.k().g(), random, pos)) {
            return true;
        }
        world.a(pos, state, 3);
        return false;
    }

    @Override
    public boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return (double)random.i() < 0.4;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a(world, pos, state, random);
    }
}

