/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public abstract class BlockPressurePlateAbstract
extends Block {
    protected static final VoxelShape a = Block.a(1.0, 0.0, 1.0, 15.0, 0.5, 15.0);
    protected static final VoxelShape b = Block.a(1.0, 0.0, 1.0, 15.0, 1.0, 15.0);
    protected static final AxisAlignedBB c = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375);
    private final BlockSetType d;

    protected BlockPressurePlateAbstract(BlockBase.Info settings, BlockSetType blockSetType) {
        super(settings.a(blockSetType.d()));
        this.d = blockSetType;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.g(state) > 0 ? a : b;
    }

    protected int a() {
        return 20;
    }

    @Override
    public boolean a(IBlockData state) {
        return true;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return direction == EnumDirection.a && !state.a(world, pos) ? Blocks.a.n() : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        return BlockPressurePlateAbstract.c(world, blockposition1) || BlockPressurePlateAbstract.a(world, blockposition1, EnumDirection.b);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2 = this.g(state);
        if (i2 > 0) {
            this.a((net.minecraft.world.entity.Entity)null, (World)world, pos, state, i2);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        int i2;
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.B && (i2 = this.g(state)) == 0) {
            this.a(entity, world, pos, state, i2);
        }
    }

    private void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition pos, IBlockData state, int output) {
        int j2 = this.b(world, pos);
        boolean flag = output > 0;
        boolean flag1 = j2 > 0;
        CraftWorld bworld = world.getWorld();
        PluginManager manager = world.getCraftServer().getPluginManager();
        if (flag != flag1) {
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bworld.getBlockAt(pos.u(), pos.v(), pos.w()), output, j2);
            manager.callEvent((Event)eventRedstone);
            flag1 = eventRedstone.getNewCurrent() > 0;
            j2 = eventRedstone.getNewCurrent();
        }
        if (output != j2) {
            IBlockData iblockdata1 = this.a(state, j2);
            world.a(pos, iblockdata1, 2);
            this.a(world, pos);
            world.b(pos, state, iblockdata1);
        }
        if (!flag1 && flag) {
            world.a((EntityHuman)null, pos, this.d.i(), SoundCategory.e);
            world.a(entity, GameEvent.e, pos);
        } else if (flag1 && !flag) {
            world.a((EntityHuman)null, pos, this.d.j(), SoundCategory.e);
            world.a(entity, GameEvent.a, pos);
        }
        if (flag1) {
            world.a(new BlockPosition(pos), (Block)this, this.a());
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            if (this.g(state) > 0) {
                this.a(world, pos);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    protected void a(World world, BlockPosition pos) {
        world.a(pos, this);
        world.a(pos.d(), this);
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return this.g(state);
    }

    @Override
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return direction == EnumDirection.b ? this.g(state) : 0;
    }

    @Override
    public boolean f_(IBlockData state) {
        return true;
    }

    protected static int a(World world, AxisAlignedBB box, Class<? extends net.minecraft.world.entity.Entity> entityClass) {
        return BlockPressurePlateAbstract.getEntities(world, box, entityClass).size();
    }

    protected static <T extends net.minecraft.world.entity.Entity> List<T> getEntities(World world, AxisAlignedBB axisalignedbb, Class<T> oclass) {
        return world.a(oclass, axisalignedbb, IEntitySelector.f.and(entity -> !entity.p_()));
    }

    protected abstract int b(World var1, BlockPosition var2);

    protected abstract int g(IBlockData var1);

    protected abstract IBlockData a(IBlockData var1, int var2);
}

