/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSprawling
extends Block {
    private static final EnumDirection[] i = EnumDirection.values();
    public static final BlockStateBoolean a = BlockProperties.L;
    public static final BlockStateBoolean b = BlockProperties.M;
    public static final BlockStateBoolean c = BlockProperties.N;
    public static final BlockStateBoolean d = BlockProperties.O;
    public static final BlockStateBoolean e = BlockProperties.J;
    public static final BlockStateBoolean f = BlockProperties.K;
    public static final Map<EnumDirection, BlockStateBoolean> g = ImmutableMap.copyOf((Map)SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T directions) -> {
        directions.put(EnumDirection.c, a);
        directions.put(EnumDirection.f, b);
        directions.put(EnumDirection.d, c);
        directions.put(EnumDirection.e, d);
        directions.put(EnumDirection.b, e);
        directions.put(EnumDirection.a, f);
    }));
    protected final VoxelShape[] h;

    protected BlockSprawling(float radius, BlockBase.Info settings) {
        super(settings);
        this.h = this.a(radius);
    }

    private VoxelShape[] a(float radius) {
        float f2 = 0.5f - radius;
        float g2 = 0.5f + radius;
        VoxelShape voxelShape = Block.a(f2 * 16.0f, f2 * 16.0f, f2 * 16.0f, g2 * 16.0f, g2 * 16.0f, g2 * 16.0f);
        VoxelShape[] voxelShapes = new VoxelShape[i.length];
        for (int i2 = 0; i2 < i.length; ++i2) {
            EnumDirection direction = i[i2];
            voxelShapes[i2] = VoxelShapes.a(0.5 + Math.min((double)(-radius), (double)direction.j() * 0.5), 0.5 + Math.min((double)(-radius), (double)direction.k() * 0.5), 0.5 + Math.min((double)(-radius), (double)direction.l() * 0.5), 0.5 + Math.max((double)radius, (double)direction.j() * 0.5), 0.5 + Math.max((double)radius, (double)direction.k() * 0.5), 0.5 + Math.max((double)radius, (double)direction.l() * 0.5));
        }
        VoxelShape[] voxelShapes2 = new VoxelShape[64];
        for (int j2 = 0; j2 < 64; ++j2) {
            VoxelShape voxelShape2 = voxelShape;
            for (int k2 = 0; k2 < i.length; ++k2) {
                if ((j2 & 1 << k2) == 0) continue;
                voxelShape2 = VoxelShapes.a(voxelShape2, voxelShapes[k2]);
            }
            voxelShapes2[j2] = voxelShape2;
        }
        return voxelShapes2;
    }

    @Override
    @Override
    public boolean c(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.h[this.h(state)];
    }

    protected int h(IBlockData state) {
        int i2 = 0;
        for (int j2 = 0; j2 < i.length; ++j2) {
            if (!((Boolean)state.c(g.get(i[j2]))).booleanValue()) continue;
            i2 |= 1 << j2;
        }
        return i2;
    }
}

