/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStepAbstract
extends Block
implements IBlockWaterlogged {
    public static final BlockStateEnum<BlockPropertySlabType> a = BlockProperties.bh;
    public static final BlockStateBoolean b = BlockProperties.C;
    protected static final VoxelShape c = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape d = Block.a(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);

    public BlockStepAbstract(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.n().a(a, BlockPropertySlabType.b)).a(b, false));
    }

    @Override
    @Override
    public boolean g_(IBlockData state) {
        return state.c(a) != BlockPropertySlabType.c;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b);
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        BlockPropertySlabType slabType = state.c(a);
        switch (slabType) {
            case c: {
                return VoxelShapes.b();
            }
            case a: {
                return d;
            }
        }
        return c;
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        BlockPosition blockPos = ctx.a();
        IBlockData blockState = ctx.q().a_(blockPos);
        if (blockState.a(this)) {
            return (IBlockData)((IBlockData)blockState.a(a, BlockPropertySlabType.c)).a(b, false);
        }
        Fluid fluidState = ctx.q().b_(blockPos);
        IBlockData blockState2 = (IBlockData)((IBlockData)this.n().a(a, BlockPropertySlabType.b)).a(b, fluidState.a() == FluidTypes.c);
        EnumDirection direction = ctx.k();
        if (direction == EnumDirection.a || direction != EnumDirection.b && ctx.l().d - (double)blockPos.v() > 0.5) {
            return (IBlockData)blockState2.a(a, BlockPropertySlabType.a);
        }
        return blockState2;
    }

    @Override
    @Override
    public boolean a(IBlockData state, BlockActionContext context) {
        ItemStack itemStack = context.n();
        BlockPropertySlabType slabType = state.c(a);
        if (slabType == BlockPropertySlabType.c || !itemStack.a(this.k())) {
            return false;
        }
        if (context.c()) {
            boolean bl = context.l().d - (double)context.a().v() > 0.5;
            EnumDirection direction = context.k();
            if (slabType == BlockPropertySlabType.b) {
                return direction == EnumDirection.b || bl && direction.o().d();
            }
            return direction == EnumDirection.a || !bl && direction.o().d();
        }
        return true;
    }

    @Override
    @Override
    public Fluid c_(IBlockData state) {
        if (state.c(b).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.c_(state);
    }

    @Override
    @Override
    public boolean a(GeneratorAccess world, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (state.c(a) != BlockPropertySlabType.c) {
            return IBlockWaterlogged.super.a(world, pos, state, fluidState);
        }
        return false;
    }

    @Override
    @Override
    public boolean a(@Nullable EntityHuman player, IBlockAccess world, BlockPosition pos, IBlockData state, FluidType fluid) {
        if (state.c(a) != BlockPropertySlabType.c) {
            return IBlockWaterlogged.super.a(player, world, pos, state, fluid);
        }
        return false;
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(b).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return false;
            }
            case b: {
                return world.b_(pos).a(TagsFluid.a);
            }
            case c: {
                return false;
            }
        }
        return false;
    }
}

