/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTorchWall
extends BlockTorch {
    public static final BlockStateDirection a = BlockFacingHorizontal.aC;
    protected static final float b = 2.5f;
    private static final Map<EnumDirection, VoxelShape> c = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)Block.a(5.5, 3.0, 11.0, 10.5, 13.0, 16.0), (Object)EnumDirection.d, (Object)Block.a(5.5, 3.0, 0.0, 10.5, 13.0, 5.0), (Object)EnumDirection.e, (Object)Block.a(11.0, 3.0, 5.5, 16.0, 13.0, 10.5), (Object)EnumDirection.f, (Object)Block.a(0.0, 3.0, 5.5, 5.0, 13.0, 10.5)));

    protected BlockTorchWall(BlockBase.Info settings, ParticleParam particle) {
        super(settings, particle);
        this.k((IBlockData)this.C.b().a(a, EnumDirection.c));
    }

    @Override
    @Override
    public String f() {
        return this.k().a();
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return BlockTorchWall.h(state);
    }

    public static VoxelShape h(IBlockData state) {
        return c.get(state.c(a));
    }

    @Override
    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection direction = state.c(a);
        BlockPosition blockPos = pos.a(direction.g());
        IBlockData blockState = world.a_(blockPos);
        return blockState.d(world, blockPos, direction);
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection[] directions;
        IBlockData blockState = this.n();
        World levelReader = ctx.q();
        BlockPosition blockPos = ctx.a();
        for (EnumDirection direction : directions = ctx.f()) {
            EnumDirection direction2;
            if (!direction.o().d() || !(blockState = (IBlockData)blockState.a(a, direction2 = direction.g())).a((IWorldReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction.g() == state.c(a) && !state.a(world, pos)) {
            return Blocks.a.n();
        }
        return state;
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        EnumDirection direction = state.c(a);
        double d2 = (double)pos.u() + 0.5;
        double e2 = (double)pos.v() + 0.7;
        double f2 = (double)pos.w() + 0.5;
        double g2 = 0.22;
        double h2 = 0.27;
        EnumDirection direction2 = direction.g();
        world.a(Particles.Z, d2 + 0.27 * (double)direction2.j(), e2 + 0.22, f2 + 0.27 * (double)direction2.l(), 0.0, 0.0, 0.0);
        world.a(this.i, d2 + 0.27 * (double)direction2.j(), e2 + 0.22, f2 + 0.27 * (double)direction2.l(), 0.0, 0.0, 0.0);
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(a)));
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{a});
    }
}

