/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final BlockStateBoolean a = BlockProperties.u;
    public static final BlockStateEnum<BlockPropertyHalf> b = BlockProperties.af;
    public static final BlockStateBoolean c = BlockProperties.w;
    public static final BlockStateBoolean d = BlockProperties.C;
    protected static final int e = 3;
    protected static final VoxelShape f = Block.a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape g = Block.a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private final BlockSetType l;

    protected BlockTrapdoor(BlockBase.Info settings, BlockSetType blockSetType) {
        super(settings.a(blockSetType.d()));
        this.l = blockSetType;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().a(BlockFacingHorizontal.aC, EnumDirection.c)).a(a, false)).a(b, BlockPropertyHalf.b)).a(c, false)).a(d, false));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (!state.c(a).booleanValue()) {
            return state.c(b) == BlockPropertyHalf.a ? k : j;
        }
        switch (state.c(BlockFacingHorizontal.aC)) {
            default: {
                return i;
            }
            case d: {
                return h;
            }
            case e: {
                return g;
            }
            case f: 
        }
        return f;
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return state.c(a);
            }
            case b: {
                return state.c(d);
            }
            case c: {
                return state.c(a);
            }
        }
        return false;
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (!this.l.c()) {
            return EnumInteractionResult.d;
        }
        state = (IBlockData)state.a(a);
        world.a(pos, state, 2);
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
        }
        this.a(player, world, pos, state.c(a));
        return EnumInteractionResult.a(world.B);
    }

    protected void a(@Nullable EntityHuman player, World world, BlockPosition pos, boolean open) {
        world.a(player, pos, open ? this.l.h() : this.l.g(), SoundCategory.e, 1.0f, world.D_().i() * 0.1f + 0.9f);
        world.a((Entity)player, open ? GameEvent.h : GameEvent.d, pos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1;
        if (!world.B && (flag1 = world.B(pos)) != state.c(c)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(pos.u(), pos.v(), pos.w());
            int power = bblock.getBlockPower();
            int oldPower = state.c(a) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || sourceBlock.n().m()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (state.c(a) != flag1) {
                state = (IBlockData)state.a(a, flag1);
                this.a((EntityHuman)null, world, pos, flag1);
            }
            world.a(pos, (IBlockData)state.a(c, flag1), 2);
            if (state.c(d).booleanValue()) {
                world.a(pos, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        IBlockData iblockdata = this.n();
        Fluid fluid = ctx.q().b_(ctx.a());
        EnumDirection enumdirection = ctx.k();
        iblockdata = !ctx.c() && enumdirection.o().d() ? (IBlockData)((IBlockData)iblockdata.a(BlockFacingHorizontal.aC, enumdirection)).a(b, ctx.l().d - (double)ctx.a().v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b) : (IBlockData)((IBlockData)iblockdata.a(BlockFacingHorizontal.aC, ctx.g().g())).a(b, enumdirection == EnumDirection.b ? BlockPropertyHalf.b : BlockPropertyHalf.a);
        if (ctx.q().B(ctx.a())) {
            iblockdata = (IBlockData)((IBlockData)iblockdata.a(a, true)).a(c, true);
        }
        return (IBlockData)iblockdata.a(d, fluid.a() == FluidTypes.c);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aC, a, b, c, d);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }
}

