/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MinecraftKey a = new MinecraftKey("sherds");
    private static final VoxelShape b = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection c = BlockProperties.R;
    private static final BlockStateBoolean d = BlockProperties.bw;
    private static final BlockStateBoolean e = BlockProperties.C;

    protected DecoratedPotBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.C.b().a(c, EnumDirection.c)).a(e, false)).a(d, false));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(e).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluidState = ctx.q().b_(ctx.a());
        return (IBlockData)((IBlockData)((IBlockData)this.n().a(c, ctx.g())).a(e, fluidState.a() == FluidTypes.c)).a(d, false);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack itemStack) {
        if (world.B) {
            world.a(pos, TileEntityTypes.O).ifPresent(blockEntity -> blockEntity.a(itemStack));
        }
    }

    @Override
    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, e, d);
    }

    @Override
    @Nullable
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    @Override
    public List<ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity blockEntity = builder.b(LootContextParameters.h);
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)blockEntity;
            builder.a(a, (Consumer<ItemStack> lootConsumer) -> decoratedPotBlockEntity.f().a().map(Item::ai_).forEach(lootConsumer));
        }
        return super.a(state, builder);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        ItemStack itemStack = player.eS();
        IBlockData blockState = state;
        if (itemStack.a(TagsItem.aT) && !EnchantmentManager.f(itemStack)) {
            blockState = (IBlockData)state.a(d, true);
            world.a(pos, blockState, 4);
        }
        super.a(world, pos, blockState, player);
    }

    @Override
    @Override
    public Fluid c_(IBlockData state) {
        if (state.c(e).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.c_(state);
    }

    @Override
    @Override
    public SoundEffectType m(IBlockData state) {
        if (state.c(d).booleanValue()) {
            return SoundEffectType.aY;
        }
        return SoundEffectType.aX;
    }

    @Override
    @Override
    public void a(ItemStack stack, @Nullable IBlockAccess world, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, world, tooltip, options);
        DecoratedPotBlockEntity.Decoration decorations = DecoratedPotBlockEntity.Decoration.b(ItemBlock.a(stack));
        if (decorations.equals(DecoratedPotBlockEntity.Decoration.a)) {
            return;
        }
        tooltip.add(CommonComponents.a);
        Stream.of(decorations.e(), decorations.c(), decorations.d(), decorations.b()).forEach(sherd -> tooltip.add(new ItemStack((IMaterial)sherd, 1).y().d().a(EnumChatFormat.h)));
    }

    @Override
    @Override
    public ItemStack a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        TileEntity tileEntity = world.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            return decoratedPotBlockEntity.g();
        }
        return super.a(world, pos, state);
    }
}

