/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class MultifaceBlock
extends Block {
    private static final float b = 1.0f;
    private static final VoxelShape c = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape d = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape f = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape h = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, BlockStateBoolean> i = BlockSprawling.g;
    private static final Map<EnumDirection, VoxelShape> j = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T shapes) -> {
        shapes.put(EnumDirection.c, g);
        shapes.put(EnumDirection.f, f);
        shapes.put(EnumDirection.d, h);
        shapes.put(EnumDirection.e, e);
        shapes.put(EnumDirection.b, c);
        shapes.put(EnumDirection.a, d);
    });
    protected static final EnumDirection[] a = EnumDirection.values();
    private final ImmutableMap<IBlockData, VoxelShape> k;
    private final boolean l;
    private final boolean m;
    private final boolean n;

    public MultifaceBlock(BlockBase.Info settings) {
        super(settings);
        this.k(MultifaceBlock.a(this.C));
        this.k = this.a(MultifaceBlock::o);
        this.l = EnumDirection.EnumDirectionLimit.a.a().allMatch(this::a);
        this.m = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.a).filter(this::a).count() % 2L == 0L;
        this.n = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.c).filter(this::a).count() % 2L == 0L;
    }

    public static Set<EnumDirection> h(IBlockData state) {
        if (!(state.b() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if (!MultifaceBlock.a(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<EnumDirection> a(byte flag) {
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if ((flag & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte a(Collection<EnumDirection> directions) {
        byte b2 = 0;
        for (EnumDirection direction : directions) {
            b2 = (byte)(b2 | 1 << direction.ordinal());
        }
        return b2;
    }

    protected boolean a(EnumDirection direction) {
        return true;
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        for (EnumDirection direction : a) {
            if (!this.a(direction)) continue;
            builder.a(new IBlockState[]{MultifaceBlock.b(direction)});
        }
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!MultifaceBlock.n(state)) {
            return Blocks.a.n();
        }
        if (!MultifaceBlock.a(state, direction) || MultifaceBlock.a(world, direction, neighborPos, neighborState)) {
            return state;
        }
        return MultifaceBlock.a(state, MultifaceBlock.b(direction));
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return (VoxelShape)this.k.get((Object)state);
    }

    @Override
    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        boolean bl = false;
        for (EnumDirection direction : a) {
            if (!MultifaceBlock.a(state, direction)) continue;
            BlockPosition blockPos = pos.a(direction);
            if (!MultifaceBlock.a(world, direction, blockPos, world.a_(blockPos))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @Override
    public boolean a(IBlockData state, BlockActionContext context) {
        return MultifaceBlock.p(state);
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        World level = ctx.q();
        BlockPosition blockPos = ctx.a();
        IBlockData blockState = level.a_(blockPos);
        return Arrays.stream(ctx.f()).map(direction -> this.c(blockState, (IBlockAccess)level, blockPos, (EnumDirection)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean a(IBlockAccess world, IBlockData state, BlockPosition pos, EnumDirection direction) {
        if (!this.a(direction) || state.a(this) && MultifaceBlock.a(state, direction)) {
            return false;
        }
        BlockPosition blockPos = pos.a(direction);
        return MultifaceBlock.a(world, direction, blockPos, world.a_(blockPos));
    }

    @Nullable
    public IBlockData c(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        IBlockData blockState3;
        if (!this.a(world, state, pos, direction)) {
            return null;
        }
        if (state.a(this)) {
            IBlockData blockState = state;
        } else if (this.g() && state.u().a(FluidTypes.c)) {
            IBlockData blockState2 = (IBlockData)this.n().a(BlockProperties.C, true);
        } else {
            blockState3 = this.n();
        }
        return (IBlockData)blockState3.a(MultifaceBlock.b(direction), true);
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        if (!this.l) {
            return state;
        }
        return this.a(state, rotation::a);
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        if (mirror == EnumBlockMirror.c && !this.m) {
            return state;
        }
        if (mirror == EnumBlockMirror.b && !this.n) {
            return state;
        }
        return this.a(state, mirror::b);
    }

    private IBlockData a(IBlockData state, Function<EnumDirection, EnumDirection> mirror) {
        IBlockData blockState = state;
        for (EnumDirection direction : a) {
            if (!this.a(direction)) continue;
            blockState = (IBlockData)blockState.a(MultifaceBlock.b(mirror.apply(direction)), state.c(MultifaceBlock.b(direction)));
        }
        return blockState;
    }

    public static boolean a(IBlockData state, EnumDirection direction) {
        BlockStateBoolean booleanProperty = MultifaceBlock.b(direction);
        return state.b(booleanProperty) && state.c(booleanProperty) != false;
    }

    public static boolean a(IBlockAccess world, EnumDirection direction, BlockPosition pos, IBlockData state) {
        return Block.a(state.l(world, pos), direction.g()) || Block.a(state.k(world, pos), direction.g());
    }

    private boolean g() {
        return this.C.d().contains(BlockProperties.C);
    }

    private static IBlockData a(IBlockData state, BlockStateBoolean direction) {
        IBlockData blockState = (IBlockData)state.a(direction, false);
        if (MultifaceBlock.n(blockState)) {
            return blockState;
        }
        return Blocks.a.n();
    }

    public static BlockStateBoolean b(EnumDirection direction) {
        return i.get(direction);
    }

    private static IBlockData a(BlockStateList<Block, IBlockData> stateManager) {
        IBlockData blockState = stateManager.b();
        for (BlockStateBoolean booleanProperty : i.values()) {
            if (!blockState.b(booleanProperty)) continue;
            blockState = (IBlockData)blockState.a(booleanProperty, false);
        }
        return blockState;
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelShape = VoxelShapes.a();
        for (EnumDirection direction : a) {
            if (!MultifaceBlock.a(state, direction)) continue;
            voxelShape = VoxelShapes.a(voxelShape, j.get(direction));
        }
        return voxelShape.c() ? VoxelShapes.b() : voxelShape;
    }

    protected static boolean n(IBlockData state) {
        return Arrays.stream(a).anyMatch(direction -> MultifaceBlock.a(state, direction));
    }

    private static boolean p(IBlockData state) {
        return Arrays.stream(a).anyMatch(direction -> !MultifaceBlock.a(state, direction));
    }

    public abstract MultifaceSpreader b();
}

