/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import io.papermc.paper.util.MCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R2.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TileEntitySign
extends TileEntity
implements ICommandListener {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    @Nullable
    private UUID d;
    private SignText e = this.f();
    private SignText f = this.f();
    private boolean g;

    public TileEntitySign(BlockPosition pos, IBlockData state) {
        this((TileEntityTypes)TileEntityTypes.h, pos, state);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman player) {
        return this.isFacingFrontText(player.dq(), player.dw());
    }

    public boolean isFacingFrontText(double x2, double z2) {
        Block block = this.q().b();
        if (block instanceof BlockSign) {
            float f1;
            BlockSign blocksign = (BlockSign)block;
            Vec3D vec3d = blocksign.h(this.q());
            double d0 = x2 - ((double)this.p().u() + vec3d.c);
            double d1 = z2 - ((double)this.p().w() + vec3d.e);
            float f2 = blocksign.g(this.q());
            return MathHelper.d(f2, f1 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText b(EntityHuman player) {
        return this.a(this.a(player));
    }

    public SignText a(boolean front) {
        return front ? this.e : this.f;
    }

    public SignText g() {
        return this.e;
    }

    public SignText i() {
        return this.f;
    }

    public int c() {
        return 10;
    }

    public int d() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = SignText.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e);
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("front_text", (NBTBase)nbtbase));
        dataresult = SignText.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f);
        logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("back_text", (NBTBase)nbtbase));
        nbt.a("is_waxed", this.g);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.e("front_text")) {
            dataresult = SignText.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("front_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.e = this.a((SignText)signtext);
            });
        }
        if (nbt.e("back_text")) {
            dataresult = SignText.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.p("back_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.f = this.a((SignText)signtext);
            });
        }
        this.g = nbt.q("is_waxed");
    }

    private SignText a(SignText signText) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent ichatbasecomponent = this.a(signText.a(i2, false));
            IChatBaseComponent ichatbasecomponent1 = this.a(signText.a(i2, true));
            signText = signText.a(i2, ichatbasecomponent, ichatbasecomponent1);
        }
        return signText;
    }

    private IChatBaseComponent a(IChatBaseComponent text) {
        World world = this.o;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a((EntityHuman)null, (World)worldserver, this.p), text, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void a(EntityHuman player, boolean front, List<FilteredText> messages) {
        if (!this.w() && player.cv().equals(this.v()) && this.o != null) {
            this.a(signtext -> this.setMessages(player, messages, (SignText)signtext, front), front);
            this.a((UUID)null);
            this.o.a(this.p(), this.q(), this.q(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)player.ab().getString());
            if (player.i(this.p().u(), this.p().v(), this.p().w()) < 1024.0) {
                ((EntityPlayer)player).c.b(this.j());
            }
        }
    }

    public boolean a(UnaryOperator<SignText> textChanger, boolean front) {
        SignText signtext = this.a(front);
        return this.a((SignText)textChanger.apply(signtext), front);
    }

    private SignText setMessages(EntityHuman entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FilteredText filteredtext = list.get(i2);
            ChatModifier chatmodifier = signtext.a(i2, entityhuman.W()).a();
            signtext = entityhuman.W() ? signtext.a(i2, IChatBaseComponent.b(SharedConstants.a(filteredtext.b())).b(chatmodifier)) : signtext.a(i2, IChatBaseComponent.b(SharedConstants.a(filteredtext.d())).b(chatmodifier), IChatBaseComponent.b(SharedConstants.a(filteredtext.b())).b(chatmodifier));
        }
        CraftPlayer player = ((EntityPlayer)entityhuman).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i3 = 0; i3 < list.size(); ++i3) {
            lines.add(PaperAdventure.asAdventure(signtext.a(i3, entityhuman.W())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.o, this.p), (Player)player, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        entityhuman.dL().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.lines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines.get(i4), event.line(i4))) continue;
            signtext = signtext.a(i4, components[i4]);
        }
        return signtext;
    }

    public boolean a(SignText text, boolean front) {
        return front ? this.c(text) : this.b(text);
    }

    private boolean b(SignText backText) {
        if (backText != this.f) {
            this.f = backText;
            this.x();
            return true;
        }
        return false;
    }

    private boolean c(SignText frontText) {
        if (frontText != this.e) {
            this.e = frontText;
            this.x();
            return true;
        }
        return false;
    }

    public boolean a(boolean front, EntityHuman player) {
        return this.w() && this.a(front).b(player);
    }

    public boolean a(EntityHuman player, World world, BlockPosition pos, boolean front) {
        boolean flag1 = false;
        for (IChatBaseComponent ichatbasecomponent : this.a(front).b(player.W())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable == null || chatclickable.a() != ChatClickable.EnumClickAction.c) continue;
            Object object = command = chatclickable.b().startsWith("/") ? chatclickable.b() : "/" + chatclickable.b();
            if (SpigotConfig.logCommands) {
                a.info("{} issued server command: {}", (Object)player.cx(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cK()), (Sign)MCUtil.toBukkitBlock(this.o, this.p).getState(), front ? Side.FRONT : Side.BACK)).callEvent()) {
                return false;
            }
            player.cK().aC().a(this.a((EntityHuman)((CraftPlayer)event.getPlayer()).getHandle(), world, pos), event.getMessage());
            flag1 = true;
        }
        return flag1;
    }

    @Override
    public void a(IChatBaseComponent message) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.f() != null ? wrapper.f().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean j_() {
        return false;
    }

    @Override
    public boolean v_() {
        return false;
    }

    @Override
    public boolean T_() {
        return false;
    }

    private CommandListenerWrapper a(final @Nullable EntityHuman player, World world, BlockPosition pos) {
        String s2 = player == null ? "Sign" : player.ab().getString();
        IChatBaseComponent object = player == null ? IChatBaseComponent.b("Sign") : player.N_();
        ICommandListener commandSource = this.o.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this){

            @Override
            public void a(IChatBaseComponent message) {
                if (player != null) {
                    player.a(message);
                }
            }

            @Override
            public boolean v_() {
                return true;
            }
        } : this;
        return new CommandListenerWrapper(commandSource, Vec3D.b(pos), Vec2F.a, (WorldServer)world, 2, s2, object, world.n(), player);
    }

    public PacketPlayOutTileEntityData j() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound as_() {
        return this.o();
    }

    @Override
    public boolean t() {
        return true;
    }

    public void a(@Nullable UUID editor) {
        this.d = editor;
    }

    @Nullable
    public UUID v() {
        if (this.l() && this.d != null) {
            this.a(this, this.k(), this.d);
        }
        return this.d;
    }

    private void x() {
        this.e();
        if (this.o != null) {
            this.o.a(this.p(), this.q(), this.q(), 3);
        }
    }

    public boolean w() {
        return this.g;
    }

    public boolean b(boolean waxed) {
        if (this.g != waxed) {
            this.g = waxed;
            this.x();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman entityhuman = this.o.b(uuid);
        return entityhuman == null || entityhuman.i(this.p().u(), this.p().v(), this.p().w()) > 64.0;
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntitySign blockEntity) {
        UUID uuid = blockEntity.v();
        if (uuid != null) {
            blockEntity.a(blockEntity, world, uuid);
        }
    }

    private void a(TileEntitySign blockEntity, World world, UUID uuid) {
        if (blockEntity.b(uuid)) {
            blockEntity.a((UUID)null);
        }
    }
}

