/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String a = "SkullOwner";
    public static final String b = "note_block_sound";
    @Nullable
    private static UserCache c;
    @Nullable
    private static MinecraftSessionService d;
    @Nullable
    private static Executor e;
    private static final Executor f;
    @Nullable
    public GameProfile g;
    @Nullable
    public MinecraftKey h;
    private int i;
    private boolean j;

    public TileEntitySkull(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.p, pos, state);
    }

    public static void a(Services apiServices, Executor executor) {
        c = apiServices.e();
        d = apiServices.b();
        e = executor;
    }

    public static void c() {
        c = null;
        d = null;
        e = null;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.g != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            GameProfileSerializer.a(nbttagcompound1, this.g);
            nbt.a(a, nbttagcompound1);
        }
        if (this.h != null) {
            nbt.a(b, this.h.toString());
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String s2;
        super.a(nbt);
        if (nbt.b(a, 10)) {
            this.a(GameProfileSerializer.a(nbt.p(a)));
        } else if (nbt.b("ExtraType", 8) && !UtilColor.b(s2 = nbt.l("ExtraType"))) {
            this.a(new GameProfile(SystemUtils.d, s2));
        }
        if (nbt.b(b, 8)) {
            this.h = MinecraftKey.a(nbt.l(b));
        }
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntitySkull blockEntity) {
        if (state.b(BlockSkullAbstract.a) && state.c(BlockSkullAbstract.a).booleanValue()) {
            blockEntity.j = true;
            ++blockEntity.i;
        } else {
            blockEntity.j = false;
        }
    }

    public float a(float tickDelta) {
        return this.j ? (float)this.i + tickDelta : (float)this.i;
    }

    @Nullable
    public GameProfile d() {
        return this.g;
    }

    @Nullable
    public MinecraftKey f() {
        return this.h;
    }

    public PacketPlayOutTileEntityData g() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound as_() {
        return this.o();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nullable GameProfile owner) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.g = owner;
        }
        this.i();
    }

    private void i() {
        if (this.g != null && !SystemUtils.b(this.g.getName()) && !TileEntitySkull.c(this.g)) {
            TileEntitySkull.a(this.g.getName()).thenAcceptAsync(optional -> {
                this.g = optional.orElse(this.g);
                this.e();
            }, f);
        } else {
            this.e();
        }
    }

    @Nullable
    public static GameProfile d(NBTTagCompound nbt) {
        String s2;
        if (nbt.b(a, 10)) {
            return GameProfileSerializer.a(nbt.p(a));
        }
        if (nbt.b(a, 8) && !SystemUtils.b(s2 = nbt.l(a))) {
            nbt.r(a);
            TileEntitySkull.a(nbt, s2);
        }
        return null;
    }

    public static void e(NBTTagCompound nbt) {
        String s2 = nbt.l(a);
        if (!SystemUtils.b(s2)) {
            TileEntitySkull.a(nbt, s2);
        } else {
            NBTTagList textures = nbt.p(a).p("Properties").c("textures", 10);
            for (int i2 = 0; i2 < textures.size(); ++i2) {
                if (!(textures.k(i2) instanceof NBTTagCompound) || ((NBTTagCompound)textures.k(i2)).b("Signature", 8) || !((NBTTagCompound)textures.k(i2)).l("Value").trim().isEmpty()) continue;
                nbt.r(a);
                break;
            }
        }
    }

    private static void a(NBTTagCompound nbt, String name) {
        TileEntitySkull.a(name).thenAccept(optional -> nbt.a(a, GameProfileSerializer.a(new NBTTagCompound(), optional.orElse(new GameProfile(SystemUtils.d, name)))));
    }

    private static CompletableFuture<Optional<GameProfile>> a(String name) {
        UserCache usercache = c;
        return usercache == null ? CompletableFuture.completedFuture(Optional.empty()) : ((CompletableFuture)usercache.b(name).thenCompose(optional -> optional.isPresent() ? TileEntitySkull.b((GameProfile)optional.get()) : CompletableFuture.completedFuture(Optional.empty()))).thenApplyAsync(optional -> {
            UserCache usercache1 = c;
            if (usercache1 != null) {
                Objects.requireNonNull(usercache1);
                optional.ifPresent(usercache1::a);
                return optional;
            }
            return Optional.empty();
        }, f);
    }

    public static CompletableFuture<Optional<GameProfile>> b(GameProfile profile) {
        return TileEntitySkull.c(profile) ? CompletableFuture.completedFuture(Optional.of(profile)) : CompletableFuture.supplyAsync(() -> {
            MinecraftSessionService minecraftsessionservice = d;
            if (minecraftsessionservice != null) {
                ProfileResult profileResult;
                if (minecraftsessionservice instanceof PaperMinecraftSessionService) {
                    PaperMinecraftSessionService paperMinecraftSessionService = (PaperMinecraftSessionService)minecraftsessionservice;
                    profileResult = paperMinecraftSessionService.fetchProfile(profile, true);
                } else {
                    profileResult = minecraftsessionservice.fetchProfile(profile.getId(), true);
                }
                ProfileResult profileresult = profileResult;
                return profileresult == null ? Optional.of(profile) : Optional.of(profileresult.profile());
            }
            return Optional.empty();
        }, SystemUtils.PROFILE_EXECUTOR);
    }

    private static boolean c(GameProfile profile) {
        return profile.getProperties().containsKey((Object)"textures");
    }

    static {
        f = runnable -> {
            Executor executor = e;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

