/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ShapeDetectorBuilder {
    private static final Joiner a = Joiner.on((String)",");
    private final List<String[]> b = Lists.newArrayList();
    private final Map<Character, Predicate<ShapeDetectorBlock>> c = Maps.newHashMap();
    private int d;
    private int e;

    private ShapeDetectorBuilder() {
        this.c.put(Character.valueOf(' '), pos -> true);
    }

    public ShapeDetectorBuilder a(String ... pattern) {
        if (ArrayUtils.isEmpty((Object[])pattern) || StringUtils.isEmpty((CharSequence)pattern[0])) {
            throw new IllegalArgumentException("Empty pattern for aisle");
        }
        if (this.b.isEmpty()) {
            this.d = pattern.length;
            this.e = pattern[0].length();
        }
        if (pattern.length != this.d) {
            throw new IllegalArgumentException("Expected aisle with height of " + this.d + ", but was given one with a height of " + pattern.length + ")");
        }
        for (String string : pattern) {
            if (string.length() != this.e) {
                throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.e + ", found one with " + string.length() + ")");
            }
            for (char c2 : string.toCharArray()) {
                if (this.c.containsKey(Character.valueOf(c2))) continue;
                this.c.put(Character.valueOf(c2), null);
            }
        }
        this.b.add(pattern);
        return this;
    }

    public static ShapeDetectorBuilder a() {
        return new ShapeDetectorBuilder();
    }

    public ShapeDetectorBuilder a(char key, Predicate<ShapeDetectorBlock> predicate) {
        this.c.put(Character.valueOf(key), predicate);
        return this;
    }

    public ShapeDetector b() {
        return new ShapeDetector(this.c());
    }

    private Predicate<ShapeDetectorBlock>[][][] c() {
        this.d();
        Predicate[][][] predicates = (Predicate[][][])Array.newInstance(Predicate.class, this.b.size(), this.d, this.e);
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            for (int j2 = 0; j2 < this.d; ++j2) {
                for (int k2 = 0; k2 < this.e; ++k2) {
                    predicates[i2][j2][k2] = this.c.get(Character.valueOf(this.b.get(i2)[j2].charAt(k2)));
                }
            }
        }
        return predicates;
    }

    private void d() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<Character, Predicate<ShapeDetectorBlock>> entry : this.c.entrySet()) {
            if (entry.getValue() != null) continue;
            list.add(entry.getKey());
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + a.join((Iterable)list) + " are missing");
        }
    }
}

