/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_20_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R2.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements IBlockAccess,
BiomeManager.Provider,
LightChunk,
StructureAccess {
    public static final int a = -1;
    private static final Logger n = LogUtils.getLogger();
    private static final LongSet o = new LongOpenHashSet();
    protected final ShortList[] b;
    protected volatile boolean c;
    private volatile boolean p;
    protected final ChunkCoordIntPair d;
    public final long coordinateKey;
    public final int locX;
    public final int locZ;
    private long q;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration r;
    @Nullable
    protected NoiseChunk e;
    protected final ChunkConverter f;
    @Nullable
    protected BlendingData g;
    public final Map<HeightMap.Type, HeightMap> h = Maps.newEnumMap(HeightMap.Type.class);
    private final Map<Structure, StructureStart> s = Maps.newHashMap();
    private final Map<Structure, LongSet> t = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> j = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> k = Maps.newHashMap();
    protected final LevelHeightAccessor l;
    protected final ChunkSection[] m;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private volatile SWMRNibbleArray[] blockNibbles;
    private volatile SWMRNibbleArray[] skyNibbles;
    private volatile boolean[] skyEmptinessMap;
    private volatile boolean[] blockEmptinessMap;
    public final IRegistry<BiomeBase> biomeRegistry;

    public SWMRNibbleArray[] getBlockNibbles() {
        return this.blockNibbles;
    }

    public void setBlockNibbles(SWMRNibbleArray[] nibbles) {
        this.blockNibbles = nibbles;
    }

    public SWMRNibbleArray[] getSkyNibbles() {
        return this.skyNibbles;
    }

    public void setSkyNibbles(SWMRNibbleArray[] nibbles) {
        this.skyNibbles = nibbles;
    }

    public boolean[] getSkyEmptinessMap() {
        return this.skyEmptinessMap;
    }

    public void setSkyEmptinessMap(boolean[] emptinessMap) {
        this.skyEmptinessMap = emptinessMap;
    }

    public boolean[] getBlockEmptinessMap() {
        return this.blockEmptinessMap;
    }

    public void setBlockEmptinessMap(boolean[] emptinessMap) {
        this.blockEmptinessMap = emptinessMap;
    }

    public IChunkAccess(ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelHeightAccessor heightLimitView, IRegistry<BiomeBase> biomeRegistry, long inhabitedTime, @Nullable ChunkSection[] sectionArray, @Nullable BlendingData blendingData) {
        if (!(this instanceof ProtoChunkExtension)) {
            this.setBlockNibbles(StarLightEngine.getFilledEmptyLight(heightLimitView));
            this.setSkyNibbles(StarLightEngine.getFilledEmptyLight(heightLimitView));
        }
        this.locX = pos.e;
        this.locZ = pos.f;
        this.d = pos;
        this.coordinateKey = ChunkCoordIntPair.c(this.locX, this.locZ);
        this.f = upgradeData;
        this.l = heightLimitView;
        this.m = new ChunkSection[heightLimitView.ak()];
        this.q = inhabitedTime;
        this.b = new ShortList[heightLimitView.ak()];
        this.g = blendingData;
        if (sectionArray != null) {
            if (this.m.length == sectionArray.length) {
                System.arraycopy(sectionArray, 0, this.m, 0, this.m.length);
            } else {
                n.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)sectionArray.length, (Object)this.m.length);
            }
        }
        this.a(biomeRegistry, this.m);
        this.biomeRegistry = biomeRegistry;
    }

    private void a(IRegistry<BiomeBase> biomeRegistry, ChunkSection[] sectionArray) {
        for (int i2 = 0; i2 < sectionArray.length; ++i2) {
            if (sectionArray[i2] != null) continue;
            sectionArray[i2] = new ChunkSection(biomeRegistry, this.l instanceof World ? (World)this.l : null, this.d, this.l.g(i2));
        }
    }

    public GameEventListenerRegistry a(int ySectionCoord) {
        return GameEventListenerRegistry.a;
    }

    public abstract IBlockData getBlockState(int var1, int var2, int var3);

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    public int a() {
        ChunkSection[] achunksection = this.d();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.c()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int b() {
        int i2 = this.a();
        return i2 == -1 ? this.H_() : SectionPosition.c(this.g(i2));
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.j.keySet());
        set.addAll(this.k.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.m;
    }

    public ChunkSection b(int yIndex) {
        return this.d()[yIndex];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.h.entrySet());
    }

    public void a(HeightMap.Type type, long[] heightmap) {
        this.a(type).a(this, type, heightmap);
    }

    public HeightMap a(HeightMap.Type type) {
        return this.h.computeIfAbsent(type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean b(HeightMap.Type type) {
        return this.h.get(type) != null;
    }

    public int a(HeightMap.Type type, int x2, int z2) {
        HeightMap heightmap = this.h.get(type);
        if (heightmap == null) {
            if (SharedConstants.aT && this instanceof Chunk) {
                n.error("Unprimed heightmap: " + type + " " + x2 + " " + z2);
            }
            HeightMap.a(this, EnumSet.of(type));
            heightmap = this.h.get(type);
        }
        return heightmap.a(x2 & 0xF, z2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.d;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.s.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart start) {
        this.s.put(structure, start);
        this.c = true;
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.s);
    }

    public void a(Map<Structure, StructureStart> structureStarts) {
        this.s.clear();
        this.s.putAll(structureStarts);
        this.c = true;
    }

    @Override
    public LongSet b(Structure structure) {
        return this.t.getOrDefault(structure, o);
    }

    @Override
    public void a(Structure structure, long reference) {
        this.t.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(reference);
        this.c = true;
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.t);
    }

    @Override
    public void b(Map<Structure, LongSet> structureReferences) {
        this.t.clear();
        this.t.putAll(structureReferences);
        this.c = true;
    }

    public boolean a(int lowerHeight, int upperHeight) {
        if (lowerHeight < this.H_()) {
            lowerHeight = this.H_();
        }
        if (upperHeight >= this.aj()) {
            upperHeight = this.aj() - 1;
        }
        for (int k2 = lowerHeight; k2 <= upperHeight; k2 += 16) {
            if (this.b(this.e(k2)).c()) continue;
            return false;
        }
        return true;
    }

    public void a(boolean needsSaving) {
        this.c = needsSaving;
        if (!needsSaving) {
            this.persistentDataContainer.dirty(false);
        }
    }

    public boolean i() {
        return this.c || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus j();

    public ChunkStatus k() {
        ChunkStatus chunkstatus = this.j();
        BelowZeroRetrogen belowzeroretrogen = this.x();
        if (belowzeroretrogen != null) {
            ChunkStatus chunkstatus1 = belowzeroretrogen.a();
            return chunkstatus1.b(chunkstatus) ? chunkstatus1 : chunkstatus;
        }
        return chunkstatus;
    }

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition pos) {
        n.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)pos);
    }

    public ShortList[] n() {
        return this.b;
    }

    public void a(short packedPos, int index) {
        IChunkAccess.a(this.n(), index).add(packedPos);
    }

    public void a(NBTTagCompound nbt) {
        this.j.put(TileEntity.c(nbt), nbt);
    }

    @Nullable
    public NBTTagCompound f(BlockPosition pos) {
        return this.j.get(pos);
    }

    @Nullable
    public abstract NBTTagCompound g(BlockPosition var1);

    @Override
    public final void a(BiConsumer<BlockPosition, IBlockData> callback) {
        this.a((IBlockData iblockdata) -> iblockdata.h() != 0, callback);
    }

    public void a(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> consumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = this.al(); i2 < this.am(); ++i2) {
            ChunkSection chunksection = this.b(this.f(i2));
            if (!chunksection.a(predicate)) continue;
            BlockPosition blockposition = SectionPosition.a(this.d, i2).j();
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int l2 = 0; l2 < 16; ++l2) {
                        IBlockData iblockdata = chunksection.a(l2, j2, k2);
                        if (!predicate.test(iblockdata)) continue;
                        consumer.accept(blockposition_mutableblockposition.a(blockposition, l2, j2, k2), iblockdata);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> o();

    public abstract TickContainerAccess<FluidType> p();

    public abstract a q();

    public ChunkConverter r() {
        return this.f;
    }

    public boolean s() {
        return this.g != null;
    }

    @Nullable
    public BlendingData t() {
        return this.g;
    }

    public void a(BlendingData blendingData) {
        this.g = blendingData;
    }

    public long u() {
        return this.q;
    }

    public void a(long delta) {
        this.q += delta;
    }

    public void b(long inhabitedTime) {
        this.q = inhabitedTime;
    }

    public static ShortList a(ShortList[] lists, int index) {
        if (lists[index] == null) {
            lists[index] = new ShortArrayList();
        }
        return lists[index];
    }

    public boolean v() {
        return this.p;
    }

    public void b(boolean lightOn) {
        this.p = lightOn;
        this.a(true);
    }

    @Override
    public int H_() {
        return this.l.H_();
    }

    @Override
    public int I_() {
        return this.l.I_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> chunkNoiseSamplerCreator) {
        if (this.e == null) {
            this.e = chunkNoiseSamplerCreator.apply(this);
        }
        return this.e;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> generationSettingsCreator) {
        if (this.r == null) {
            this.r = generationSettingsCreator.get();
        }
        return this.r;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        try {
            int l2 = QuartPos.a(this.H_());
            int i1 = l2 + QuartPos.a(this.I_()) - 1;
            int j1 = MathHelper.a(biomeY, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            return this.m[k1].c(biomeX & 3, j1 & 3, biomeZ & 3);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, biomeX, biomeY, biomeZ));
            throw new ReportedException(crashreport);
        }
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.a(this.H_());
            int i1 = l2 + QuartPos.a(this.I_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            this.m[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being set");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void a(BiomeResolver biomeSupplier, Climate.Sampler sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = QuartPos.a(chunkcoordintpair.d());
        int j2 = QuartPos.a(chunkcoordintpair.e());
        LevelHeightAccessor levelheightaccessor = this.z();
        for (int k2 = levelheightaccessor.al(); k2 < levelheightaccessor.am(); ++k2) {
            ChunkSection chunksection = this.b(this.f(k2));
            int l2 = QuartPos.d(k2);
            chunksection.a(biomeSupplier, sampler, i2, l2, j2);
        }
    }

    public boolean w() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen x() {
        return null;
    }

    public boolean y() {
        return this.x() != null;
    }

    public LevelHeightAccessor z() {
        return this;
    }

    public void A() {
    }

    @Override
    public ChunkSkyLightSources B() {
        return null;
    }

    public record a(SerializableTickContainer<Block> a, SerializableTickContainer<FluidType> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

