/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spigotmc.SpigotWorldConfig;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final Codec<ChunkProviderFlat> c = RecordCodecBuilder.create(instance -> instance.group((App)GeneratorSettingsFlat.a.fieldOf("settings").forGetter(ChunkProviderFlat::g)).apply((Applicative)instance, instance.stable(ChunkProviderFlat::new)));
    private final GeneratorSettingsFlat d;

    public ChunkProviderFlat(GeneratorSettingsFlat config) {
        this(config, new WorldChunkManagerHell(config.d()));
    }

    public ChunkProviderFlat(GeneratorSettingsFlat generatorsettingsflat, WorldChunkManager worldchunkmanager) {
        super(worldchunkmanager, SystemUtils.b(generatorsettingsflat::a));
        this.d = generatorsettingsflat;
    }

    @Override
    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2, SpigotWorldConfig conf) {
        Stream stream = this.d.c().map(HolderSet::a).orElseGet(() -> holderlookup.b().map(holder_c -> holder_c));
        return ChunkGeneratorStructureState.createForFlat(randomstate, i2, this.b, stream, conf);
    }

    @Override
    protected Codec<? extends ChunkGenerator> a() {
        return c;
    }

    public GeneratorSettingsFlat g() {
        return this.d;
    }

    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structures, RandomState noiseConfig, IChunkAccess chunk) {
    }

    @Override
    public int a(LevelHeightAccessor world) {
        return world.H_() + Math.min(world.I_(), this.d.f().size());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, RandomState noiseConfig, StructureManager structureAccessor, IChunkAccess chunk) {
        List<IBlockData> list = this.d.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        HeightMap heightmap = chunk.a(HeightMap.Type.c);
        HeightMap heightmap1 = chunk.a(HeightMap.Type.a);
        for (int i2 = 0; i2 < Math.min(chunk.I_(), list.size()); ++i2) {
            IBlockData iblockdata = list.get(i2);
            if (iblockdata == null) continue;
            int j2 = chunk.H_() + i2;
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int l2 = 0; l2 < 16; ++l2) {
                    chunk.a(blockposition_mutableblockposition.d(k2, j2, l2), iblockdata, false);
                    heightmap.a(k2, j2, l2, iblockdata);
                    heightmap1.a(k2, j2, l2, iblockdata);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        List<IBlockData> list = this.d.f();
        for (int k2 = Math.min(list.size(), world.aj()) - 1; k2 >= 0; --k2) {
            IBlockData iblockdata = list.get(k2);
            if (iblockdata == null || !heightmap.e().test(iblockdata)) continue;
            return world.H_() + k2 + 1;
        }
        return world.H_();
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor world, RandomState noiseConfig) {
        return new BlockColumn(world.H_(), (IBlockData[])this.d.f().stream().limit(world.I_()).map(iblockdata -> iblockdata == null ? Blocks.a.n() : iblockdata).toArray(IBlockData[]::new));
    }

    @Override
    public void a(List<String> text, RandomState noiseConfig, BlockPosition pos) {
    }

    @Override
    public void a(RegionLimitedWorldAccess chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, IChunkAccess chunk, WorldGenStage.Features carverStep) {
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
    }

    @Override
    public int f() {
        return 0;
    }

    @Override
    public int d() {
        return 384;
    }

    @Override
    public int e() {
        return -63;
    }
}

