/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.primitives.Doubles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class BlendingData {
    private static final double f = 0.1;
    protected static final int a = 4;
    protected static final int b = 8;
    protected static final int c = 2;
    private static final double g = 1.0;
    private static final double h = -1.0;
    private static final int i = 2;
    private static final int j = QuartPos.a(16);
    private static final int k = j - 1;
    private static final int l = j;
    private static final int m = 2 * k + 1;
    private static final int n = 2 * l + 1;
    private static final int o = m + n;
    private final LevelHeightAccessor p;
    private static final List<Block> q = List.of(Blocks.l, Blocks.L, Blocks.i, Blocks.b, Blocks.k, Blocks.I, Blocks.K, Blocks.fl, Blocks.dP, Blocks.iA, Blocks.j);
    protected static final double d = Double.MAX_VALUE;
    private boolean r;
    private final double[] s;
    private final List<List<Holder<BiomeBase>>> t;
    private final transient double[][] u;
    private static final Codec<double[]> v = Codec.DOUBLE.listOf().xmap(Doubles::toArray, Doubles::asList);
    public static final Codec<BlendingData> e = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_section").forGetter(blendingData -> blendingData.p.al()), (App)Codec.INT.fieldOf("max_section").forGetter(blendingData -> blendingData.p.am()), (App)v.optionalFieldOf("heights").forGetter(blendingData -> DoubleStream.of(blendingData.s).anyMatch(height -> height != Double.MAX_VALUE) ? Optional.of(blendingData.s) : Optional.empty())).apply((Applicative)instance, BlendingData::new)).comapFlatMap(BlendingData::a, Function.identity());

    private static DataResult<BlendingData> a(BlendingData data) {
        if (data.s.length != o) {
            return DataResult.error(() -> "heights has to be of length " + o);
        }
        return DataResult.success((Object)data);
    }

    private BlendingData(int oldBottomSectionY, int oldTopSectionY, Optional<double[]> heights) {
        this.s = heights.orElse(SystemUtils.a(new double[o], (? super T heights2) -> Arrays.fill(heights2, Double.MAX_VALUE)));
        this.u = new double[o][];
        ObjectArrayList objectArrayList = new ObjectArrayList(o);
        objectArrayList.size(o);
        this.t = objectArrayList;
        int i2 = SectionPosition.c(oldBottomSectionY);
        int j2 = SectionPosition.c(oldTopSectionY) - i2;
        this.p = LevelHeightAccessor.e(i2, j2);
    }

    @Nullable
    public static BlendingData a(RegionLimitedWorldAccess chunkRegion, int chunkX, int chunkZ) {
        IChunkAccess chunkAccess = chunkRegion.a(chunkX, chunkZ);
        BlendingData blendingData = chunkAccess.t();
        if (blendingData == null || !chunkAccess.k().b(ChunkStatus.f)) {
            return null;
        }
        blendingData.a(chunkAccess, BlendingData.a(chunkRegion, chunkX, chunkZ, false));
        return blendingData;
    }

    public static Set<EnumDirection8> a(GeneratorAccessSeed access, int chunkX, int chunkZ, boolean oldNoise) {
        EnumSet<EnumDirection8> set = EnumSet.noneOf(EnumDirection8.class);
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            int j2;
            int i2 = chunkX + direction8.b();
            if (access.a(i2, j2 = chunkZ + direction8.c()).s() != oldNoise) continue;
            set.add(direction8);
        }
        return set;
    }

    private void a(IChunkAccess chunk, Set<EnumDirection8> newNoiseChunkDirections) {
        if (this.r) {
            return;
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.a) || newNoiseChunkDirections.contains((Object)EnumDirection8.g) || newNoiseChunkDirections.contains((Object)EnumDirection8.h)) {
            this.a(BlendingData.a(0, 0), chunk, 0, 0);
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.a)) {
            for (int i2 = 1; i2 < j; ++i2) {
                this.a(BlendingData.a(i2, 0), chunk, 4 * i2, 0);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.g)) {
            for (int j2 = 1; j2 < j; ++j2) {
                this.a(BlendingData.a(0, j2), chunk, 0, 4 * j2);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c)) {
            for (int k2 = 1; k2 < j; ++k2) {
                this.a(BlendingData.b(l, k2), chunk, 15, 4 * k2);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.e)) {
            for (int l2 = 0; l2 < j; ++l2) {
                this.a(BlendingData.b(l2, l), chunk, 4 * l2, 15);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c) && newNoiseChunkDirections.contains((Object)EnumDirection8.b)) {
            this.a(BlendingData.b(l, 0), chunk, 15, 0);
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c) && newNoiseChunkDirections.contains((Object)EnumDirection8.e) && newNoiseChunkDirections.contains((Object)EnumDirection8.d)) {
            this.a(BlendingData.b(l, l), chunk, 15, 15);
        }
        this.r = true;
    }

    private void a(int index, IChunkAccess chunk, int chunkBlockX, int chunkBlockZ) {
        if (this.s[index] == Double.MAX_VALUE) {
            this.s[index] = this.a(chunk, chunkBlockX, chunkBlockZ);
        }
        this.u[index] = this.a(chunk, chunkBlockX, chunkBlockZ, MathHelper.a(this.s[index]));
        this.t.set(index, this.b(chunk, chunkBlockX, chunkBlockZ));
    }

    private int a(IChunkAccess chunk, int blockX, int blockZ) {
        int j2;
        if (chunk.b(HeightMap.Type.a)) {
            int i2 = Math.min(chunk.a(HeightMap.Type.a, blockX, blockZ) + 1, this.p.aj());
        } else {
            j2 = this.p.aj();
        }
        int k2 = this.p.H_();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(blockX, j2, blockZ);
        while (mutableBlockPos.v() > k2) {
            mutableBlockPos.c(EnumDirection.a);
            if (!q.contains(chunk.a_(mutableBlockPos).b())) continue;
            return mutableBlockPos.v();
        }
        return k2;
    }

    private static double a(IChunkAccess chunk, BlockPosition.MutableBlockPosition mutablePos) {
        return BlendingData.a(chunk, (BlockPosition)mutablePos.c(EnumDirection.a)) ? 1.0 : -1.0;
    }

    private static double b(IChunkAccess chunk, BlockPosition.MutableBlockPosition mutablePos) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < 7; ++i2) {
            d2 += BlendingData.a(chunk, mutablePos);
        }
        return d2;
    }

    private double[] a(IChunkAccess chunk, int chunkBlockX, int chunkBlockZ, int surfaceHeight) {
        double[] ds = new double[this.b()];
        Arrays.fill(ds, -1.0);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(chunkBlockX, this.p.aj(), chunkBlockZ);
        double d2 = BlendingData.b(chunk, mutableBlockPos);
        for (int i2 = ds.length - 2; i2 >= 0; --i2) {
            double e2 = BlendingData.a(chunk, mutableBlockPos);
            double f2 = BlendingData.b(chunk, mutableBlockPos);
            ds[i2] = (d2 + e2 + f2) / 15.0;
            d2 = f2;
        }
        int j2 = this.a(MathHelper.a(surfaceHeight, 8));
        if (j2 >= 0 && j2 < ds.length - 1) {
            double g2 = ((double)surfaceHeight + 0.5) % 8.0 / 8.0;
            double h2 = (1.0 - g2) / g2;
            double k2 = Math.max(h2, 1.0) * 0.25;
            ds[j2 + 1] = -h2 / k2;
            ds[j2] = 1.0 / k2;
        }
        return ds;
    }

    private List<Holder<BiomeBase>> b(IChunkAccess chunk, int chunkBlockX, int chunkBlockZ) {
        ObjectArrayList objectArrayList = new ObjectArrayList(this.c());
        objectArrayList.size(this.c());
        for (int i2 = 0; i2 < objectArrayList.size(); ++i2) {
            int j2 = i2 + QuartPos.a(this.p.H_());
            objectArrayList.set(i2, chunk.getNoiseBiome(QuartPos.a(chunkBlockX), j2, QuartPos.a(chunkBlockZ)));
        }
        return objectArrayList;
    }

    private static boolean a(IChunkAccess chunk, BlockPosition pos) {
        IBlockData blockState = chunk.a_(pos);
        if (blockState.i()) {
            return false;
        }
        if (blockState.a(TagsBlock.O)) {
            return false;
        }
        if (blockState.a(TagsBlock.t)) {
            return false;
        }
        if (blockState.a(Blocks.eU) || blockState.a(Blocks.eV)) {
            return false;
        }
        return !blockState.k(chunk, pos).c();
    }

    protected double a(int biomeX, int biomeY, int biomeZ) {
        if (biomeX == l || biomeZ == l) {
            return this.s[BlendingData.b(biomeX, biomeZ)];
        }
        if (biomeX == 0 || biomeZ == 0) {
            return this.s[BlendingData.a(biomeX, biomeZ)];
        }
        return Double.MAX_VALUE;
    }

    private double a(@Nullable double[] collidableBlockDensityColumn, int halfSectionY) {
        if (collidableBlockDensityColumn == null) {
            return Double.MAX_VALUE;
        }
        int i2 = this.a(halfSectionY);
        if (i2 < 0 || i2 >= collidableBlockDensityColumn.length) {
            return Double.MAX_VALUE;
        }
        return collidableBlockDensityColumn[i2] * 0.1;
    }

    protected double b(int chunkBiomeX, int halfSectionY, int chunkBiomeZ) {
        if (halfSectionY == this.e()) {
            return 0.1;
        }
        if (chunkBiomeX == l || chunkBiomeZ == l) {
            return this.a(this.u[BlendingData.b(chunkBiomeX, chunkBiomeZ)], halfSectionY);
        }
        if (chunkBiomeX == 0 || chunkBiomeZ == 0) {
            return this.a(this.u[BlendingData.a(chunkBiomeX, chunkBiomeZ)], halfSectionY);
        }
        return Double.MAX_VALUE;
    }

    protected void a(int biomeX, int biomeY, int biomeZ, a consumer) {
        if (biomeY < QuartPos.a(this.p.H_()) || biomeY >= QuartPos.a(this.p.aj())) {
            return;
        }
        int i2 = biomeY - QuartPos.a(this.p.H_());
        for (int j2 = 0; j2 < this.t.size(); ++j2) {
            Holder<BiomeBase> holder;
            if (this.t.get(j2) == null || (holder = this.t.get(j2).get(i2)) == null) continue;
            consumer.consume(biomeX + BlendingData.b(j2), biomeZ + BlendingData.c(j2), holder);
        }
    }

    protected void a(int biomeX, int biomeZ, c consumer) {
        for (int i2 = 0; i2 < this.s.length; ++i2) {
            double d2 = this.s[i2];
            if (d2 == Double.MAX_VALUE) continue;
            consumer.consume(biomeX + BlendingData.b(i2), biomeZ + BlendingData.c(i2), d2);
        }
    }

    protected void a(int biomeX, int biomeZ, int minHalfSectionY, int maxHalfSectionY, b consumer) {
        int i2 = this.d();
        int j2 = Math.max(0, minHalfSectionY - i2);
        int k2 = Math.min(this.b(), maxHalfSectionY - i2);
        for (int l2 = 0; l2 < this.u.length; ++l2) {
            double[] ds = this.u[l2];
            if (ds == null) continue;
            int m2 = biomeX + BlendingData.b(l2);
            int n2 = biomeZ + BlendingData.c(l2);
            for (int o2 = j2; o2 < k2; ++o2) {
                consumer.consume(m2, o2 + i2, n2, ds[o2] * 0.1);
            }
        }
    }

    private int b() {
        return this.p.ak() * 2;
    }

    private int c() {
        return QuartPos.d(this.p.ak());
    }

    private int d() {
        return this.e() + 1;
    }

    private int e() {
        return this.p.al() * 2;
    }

    private int a(int halfSectionY) {
        return halfSectionY - this.d();
    }

    private static int a(int chunkBiomeX, int chunkBiomeZ) {
        return k - chunkBiomeX + chunkBiomeZ;
    }

    private static int b(int chunkBiomeX, int chunkBiomeZ) {
        return m + chunkBiomeX + l - chunkBiomeZ;
    }

    private static int b(int index) {
        if (index < m) {
            return BlendingData.d(k - index);
        }
        int i2 = index - m;
        return l - BlendingData.d(l - i2);
    }

    private static int c(int index) {
        if (index < m) {
            return BlendingData.d(index - k);
        }
        int i2 = index - m;
        return l - BlendingData.d(i2 - l);
    }

    private static int d(int i2) {
        return i2 & ~(i2 >> 31);
    }

    public LevelHeightAccessor a() {
        return this.p;
    }

    protected static interface a {
        public void consume(int var1, int var2, Holder<BiomeBase> var3);
    }

    protected static interface c {
        public void consume(int var1, int var2, double var3);
    }

    protected static interface b {
        public void consume(int var1, int var2, int var3, double var4);
    }
}

