/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class FeatureCountTracker {
    private static final Logger a = LogUtils.getLogger();
    private static final LoadingCache<WorldServer, b> b = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<WorldServer, b>(){

        @Override
        public b a(WorldServer serverLevel) {
            return new b((Object2IntMap<a>)Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap()), new MutableInt(0));
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.a((WorldServer)object);
        }
    });

    public static void a(WorldServer world) {
        try {
            ((b)b.get((Object)world)).b().increment();
        }
        catch (Exception exception) {
            a.error("Failed to increment chunk count", (Throwable)exception);
        }
    }

    public static void a(WorldServer world, WorldGenFeatureConfigured<?, ?> configuredFeature, Optional<PlacedFeature> placedFeature) {
        try {
            ((b)b.get((Object)world)).a().computeInt((Object)new a(configuredFeature, placedFeature), (featureData, count) -> count == null ? 1 : count + 1);
        }
        catch (Exception exception) {
            a.error("Failed to increment feature count", (Throwable)exception);
        }
    }

    public static void a() {
        b.invalidateAll();
        a.debug("Cleared feature counts");
    }

    public static void b() {
        a.debug("Logging feature counts:");
        b.asMap().forEach((world, features) -> {
            String string = world.ac().a().toString();
            boolean bl = world.n().v();
            IRegistry<PlacedFeature> registry = world.G_().d(Registries.ay);
            String string2 = (bl ? "running" : "dead") + " " + string;
            Integer integer = features.b().getValue();
            a.debug(string2 + " total_chunks: " + integer);
            features.a().forEach((featureData, count) -> a.debug(string2 + " " + String.format(Locale.ROOT, "%10d ", count) + String.format(Locale.ROOT, "%10f ", (double)count.intValue() / (double)integer.intValue()) + featureData.b().flatMap(registry::c).map(ResourceKey::a) + " " + featureData.a().b() + " " + featureData.a()));
        });
    }

    record b(Object2IntMap<a> a, MutableInt b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this, object);
        }
    }

    record a(WorldGenFeatureConfigured<?, ?> a, Optional<PlacedFeature> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this, object);
        }
    }
}

