/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;

public class GeodeFeature
extends WorldGenerator<GeodeConfiguration> {
    private static final EnumDirection[] a = EnumDirection.values();

    public GeodeFeature(Codec<GeodeConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<GeodeConfiguration> context) {
        GeodeConfiguration geodeConfiguration = context.f();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        int i2 = geodeConfiguration.l;
        int j2 = geodeConfiguration.n;
        LinkedList list = Lists.newLinkedList();
        int k2 = geodeConfiguration.j.a(randomSource);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(worldGenLevel.A()));
        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.a(worldgenRandom, -4, 1.0);
        LinkedList list2 = Lists.newLinkedList();
        double d2 = (double)k2 / (double)geodeConfiguration.i.b();
        GeodeLayerSettings geodeLayerSettings = geodeConfiguration.d;
        GeodeBlockSettings geodeBlockSettings = geodeConfiguration.c;
        GeodeCrackSettings geodeCrackSettings = geodeConfiguration.e;
        double e2 = 1.0 / Math.sqrt(geodeLayerSettings.b);
        double f2 = 1.0 / Math.sqrt(geodeLayerSettings.c + d2);
        double g2 = 1.0 / Math.sqrt(geodeLayerSettings.d + d2);
        double h2 = 1.0 / Math.sqrt(geodeLayerSettings.e + d2);
        double l2 = 1.0 / Math.sqrt(geodeCrackSettings.c + randomSource.j() / 2.0 + (k2 > 3 ? d2 : 0.0));
        boolean bl = (double)randomSource.i() < geodeCrackSettings.b;
        int m2 = 0;
        for (int n2 = 0; n2 < k2; ++n2) {
            int q2;
            int p2;
            int o2 = geodeConfiguration.i.a(randomSource);
            BlockPosition blockPos2 = blockPos.b(o2, p2 = geodeConfiguration.i.a(randomSource), q2 = geodeConfiguration.i.a(randomSource));
            IBlockData blockState = worldGenLevel.a_(blockPos2);
            if ((blockState.i() || blockState.a(TagsBlock.bJ)) && ++m2 > geodeConfiguration.p) {
                return false;
            }
            list.add(Pair.of((Object)blockPos2, (Object)geodeConfiguration.k.a(randomSource)));
        }
        if (bl) {
            int r2 = randomSource.a(4);
            int s2 = k2 * 2 + 1;
            if (r2 == 0) {
                list2.add(blockPos.b(s2, 7, 0));
                list2.add(blockPos.b(s2, 5, 0));
                list2.add(blockPos.b(s2, 1, 0));
            } else if (r2 == 1) {
                list2.add(blockPos.b(0, 7, s2));
                list2.add(blockPos.b(0, 5, s2));
                list2.add(blockPos.b(0, 1, s2));
            } else if (r2 == 2) {
                list2.add(blockPos.b(s2, 7, s2));
                list2.add(blockPos.b(s2, 5, s2));
                list2.add(blockPos.b(s2, 1, s2));
            } else {
                list2.add(blockPos.b(0, 7, 0));
                list2.add(blockPos.b(0, 5, 0));
                list2.add(blockPos.b(0, 1, 0));
            }
        }
        ArrayList list3 = Lists.newArrayList();
        Predicate<IBlockData> predicate = GeodeFeature.a(geodeConfiguration.c.g);
        for (BlockPosition blockPos3 : BlockPosition.a(blockPos.b(i2, i2, i2), blockPos.b(j2, j2, j2))) {
            double t2 = normalNoise.a(blockPos3.u(), blockPos3.v(), blockPos3.w()) * geodeConfiguration.o;
            double u2 = 0.0;
            double v2 = 0.0;
            for (Pair pair : list) {
                u2 += MathHelper.f(blockPos3.j((BaseBlockPosition)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue()) + t2;
            }
            for (BlockPosition blockPos4 : list2) {
                v2 += MathHelper.f(blockPos3.j(blockPos4) + (double)geodeCrackSettings.d) + t2;
            }
            if (u2 < h2) continue;
            if (bl && v2 >= l2 && u2 < e2) {
                this.a(worldGenLevel, blockPos3, Blocks.a.n(), predicate);
                for (EnumDirection direction : a) {
                    BlockPosition blockPos5 = blockPos3.a(direction);
                    Fluid fluidState = worldGenLevel.b_(blockPos5);
                    if (fluidState.c()) continue;
                    worldGenLevel.a(blockPos5, fluidState.a(), 0);
                }
                continue;
            }
            if (u2 >= e2) {
                this.a(worldGenLevel, blockPos3, geodeBlockSettings.a.a(randomSource, blockPos3), predicate);
                continue;
            }
            if (u2 >= f2) {
                boolean bl2;
                boolean bl3 = bl2 = (double)randomSource.i() < geodeConfiguration.g;
                if (bl2) {
                    this.a(worldGenLevel, blockPos3, geodeBlockSettings.c.a(randomSource, blockPos3), predicate);
                } else {
                    this.a(worldGenLevel, blockPos3, geodeBlockSettings.b.a(randomSource, blockPos3), predicate);
                }
                if (geodeConfiguration.h && !bl2 || !((double)randomSource.i() < geodeConfiguration.f)) continue;
                list3.add(blockPos3.i());
                continue;
            }
            if (u2 >= g2) {
                this.a(worldGenLevel, blockPos3, geodeBlockSettings.d.a(randomSource, blockPos3), predicate);
                continue;
            }
            if (!(u2 >= h2)) continue;
            this.a(worldGenLevel, blockPos3, geodeBlockSettings.e.a(randomSource, blockPos3), predicate);
        }
        List<IBlockData> list4 = geodeBlockSettings.f;
        block5: for (BlockPosition blockPos6 : list3) {
            IBlockData blockState2 = SystemUtils.a(list4, randomSource);
            for (EnumDirection direction2 : a) {
                if (blockState2.b(BlockProperties.P)) {
                    blockState2 = (IBlockData)blockState2.a(BlockProperties.P, direction2);
                }
                BlockPosition blockPos7 = blockPos6.a(direction2);
                IBlockData blockState3 = worldGenLevel.a_(blockPos7);
                if (blockState2.b(BlockProperties.C)) {
                    blockState2 = (IBlockData)blockState2.a(BlockProperties.C, blockState3.u().b());
                }
                if (!BuddingAmethystBlock.g(blockState3)) continue;
                this.a(worldGenLevel, blockPos7, blockState2, predicate);
                continue block5;
            }
        }
        return true;
    }
}

