/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class WorldGenFoilagePlacerMegaPine
extends WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacerMegaPine> a = RecordCodecBuilder.create(instance -> WorldGenFoilagePlacerMegaPine.b(instance).and((App)IntProvider.b(0, 24).fieldOf("crown_height").forGetter(placer -> placer.b)).apply((Applicative)instance, WorldGenFoilagePlacerMegaPine::new));
    private final IntProvider b;

    public WorldGenFoilagePlacerMegaPine(IntProvider radius, IntProvider offset, IntProvider crownHeight) {
        super(radius, offset);
        this.b = crownHeight;
    }

    @Override
    @Override
    protected WorldGenFoilagePlacers<?> a() {
        return WorldGenFoilagePlacers.h;
    }

    @Override
    @Override
    protected void a(VirtualLevelReadable world, WorldGenFoilagePlacer.b placer, RandomSource random, WorldGenFeatureTreeConfiguration config, int trunkHeight, WorldGenFoilagePlacer.a treeNode, int foliageHeight, int radius, int offset) {
        BlockPosition blockPos = treeNode.a();
        int i2 = 0;
        for (int j2 = blockPos.v() - foliageHeight + offset; j2 <= blockPos.v() + offset; ++j2) {
            int n2;
            int k2 = blockPos.v() - j2;
            int l2 = radius + treeNode.b() + MathHelper.d((float)k2 / (float)foliageHeight * 3.5f);
            if (k2 > 0 && l2 == i2 && (j2 & 1) == 0) {
                int m2 = l2 + 1;
            } else {
                n2 = l2;
            }
            this.a(world, placer, random, config, new BlockPosition(blockPos.u(), j2, blockPos.w()), n2, 0, treeNode.c());
            i2 = l2;
        }
    }

    @Override
    @Override
    public int a(RandomSource random, int trunkHeight, WorldGenFeatureTreeConfiguration config) {
        return this.b.a(random);
    }

    @Override
    @Override
    protected boolean a(RandomSource random, int dx, int y2, int dz, int radius, boolean giantTrunk) {
        if (dx + dz >= 7) {
            return true;
        }
        return dx * dx + dz * dz > radius * radius;
    }
}

