/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftChest;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger a = LogUtils.getLogger();
    protected static final IBlockData e = Blocks.nc.n();
    protected StructureBoundingBox f;
    @Nullable
    private EnumDirection b;
    private EnumBlockMirror c;
    private EnumBlockRotation d;
    protected int g;
    private final WorldGenFeatureStructurePieceType h;
    public static final Set<Block> i = ImmutableSet.builder().add((Object)Blocks.fo).add((Object)Blocks.cp).add((Object)Blocks.cq).add((Object)Blocks.dU).add((Object)Blocks.kd).add((Object)Blocks.ki).add((Object)Blocks.kg).add((Object)Blocks.ke).add((Object)Blocks.kf).add((Object)Blocks.cO).add((Object)Blocks.eX).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
        this.h = type;
        this.g = length;
        this.f = boundingBox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
        this(type, nbt.h("GD"), (StructureBoundingBox)StructureBoundingBox.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("BB")).resultOrPartial(arg_0 -> ((Logger)Objects.requireNonNull(a)).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid boundingbox")));
        int j2 = nbt.h("O");
        this.a(j2 == -1 ? null : EnumDirection.b(j2));
    }

    protected static StructureBoundingBox a(int x2, int y2, int z2, EnumDirection orientation, int width, int height, int depth) {
        return orientation.o() == EnumDirection.EnumAxis.c ? new StructureBoundingBox(x2, y2, z2, x2 + width - 1, y2 + height - 1, z2 + depth - 1) : new StructureBoundingBox(x2, y2, z2, x2 + depth - 1, y2 + height - 1, z2 + width - 1);
    }

    protected static EnumDirection a(RandomSource random) {
        return EnumDirection.EnumDirectionLimit.a.a(random);
    }

    public final NBTTagCompound a(StructurePieceSerializationContext context) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("id", BuiltInRegistries.T.b(this.k()).toString());
        StructureBoundingBox.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f).resultOrPartial(arg_0 -> ((Logger)Objects.requireNonNull(a)).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("BB", (NBTBase)nbtbase));
        EnumDirection enumdirection = this.i();
        nbttagcompound.a("O", enumdirection == null ? -1 : enumdirection.e());
        nbttagcompound.a("GD", this.g);
        this.a(context, nbttagcompound);
        return nbttagcompound;
    }

    protected abstract void a(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
    }

    public abstract void a(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox f() {
        return this.f;
    }

    public int g() {
        return this.g;
    }

    public void a(int chainLength) {
        this.g = chainLength;
    }

    public boolean a(ChunkCoordIntPair pos, int offset) {
        int j2 = pos.d();
        int k2 = pos.e();
        return this.f.a(j2 - offset, k2 - offset, j2 + 15 + offset, k2 + 15 + offset);
    }

    public BlockPosition h() {
        return new BlockPosition(this.f.f());
    }

    protected BlockPosition.MutableBlockPosition b(int x2, int y2, int z2) {
        return new BlockPosition.MutableBlockPosition(this.a(x2, z2), this.b(y2), this.b(x2, z2));
    }

    protected int a(int x2, int z2) {
        EnumDirection enumdirection = this.i();
        if (enumdirection == null) {
            return x2;
        }
        switch (enumdirection) {
            case c: 
            case d: {
                return this.f.g() + x2;
            }
            case e: {
                return this.f.j() - z2;
            }
            case f: {
                return this.f.g() + z2;
            }
        }
        return x2;
    }

    protected int b(int y2) {
        return this.i() == null ? y2 : y2 + this.f.h();
    }

    protected int b(int x2, int z2) {
        EnumDirection enumdirection = this.i();
        if (enumdirection == null) {
            return z2;
        }
        switch (enumdirection) {
            case c: {
                return this.f.l() - z2;
            }
            case d: {
                return this.f.i() + z2;
            }
            case e: 
            case f: {
                return this.f.i() + x2;
            }
        }
        return z2;
    }

    protected void a(GeneratorAccessSeed world, IBlockData block, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
        if (box.b(blockposition_mutableblockposition) && this.a(world, x2, y2, z2, box)) {
            if (this.c != EnumBlockMirror.a) {
                block = block.a(this.c);
            }
            if (this.d != EnumBlockRotation.a) {
                block = block.a(this.d);
            }
            world.a((BlockPosition)blockposition_mutableblockposition, block, 2);
            if (world instanceof TransformerGeneratorAccess) {
                return;
            }
            Fluid fluid = world.b_(blockposition_mutableblockposition);
            if (!fluid.c()) {
                world.a((BlockPosition)blockposition_mutableblockposition, fluid.a(), 0);
            }
            if (i.contains(block.b())) {
                world.x(blockposition_mutableblockposition).e(blockposition_mutableblockposition);
            }
        }
    }

    protected boolean placeCraftBlockEntity(WorldAccess worldAccess, BlockPosition position, CraftBlockEntityState<?> craftBlockEntityState, int i2) {
        if (worldAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
            return transformerAccess.setCraftBlock(position, craftBlockEntityState, i2);
        }
        boolean result = worldAccess.a(position, craftBlockEntityState.getHandle(), i2);
        TileEntity tileEntity = worldAccess.c_(position);
        if (tileEntity != null) {
            tileEntity.a(craftBlockEntityState.getSnapshotNBT());
        }
        return result;
    }

    protected void placeCraftSpawner(WorldAccess worldAccess, BlockPosition position, EntityType entityType, int i2) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState(position, Blocks.ct.n(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(worldAccess, position, spawner, i2);
    }

    protected void setCraftLootTable(WorldAccess worldAccess, BlockPosition position, RandomSource randomSource, MinecraftKey loottableKey) {
        TileEntity tileEntity = worldAccess.c_(position);
        if (tileEntity instanceof TileEntityLootable) {
            TileEntityLootable tileEntityLootable = (TileEntityLootable)tileEntity;
            tileEntityLootable.a(loottableKey, randomSource.g());
            if (worldAccess instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
                transformerAccess.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState(position, tileEntity.q(), tileEntityLootable.m()), 3);
            }
        }
    }

    protected boolean a(IWorldReader world, int x2, int y2, int z2, StructureBoundingBox box) {
        return true;
    }

    protected IBlockData a(IBlockAccess world, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
        return !box.b(blockposition_mutableblockposition) ? Blocks.a.n() : world.a_(blockposition_mutableblockposition);
    }

    protected boolean b(IWorldReader world, int x2, int z2, int y2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, z2 + 1, y2);
        return !box.b(blockposition_mutableblockposition) ? false : blockposition_mutableblockposition.v() < world.a(HeightMap.Type.c, blockposition_mutableblockposition.u(), blockposition_mutableblockposition.w());
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int k1 = minY; k1 <= maxY; ++k1) {
            for (int l1 = minX; l1 <= maxX; ++l1) {
                for (int i2 = minZ; i2 <= maxZ; ++i2) {
                    this.a(world, Blocks.a.n(), l1, k1, i2, bounds);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        for (int k1 = minY; k1 <= maxY; ++k1) {
            for (int l1 = minX; l1 <= maxX; ++l1) {
                for (int i2 = minZ; i2 <= maxZ; ++i2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, l1, k1, i2, box).i()) continue;
                    if (k1 != minY && k1 != maxY && l1 != minX && l1 != maxX && i2 != minZ && i2 != maxZ) {
                        this.a(world, inside, l1, k1, i2, box);
                        continue;
                    }
                    this.a(world, outline, l1, k1, i2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, IBlockData outline, IBlockData inside, boolean cantReplaceAir) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), outline, inside, cantReplaceAir);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean cantReplaceAir, RandomSource random, StructurePieceBlockSelector randomizer) {
        for (int k1 = minY; k1 <= maxY; ++k1) {
            for (int l1 = minX; l1 <= maxX; ++l1) {
                for (int i2 = minZ; i2 <= maxZ; ++i2) {
                    if (cantReplaceAir && this.a((IBlockAccess)world, l1, k1, i2, box).i()) continue;
                    randomizer.a(random, l1, k1, i2, k1 == minY || k1 == maxY || l1 == minX || l1 == maxX || i2 == minZ || i2 == maxZ);
                    this.a(world, randomizer.a(), l1, k1, i2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, StructureBoundingBox fillBox, boolean cantReplaceAir, RandomSource random, StructurePieceBlockSelector randomizer) {
        this.a(world, box, fillBox.g(), fillBox.h(), fillBox.i(), fillBox.j(), fillBox.k(), fillBox.l(), cantReplaceAir, random, randomizer);
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox box, RandomSource random, float blockChance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData outline, IBlockData inside, boolean cantReplaceAir, boolean stayBelowSeaLevel) {
        for (int k1 = minY; k1 <= maxY; ++k1) {
            for (int l1 = minX; l1 <= maxX; ++l1) {
                for (int i2 = minZ; i2 <= maxZ; ++i2) {
                    if (!(random.i() <= blockChance) || cantReplaceAir && this.a((IBlockAccess)world, l1, k1, i2, box).i() || stayBelowSeaLevel && !this.b(world, l1, k1, i2, box)) continue;
                    if (k1 != minY && k1 != maxY && l1 != minX && l1 != maxX && i2 != minZ && i2 != maxZ) {
                        this.a(world, inside, l1, k1, i2, box);
                        continue;
                    }
                    this.a(world, outline, l1, k1, i2, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, RandomSource random, float threshold, int x2, int y2, int z2, IBlockData state) {
        if (random.i() < threshold) {
            this.a(world, state, x2, y2, z2, bounds);
        }
    }

    protected void a(GeneratorAccessSeed world, StructureBoundingBox bounds, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData block, boolean cantReplaceAir) {
        float f2 = maxX - minX + 1;
        float f1 = maxY - minY + 1;
        float f22 = maxZ - minZ + 1;
        float f3 = (float)minX + f2 / 2.0f;
        float f4 = (float)minZ + f22 / 2.0f;
        for (int k1 = minY; k1 <= maxY; ++k1) {
            float f5 = (float)(k1 - minY) / f1;
            for (int l1 = minX; l1 <= maxX; ++l1) {
                float f6 = ((float)l1 - f3) / (f2 * 0.5f);
                for (int i2 = minZ; i2 <= maxZ; ++i2) {
                    float f8;
                    float f7 = ((float)i2 - f4) / (f22 * 0.5f);
                    if (cantReplaceAir && this.a((IBlockAccess)world, l1, k1, i2, bounds).i() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.a(world, block, l1, k1, i2, bounds);
                }
            }
        }
    }

    protected void b(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
        if (box.b(blockposition_mutableblockposition)) {
            while (this.a(world.a_(blockposition_mutableblockposition)) && blockposition_mutableblockposition.v() > world.H_() + 1) {
                world.a((BlockPosition)blockposition_mutableblockposition, state, 2);
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
    }

    protected boolean a(IBlockData state) {
        return state.i() || state.k() || state.a(Blocks.fg) || state.a(Blocks.bw) || state.a(Blocks.bx);
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, MinecraftKey lootTableId) {
        return this.a((WorldAccess)world, boundingBox, random, this.b(x2, y2, z2), lootTableId, (IBlockData)null);
    }

    public static IBlockData a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = null;
        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection1);
            IBlockData iblockdata1 = world.a_(blockposition1);
            if (iblockdata1.a(Blocks.cv)) {
                return state;
            }
            if (!iblockdata1.i(world, blockposition1)) continue;
            if (enumdirection != null) {
                enumdirection = null;
                break;
            }
            enumdirection = enumdirection1;
        }
        if (enumdirection != null) {
            return (IBlockData)state.a(BlockFacingHorizontal.aC, enumdirection.g());
        }
        EnumDirection enumdirection2 = state.c(BlockFacingHorizontal.aC);
        BlockPosition blockposition2 = pos.a(enumdirection2);
        if (world.a_(blockposition2).i(world, blockposition2)) {
            enumdirection2 = enumdirection2.g();
            blockposition2 = pos.a(enumdirection2);
        }
        if (world.a_(blockposition2).i(world, blockposition2)) {
            enumdirection2 = enumdirection2.h();
            blockposition2 = pos.a(enumdirection2);
        }
        if (world.a_(blockposition2).i(world, blockposition2)) {
            enumdirection2 = enumdirection2.g();
            pos.a(enumdirection2);
        }
        return (IBlockData)state.a(BlockFacingHorizontal.aC, enumdirection2);
    }

    protected boolean a(WorldAccess world, StructureBoundingBox boundingBox, RandomSource random, BlockPosition pos, MinecraftKey lootTableId, @Nullable IBlockData block) {
        if (boundingBox.b(pos) && !world.a_(pos).a(Blocks.cv)) {
            if (block == null) {
                block = StructurePiece.a(world, pos, Blocks.cv.n());
            }
            CraftChest chestState = (CraftChest)CraftBlockStates.getBlockState(pos, block, null);
            chestState.setLootTable(Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(lootTableId)));
            chestState.setSeed(random.g());
            this.placeCraftBlockEntity(world, pos, chestState, 2);
            return true;
        }
        return false;
    }

    protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, EnumDirection facing, MinecraftKey lootTableId) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
        if (boundingBox.b(blockposition_mutableblockposition) && !world.a_(blockposition_mutableblockposition).a(Blocks.aU)) {
            if (!this.a(world, x2, y2, z2, boundingBox)) {
                return true;
            }
            IBlockData iblockdata = (IBlockData)Blocks.aU.n().a(BlockDispenser.a, facing);
            if (this.c != EnumBlockMirror.a) {
                iblockdata = iblockdata.a(this.c);
            }
            if (this.d != EnumBlockRotation.a) {
                iblockdata = iblockdata.a(this.d);
            }
            CraftDispenser dispenserState = (CraftDispenser)CraftBlockStates.getBlockState((BlockPosition)blockposition_mutableblockposition, iblockdata, null);
            dispenserState.setLootTable(Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(lootTableId)));
            dispenserState.setSeed(random.g());
            this.placeCraftBlockEntity(world, blockposition_mutableblockposition, dispenserState, 2);
            return true;
        }
        return false;
    }

    public void a(int x2, int y2, int z2) {
        this.f.a(x2, y2, z2);
    }

    public static StructureBoundingBox a(Stream<StructurePiece> pieces) {
        Stream<StructureBoundingBox> stream1 = pieces.map(StructurePiece::f);
        Objects.requireNonNull(stream1);
        return StructureBoundingBox.b(stream1::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece a(List<StructurePiece> pieces, StructureBoundingBox box) {
        StructurePiece structurepiece;
        Iterator<StructurePiece> iterator = pieces.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(structurepiece = iterator.next()).f().a(box));
        return structurepiece;
    }

    @Nullable
    public EnumDirection i() {
        return this.b;
    }

    public void a(@Nullable EnumDirection orientation) {
        this.b = orientation;
        if (orientation == null) {
            this.d = EnumBlockRotation.a;
            this.c = EnumBlockMirror.a;
        } else {
            switch (orientation) {
                case d: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.a;
                    break;
                }
                case e: {
                    this.c = EnumBlockMirror.b;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                case f: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.b;
                    break;
                }
                default: {
                    this.c = EnumBlockMirror.a;
                    this.d = EnumBlockRotation.a;
                }
            }
        }
    }

    public EnumBlockRotation a() {
        return this.d;
    }

    public EnumBlockMirror j() {
        return this.c;
    }

    public WorldGenFeatureStructurePieceType k() {
        return this.h;
    }

    public static abstract class StructurePieceBlockSelector {
        protected IBlockData a = Blocks.a.n();

        public abstract void a(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public IBlockData a() {
            return this.a;
        }
    }
}

