/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class WorldGenFeaturePillagerOutpostPoolPiece
extends StructurePiece {
    private static final Logger d = LogUtils.getLogger();
    protected final WorldGenFeatureDefinedStructurePoolStructure a;
    protected BlockPosition b;
    private final int h;
    protected final EnumBlockRotation c;
    private final List<WorldGenFeatureDefinedStructureJigsawJunction> i = Lists.newArrayList();
    private final StructureTemplateManager j;

    public WorldGenFeaturePillagerOutpostPoolPiece(StructureTemplateManager structureTemplateManager, WorldGenFeatureDefinedStructurePoolStructure poolElement, BlockPosition pos, int groundLevelDelta, EnumBlockRotation rotation, StructureBoundingBox boundingBox) {
        super(WorldGenFeatureStructurePieceType.ad, 0, boundingBox);
        this.j = structureTemplateManager;
        this.a = poolElement;
        this.b = pos;
        this.h = groundLevelDelta;
        this.c = rotation;
    }

    public WorldGenFeaturePillagerOutpostPoolPiece(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        super(WorldGenFeatureStructurePieceType.ad, nbt);
        this.j = context.c();
        this.b = new BlockPosition(nbt.h("PosX"), nbt.h("PosY"), nbt.h("PosZ"));
        this.h = nbt.h("ground_level_delta");
        RegistryOps<NBTBase> dynamicOps = RegistryOps.a(DynamicOpsNBT.a, context.b());
        this.a = (WorldGenFeatureDefinedStructurePoolStructure)WorldGenFeatureDefinedStructurePoolStructure.e.parse(dynamicOps, (Object)nbt.p("pool_element")).resultOrPartial(arg_0 -> ((Logger)d).error(arg_0)).orElseThrow(() -> new IllegalStateException("Invalid pool element found"));
        this.c = EnumBlockRotation.valueOf(nbt.l("rotation"));
        this.f = this.a.a(this.j, this.b, this.c);
        NBTTagList listTag = nbt.c("junctions", 10);
        this.i.clear();
        listTag.forEach(junctionTag -> this.i.add(WorldGenFeatureDefinedStructureJigsawJunction.a(new Dynamic<NBTBase>((DynamicOps<NBTBase>)dynamicOps, (NBTBase)junctionTag))));
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        nbt.a("PosX", this.b.u());
        nbt.a("PosY", this.b.v());
        nbt.a("PosZ", this.b.w());
        nbt.a("ground_level_delta", this.h);
        RegistryOps<NBTBase> dynamicOps = RegistryOps.a(DynamicOpsNBT.a, context.b());
        WorldGenFeatureDefinedStructurePoolStructure.e.encodeStart(dynamicOps, (Object)this.a).resultOrPartial(arg_0 -> ((Logger)d).error(arg_0)).ifPresent(tag -> nbt.a("pool_element", (NBTBase)tag));
        nbt.a("rotation", this.c.name());
        NBTTagList listTag = new NBTTagList();
        for (WorldGenFeatureDefinedStructureJigsawJunction jigsawJunction : this.i) {
            listTag.add(jigsawJunction.a(dynamicOps).getValue());
        }
        nbt.a("junctions", listTag);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
        this.a(world, structureAccessor, chunkGenerator, random, chunkBox, pivot, false);
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox boundingBox, BlockPosition pivot, boolean keepJigsaws) {
        this.a.a(this.j, world, structureAccessor, chunkGenerator, this.b, pivot, this.c, boundingBox, random, keepJigsaws);
    }

    @Override
    @Override
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.b = this.b.b(x2, y2, z2);
    }

    @Override
    @Override
    public EnumBlockRotation a() {
        return this.c;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.b, this.c, this.a);
    }

    public WorldGenFeatureDefinedStructurePoolStructure b() {
        return this.a;
    }

    public BlockPosition c() {
        return this.b;
    }

    public int d() {
        return this.h;
    }

    public void a(WorldGenFeatureDefinedStructureJigsawJunction junction) {
        this.i.add(junction);
    }

    public List<WorldGenFeatureDefinedStructureJigsawJunction> e() {
        return this.i;
    }
}

