/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public class MineshaftPieces {
    static final Logger b = LogUtils.getLogger();
    private static final int c = 3;
    private static final int d = 3;
    private static final int e = 5;
    private static final int f = 20;
    private static final int g = 50;
    private static final int h = 8;
    public static final int a = 50;

    private static c a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int chainLength, MineshaftStructure.a type) {
        int i1 = random.a(100);
        if (i1 >= 80) {
            StructureBoundingBox structureboundingbox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$b.a(holder, random, x2, y2, z2, orientation);
            if (structureboundingbox != null) {
                return new b(chainLength, structureboundingbox, orientation, type);
            }
        } else if (i1 >= 70) {
            StructureBoundingBox structureboundingbox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$e.a(holder, random, x2, y2, z2, orientation);
            if (structureboundingbox != null) {
                return new e(chainLength, structureboundingbox, orientation, type);
            }
        } else {
            StructureBoundingBox structureboundingbox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(holder, random, x2, y2, z2, orientation);
            if (structureboundingbox != null) {
                return new a(chainLength, random, structureboundingbox, orientation, type);
            }
        }
        return null;
    }

    static c a(StructurePiece start, StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x2 - start.f().g()) <= 80 && Math.abs(z2 - start.f().i()) <= 80) {
            MineshaftStructure.a mineshaftstructure_a = ((c)start).a;
            c mineshaftpieces_c = MineshaftPieces.a(holder, random, x2, y2, z2, orientation, chainLength + 1, mineshaftstructure_a);
            if (mineshaftpieces_c != null) {
                holder.a(mineshaftpieces_c);
                mineshaftpieces_c.a(start, holder, random);
            }
            return mineshaftpieces_c;
        }
        return null;
    }

    public static class b
    extends c {
        private final EnumDirection b;
        private final boolean c;

        public b(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.b, nbt);
            this.c = nbt.q("tf");
            this.b = EnumDirection.b(nbt.h("D"));
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("tf", this.c);
            nbt.a("D", this.b.e());
        }

        public b(int chainLength, StructureBoundingBox boundingBox, @Nullable EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.b, chainLength, type, boundingBox);
            this.b = orientation;
            this.c = boundingBox.d() > 3;
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            int b0 = random.a(4) == 0 ? 6 : 2;
            StructureBoundingBox structureboundingbox = switch (orientation) {
                default -> new StructureBoundingBox(-1, 0, -4, 3, b0, 0);
                case EnumDirection.d -> new StructureBoundingBox(-1, 0, 0, 3, b0, 4);
                case EnumDirection.e -> new StructureBoundingBox(-4, 0, -1, 0, b0, 3);
                case EnumDirection.f -> new StructureBoundingBox(0, 0, -1, 4, b0, 3);
            };
            structureboundingbox.a(x2, y2, z2);
            return holder.a(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            int i2 = this.g();
            switch (this.b) {
                default: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                    break;
                }
                case d: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                    break;
                }
                case e: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i() + 1, EnumDirection.e, i2);
                    break;
                }
                case f: {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i() + 1, EnumDirection.f, i2);
                }
            }
            if (this.c) {
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h() + 3 + 1, this.f.i() - 1, EnumDirection.c, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() + 3 + 1, this.f.i() + 1, EnumDirection.e, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() + 3 + 1, this.f.i() + 1, EnumDirection.f, i2);
                }
                if (random.h()) {
                    MineshaftPieces.a(start, holder, random, this.f.g() + 1, this.f.h() + 3 + 1, this.f.l() + 1, EnumDirection.d, i2);
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (!this.a(world, chunkBox)) {
                IBlockData iblockdata = this.a.d();
                if (this.c) {
                    this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i(), this.f.j() - 1, this.f.h() + 3 - 1, this.f.l(), StructurePiece.e, StructurePiece.e, false);
                    this.a(world, chunkBox, this.f.g(), this.f.h(), this.f.i() + 1, this.f.j(), this.f.h() + 3 - 1, this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                    this.a(world, chunkBox, this.f.g() + 1, this.f.k() - 2, this.f.i(), this.f.j() - 1, this.f.k(), this.f.l(), StructurePiece.e, StructurePiece.e, false);
                    this.a(world, chunkBox, this.f.g(), this.f.k() - 2, this.f.i() + 1, this.f.j(), this.f.k(), this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                    this.a(world, chunkBox, this.f.g() + 1, this.f.h() + 3, this.f.i() + 1, this.f.j() - 1, this.f.h() + 3, this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                } else {
                    this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i(), this.f.j() - 1, this.f.k(), this.f.l(), StructurePiece.e, StructurePiece.e, false);
                    this.a(world, chunkBox, this.f.g(), this.f.h(), this.f.i() + 1, this.f.j(), this.f.k(), this.f.l() - 1, StructurePiece.e, StructurePiece.e, false);
                }
                this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.i() + 1, this.f.k());
                this.a(world, chunkBox, this.f.g() + 1, this.f.h(), this.f.l() - 1, this.f.k());
                this.a(world, chunkBox, this.f.j() - 1, this.f.h(), this.f.i() + 1, this.f.k());
                this.a(world, chunkBox, this.f.j() - 1, this.f.h(), this.f.l() - 1, this.f.k());
                int i2 = this.f.h() - 1;
                for (int j2 = this.f.g(); j2 <= this.f.j(); ++j2) {
                    for (int k2 = this.f.i(); k2 <= this.f.l(); ++k2) {
                        this.a(world, chunkBox, iblockdata, j2, i2, k2);
                    }
                }
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, int x2, int minY, int z2, int maxY) {
            if (!this.a((IBlockAccess)world, x2, maxY + 1, z2, boundingBox).i()) {
                this.a(world, boundingBox, x2, minY, z2, x2, maxY, z2, this.a.d(), StructurePiece.e, false);
            }
        }
    }

    public static class e
    extends c {
        public e(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.d, chainLength, type, boundingBox);
            this.a(orientation);
        }

        public e(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.d, nbt);
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            StructureBoundingBox structureboundingbox = switch (orientation) {
                default -> new StructureBoundingBox(0, -5, -8, 2, 2, 0);
                case EnumDirection.d -> new StructureBoundingBox(0, -5, 0, 2, 2, 8);
                case EnumDirection.e -> new StructureBoundingBox(-8, -5, 0, 0, 2, 2);
                case EnumDirection.f -> new StructureBoundingBox(0, -5, 0, 8, 2, 2);
            };
            structureboundingbox.a(x2, y2, z2);
            return holder.a(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            int i2 = this.g();
            EnumDirection enumdirection = this.i();
            if (enumdirection != null) {
                switch (enumdirection) {
                    default: {
                        MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h(), this.f.i() - 1, EnumDirection.c, i2);
                        break;
                    }
                    case d: {
                        MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h(), this.f.l() + 1, EnumDirection.d, i2);
                        break;
                    }
                    case e: {
                        MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), this.f.i(), EnumDirection.e, i2);
                        break;
                    }
                    case f: {
                        MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), this.f.i(), EnumDirection.f, i2);
                    }
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (!this.a(world, chunkBox)) {
                this.a(world, chunkBox, 0, 5, 0, 2, 7, 1, StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, 0, 0, 7, 2, 2, 8, StructurePiece.e, StructurePiece.e, false);
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.a(world, chunkBox, 0, 5 - i2 - (i2 < 4 ? 1 : 0), 2 + i2, 2, 7 - i2, 2 + i2, StructurePiece.e, StructurePiece.e, false);
                }
            }
        }
    }

    public static class a
    extends c {
        private final boolean b;
        private final boolean c;
        private boolean d;
        private final int h;

        public a(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.a, nbt);
            this.b = nbt.q("hr");
            this.c = nbt.q("sc");
            this.d = nbt.q("hps");
            this.h = nbt.h("Num");
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("hr", this.b);
            nbt.a("sc", this.c);
            nbt.a("hps", this.d);
            nbt.a("Num", this.h);
        }

        public a(int chainLength, RandomSource random, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.a, chainLength, type, boundingBox);
            this.a(orientation);
            this.b = random.a(3) == 0;
            this.c = !this.b && random.a(23) == 0;
            this.h = this.i().o() == EnumDirection.EnumAxis.c ? boundingBox.e() / 5 : boundingBox.c() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor holder, RandomSource random, int x2, int y2, int z2, EnumDirection orientation) {
            int l2 = random.a(3) + 2;
            while (l2 > 0) {
                int i1 = l2 * 5;
                StructureBoundingBox structureboundingbox = switch (orientation) {
                    default -> new StructureBoundingBox(0, 0, -(i1 - 1), 2, 2, 0);
                    case EnumDirection.d -> new StructureBoundingBox(0, 0, 0, 2, 2, i1 - 1);
                    case EnumDirection.e -> new StructureBoundingBox(-(i1 - 1), 0, 0, 0, 2, 2);
                    case EnumDirection.f -> new StructureBoundingBox(0, 0, 0, i1 - 1, 2, 2);
                };
                structureboundingbox.a(x2, y2, z2);
                if (holder.a(structureboundingbox) == null) {
                    return structureboundingbox;
                }
                --l2;
            }
            return null;
        }

        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            block24: {
                int i2 = this.g();
                int j2 = random.a(4);
                EnumDirection enumdirection = this.i();
                if (enumdirection != null) {
                    switch (enumdirection) {
                        default: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.i() - 1, enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.i(), EnumDirection.e, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.i(), EnumDirection.f, i2);
                            break;
                        }
                        case d: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.l() + 1, enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.l() - 3, EnumDirection.e, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.l() - 3, EnumDirection.f, i2);
                            break;
                        }
                        case e: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() - 1 + random.a(3), this.f.i(), enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.i() - 1, EnumDirection.c, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.g(), this.f.h() - 1 + random.a(3), this.f.l() + 1, EnumDirection.d, i2);
                            break;
                        }
                        case f: {
                            if (j2 <= 1) {
                                MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() - 1 + random.a(3), this.f.i(), enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.a(start, holder, random, this.f.j() - 3, this.f.h() - 1 + random.a(3), this.f.i() - 1, EnumDirection.c, i2);
                                break;
                            }
                            MineshaftPieces.a(start, holder, random, this.f.j() - 3, this.f.h() - 1 + random.a(3), this.f.l() + 1, EnumDirection.d, i2);
                        }
                    }
                }
                if (i2 >= 8) break block24;
                if (enumdirection != EnumDirection.c && enumdirection != EnumDirection.d) {
                    int l2 = this.f.g() + 3;
                    while (l2 + 3 <= this.f.j()) {
                        int k2 = random.a(5);
                        if (k2 == 0) {
                            MineshaftPieces.a(start, holder, random, l2, this.f.h(), this.f.i() - 1, EnumDirection.c, i2 + 1);
                        } else if (k2 == 1) {
                            MineshaftPieces.a(start, holder, random, l2, this.f.h(), this.f.l() + 1, EnumDirection.d, i2 + 1);
                        }
                        l2 += 5;
                    }
                } else {
                    int l3 = this.f.i() + 3;
                    while (l3 + 3 <= this.f.l()) {
                        int k3 = random.a(5);
                        if (k3 == 0) {
                            MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h(), l3, EnumDirection.e, i2 + 1);
                        } else if (k3 == 1) {
                            MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h(), l3, EnumDirection.f, i2 + 1);
                        }
                        l3 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, RandomSource random, int x2, int y2, int z2, MinecraftKey lootTableId) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
            if (boundingBox.b(blockposition_mutableblockposition) && world.a_(blockposition_mutableblockposition).i() && !world.a_(blockposition_mutableblockposition.d()).i()) {
                IBlockData iblockdata = (IBlockData)Blocks.cP.n().a(BlockMinecartTrack.d, random.h() ? BlockPropertyTrackPosition.a : BlockPropertyTrackPosition.b);
                this.a(world, iblockdata, x2, y2, z2, boundingBox);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(world.C(), (double)blockposition_mutableblockposition.u() + 0.5, (double)blockposition_mutableblockposition.v() + 0.5, (double)blockposition_mutableblockposition.w() + 0.5);
                entityminecartchest.a(lootTableId, random.g());
                world.b(entityminecartchest);
                return true;
            }
            return false;
        }

        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (!this.a(world, chunkBox)) {
                int j2;
                int k2;
                boolean flag = false;
                boolean flag1 = true;
                boolean flag2 = false;
                boolean flag3 = true;
                int i2 = this.h * 5 - 1;
                IBlockData iblockdata = this.a.d();
                this.a(world, chunkBox, 0, 0, 0, 2, 1, i2, StructurePiece.e, StructurePiece.e, false);
                this.a(world, chunkBox, random, 0.8f, 0, 2, 0, 2, 2, i2, StructurePiece.e, StructurePiece.e, false, false);
                if (this.c) {
                    this.a(world, chunkBox, random, 0.6f, 0, 0, 0, 2, 1, i2, Blocks.bs.n(), StructurePiece.e, false, true);
                }
                for (k2 = 0; k2 < this.h; ++k2) {
                    j2 = 2 + k2 * 5;
                    this.a(world, chunkBox, 0, 0, j2, 2, 2, random);
                    this.a(world, chunkBox, random, 0.1f, 0, 2, j2 - 1);
                    this.a(world, chunkBox, random, 0.1f, 2, 2, j2 - 1);
                    this.a(world, chunkBox, random, 0.1f, 0, 2, j2 + 1);
                    this.a(world, chunkBox, random, 0.1f, 2, 2, j2 + 1);
                    this.a(world, chunkBox, random, 0.05f, 0, 2, j2 - 2);
                    this.a(world, chunkBox, random, 0.05f, 2, 2, j2 - 2);
                    this.a(world, chunkBox, random, 0.05f, 0, 2, j2 + 2);
                    this.a(world, chunkBox, random, 0.05f, 2, 2, j2 + 2);
                    if (random.a(100) == 0) {
                        this.a(world, chunkBox, random, 2, 0, j2 - 1, LootTables.u);
                    }
                    if (random.a(100) == 0) {
                        this.a(world, chunkBox, random, 0, 0, j2 + 1, LootTables.u);
                    }
                    if (!this.c || this.d) continue;
                    boolean flag4 = true;
                    int l2 = j2 - 1 + random.a(3);
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(1, 0, l2);
                    if (!chunkBox.b(blockposition_mutableblockposition) || !this.b(world, 1, 0, l2, chunkBox)) continue;
                    this.d = true;
                    this.placeCraftSpawner(world, blockposition_mutableblockposition, EntityType.CAVE_SPIDER, 2);
                }
                for (k2 = 0; k2 <= 2; ++k2) {
                    for (j2 = 0; j2 <= i2; ++j2) {
                        this.a(world, chunkBox, iblockdata, k2, -1, j2);
                    }
                }
                boolean flag5 = true;
                this.a(world, chunkBox, 0, -1, 2);
                if (this.h > 1) {
                    j2 = i2 - 2;
                    this.a(world, chunkBox, 0, -1, j2);
                }
                if (this.b) {
                    IBlockData iblockdata1 = (IBlockData)Blocks.cP.n().a(BlockMinecartTrack.d, BlockPropertyTrackPosition.a);
                    for (int i1 = 0; i1 <= i2; ++i1) {
                        IBlockData iblockdata2 = this.a((IBlockAccess)world, 1, -1, i1, chunkBox);
                        if (iblockdata2.i() || !iblockdata2.i(world, this.b(1, -1, i1))) continue;
                        float f2 = this.b(world, 1, 0, i1, chunkBox) ? 0.7f : 0.9f;
                        this.a(world, chunkBox, random, f2, 1, 0, i1, iblockdata1);
                    }
                }
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox box, int x2, int y2, int z2) {
            IBlockData iblockdata = this.a.b();
            IBlockData iblockdata1 = this.a.d();
            if (this.a((IBlockAccess)world, x2, y2, z2, box).a(iblockdata1.b())) {
                this.c(world, iblockdata, x2, y2, z2, box);
            }
            if (this.a((IBlockAccess)world, x2 + 2, y2, z2, box).a(iblockdata1.b())) {
                this.c(world, iblockdata, x2 + 2, y2, z2, box);
            }
        }

        @Override
        protected void b(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
            if (box.b(blockposition_mutableblockposition)) {
                int l2 = blockposition_mutableblockposition.v();
                while (this.a(world.a_(blockposition_mutableblockposition)) && blockposition_mutableblockposition.v() > world.H_() + 1) {
                    blockposition_mutableblockposition.c(EnumDirection.a);
                }
                if (this.a(world, blockposition_mutableblockposition, world.a_(blockposition_mutableblockposition))) {
                    while (blockposition_mutableblockposition.v() < l2) {
                        blockposition_mutableblockposition.c(EnumDirection.b);
                        world.a((BlockPosition)blockposition_mutableblockposition, state, 2);
                    }
                }
            }
        }

        protected void c(GeneratorAccessSeed world, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
            if (box.b(blockposition_mutableblockposition)) {
                int l2 = blockposition_mutableblockposition.v();
                int i1 = 1;
                boolean flag = true;
                boolean flag1 = true;
                while (flag || flag1) {
                    boolean flag2;
                    IBlockData iblockdata1;
                    if (flag) {
                        blockposition_mutableblockposition.q(l2 - i1);
                        iblockdata1 = world.a_(blockposition_mutableblockposition);
                        boolean bl = flag2 = this.a(iblockdata1) && !iblockdata1.a(Blocks.H);
                        if (!flag2 && this.a(world, blockposition_mutableblockposition, iblockdata1)) {
                            net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(world, state, blockposition_mutableblockposition, l2 - i1 + 1, l2);
                            return;
                        }
                        boolean bl2 = flag = i1 <= 20 && flag2 && blockposition_mutableblockposition.v() > world.H_() + 1;
                    }
                    if (flag1) {
                        blockposition_mutableblockposition.q(l2 + i1);
                        iblockdata1 = world.a_(blockposition_mutableblockposition);
                        flag2 = this.a(iblockdata1);
                        if (!flag2 && this.b(world, blockposition_mutableblockposition, iblockdata1)) {
                            world.a((BlockPosition)blockposition_mutableblockposition.q(l2 + 1), this.a.e(), 2);
                            net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(world, Blocks.eY.n(), blockposition_mutableblockposition, l2 + 2, l2 + i1);
                            return;
                        }
                        flag1 = i1 <= 50 && flag2 && blockposition_mutableblockposition.v() < world.aj() - 1;
                    }
                    ++i1;
                }
            }
        }

        private static void a(GeneratorAccessSeed world, IBlockData state, BlockPosition.MutableBlockPosition pos, int startY, int endY) {
            for (int k2 = startY; k2 < endY; ++k2) {
                world.a((BlockPosition)pos.q(k2), state, 2);
            }
        }

        private boolean a(IWorldReader world, BlockPosition pos, IBlockData state) {
            return state.d(world, pos, EnumDirection.b);
        }

        private boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
            return Block.a(world, pos, EnumDirection.a) && !(state.b() instanceof BlockFalling);
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox boundingBox, int minX, int minY, int z2, int maxY, int maxX, RandomSource random) {
            if (this.a((IBlockAccess)world, boundingBox, minX, maxX, maxY, z2)) {
                IBlockData iblockdata = this.a.d();
                IBlockData iblockdata1 = this.a.e();
                this.a(world, boundingBox, minX, minY, z2, minX, maxY - 1, z2, (IBlockData)iblockdata1.a(BlockTall.d, true), StructurePiece.e, false);
                this.a(world, boundingBox, maxX, minY, z2, maxX, maxY - 1, z2, (IBlockData)iblockdata1.a(BlockTall.b, true), StructurePiece.e, false);
                if (random.a(4) == 0) {
                    this.a(world, boundingBox, minX, maxY, z2, minX, maxY, z2, iblockdata, StructurePiece.e, false);
                    this.a(world, boundingBox, maxX, maxY, z2, maxX, maxY, z2, iblockdata, StructurePiece.e, false);
                } else {
                    this.a(world, boundingBox, minX, maxY, z2, maxX, maxY, z2, iblockdata, StructurePiece.e, false);
                    this.a(world, boundingBox, random, 0.05f, minX + 1, maxY, z2 - 1, (IBlockData)Blocks.cq.n().a(BlockTorchWall.a, EnumDirection.d));
                    this.a(world, boundingBox, random, 0.05f, minX + 1, maxY, z2 + 1, (IBlockData)Blocks.cq.n().a(BlockTorchWall.a, EnumDirection.c));
                }
            }
        }

        private void a(GeneratorAccessSeed world, StructureBoundingBox box, RandomSource random, float threshold, int x2, int y2, int z2) {
            if (this.b(world, x2, y2, z2, box) && random.i() < threshold && this.a(world, box, x2, y2, z2, 2)) {
                this.a(world, Blocks.bs.n(), x2, y2, z2, box);
            }
        }

        private boolean a(GeneratorAccessSeed world, StructureBoundingBox box, int x2, int y2, int z2, int count) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(x2, y2, z2);
            int i1 = 0;
            for (EnumDirection enumdirection : EnumDirection.values()) {
                blockposition_mutableblockposition.c(enumdirection);
                if (box.b(blockposition_mutableblockposition) && world.a_(blockposition_mutableblockposition).d(world, blockposition_mutableblockposition, enumdirection.g()) && ++i1 >= count) {
                    return true;
                }
                blockposition_mutableblockposition.c(enumdirection.g());
            }
            return false;
        }
    }

    private static abstract class c
    extends StructurePiece {
        protected MineshaftStructure.a a;

        public c(WorldGenFeatureStructurePieceType structurePieceType, int chainLength, MineshaftStructure.a type, StructureBoundingBox box) {
            super(structurePieceType, chainLength, box);
            this.a = type;
        }

        public c(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
            this.a = MineshaftStructure.a.a(nbt.h("MST"));
        }

        @Override
        protected boolean a(IWorldReader world, int x2, int y2, int z2, StructureBoundingBox box) {
            IBlockData iblockdata = this.a((IBlockAccess)world, x2, y2, z2, box);
            return !iblockdata.a(this.a.d().b()) && !iblockdata.a(this.a.b().b()) && !iblockdata.a(this.a.e().b()) && !iblockdata.a(Blocks.eY);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            nbt.a("MST", this.a.ordinal());
        }

        protected boolean a(IBlockAccess world, StructureBoundingBox boundingBox, int minX, int maxX, int y2, int z2) {
            for (int i1 = minX; i1 <= maxX; ++i1) {
                if (!this.a(world, i1, y2 + 1, z2, boundingBox).i()) continue;
                return false;
            }
            return true;
        }

        protected boolean a(GeneratorAccess world, StructureBoundingBox box) {
            int l1;
            int k1;
            int j1;
            int i1;
            int i2 = Math.max(this.f.g() - 1, box.g());
            int j2 = Math.max(this.f.h() - 1, box.h());
            int k2 = Math.max(this.f.i() - 1, box.i());
            int l2 = Math.min(this.f.j() + 1, box.j());
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition((i2 + l2) / 2, (j2 + (i1 = Math.min(this.f.k() + 1, box.k()))) / 2, (k2 + (j1 = Math.min(this.f.l() + 1, box.l()))) / 2);
            if (world.s(blockposition_mutableblockposition).a(BiomeTags.X)) {
                return true;
            }
            for (k1 = i2; k1 <= l2; ++k1) {
                for (l1 = k2; l1 <= j1; ++l1) {
                    if (world.a_(blockposition_mutableblockposition.d(k1, j2, l1)).k()) {
                        return true;
                    }
                    if (!world.a_(blockposition_mutableblockposition.d(k1, i1, l1)).k()) continue;
                    return true;
                }
            }
            for (k1 = i2; k1 <= l2; ++k1) {
                for (l1 = j2; l1 <= i1; ++l1) {
                    if (world.a_(blockposition_mutableblockposition.d(k1, l1, k2)).k()) {
                        return true;
                    }
                    if (!world.a_(blockposition_mutableblockposition.d(k1, l1, j1)).k()) continue;
                    return true;
                }
            }
            for (k1 = k2; k1 <= j1; ++k1) {
                for (l1 = j2; l1 <= i1; ++l1) {
                    if (world.a_(blockposition_mutableblockposition.d(i2, l1, k1)).k()) {
                        return true;
                    }
                    if (!world.a_(blockposition_mutableblockposition.d(l2, l1, k1)).k()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void a(GeneratorAccessSeed world, StructureBoundingBox box, IBlockData state, int x2, int y2, int z2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition;
            IBlockData iblockdata1;
            if (this.b(world, x2, y2, z2, box) && !(iblockdata1 = world.a_(blockposition_mutableblockposition = this.b(x2, y2, z2))).d(world, blockposition_mutableblockposition, EnumDirection.b)) {
                world.a((BlockPosition)blockposition_mutableblockposition, state, 2);
            }
        }
    }

    public static class d
    extends c {
        private final List<StructureBoundingBox> b = Lists.newLinkedList();

        public d(int chainLength, RandomSource random, int x2, int z2, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.c, chainLength, type, new StructureBoundingBox(x2, 50, z2, x2 + 7 + random.a(6), 54 + random.a(6), z2 + 7 + random.a(6)));
            this.a = type;
        }

        public d(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.c, nbt);
            DataResult dataresult = StructureBoundingBox.a.listOf().parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("Entrances", 11));
            Logger logger = b;
            Objects.requireNonNull(logger);
            Optional optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            List<StructureBoundingBox> list = this.b;
            Objects.requireNonNull(this.b);
            optional.ifPresent(list::addAll);
        }

        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, RandomSource random) {
            StructureBoundingBox structureboundingbox;
            c mineshaftpieces_c;
            int k2;
            int i2 = this.g();
            int j2 = this.f.d() - 3 - 1;
            if (j2 <= 0) {
                j2 = 1;
            }
            for (k2 = 0; k2 < this.f.c() && (k2 += random.a(this.f.c())) + 3 <= this.f.c(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.a(start, holder, random, this.f.g() + k2, this.f.h() + random.a(j2) + 1, this.f.i() - 1, EnumDirection.c, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.f();
                this.b.add(new StructureBoundingBox(structureboundingbox.g(), structureboundingbox.h(), this.f.i(), structureboundingbox.j(), structureboundingbox.k(), this.f.i() + 1));
            }
            for (k2 = 0; k2 < this.f.c() && (k2 += random.a(this.f.c())) + 3 <= this.f.c(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.a(start, holder, random, this.f.g() + k2, this.f.h() + random.a(j2) + 1, this.f.l() + 1, EnumDirection.d, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.f();
                this.b.add(new StructureBoundingBox(structureboundingbox.g(), structureboundingbox.h(), this.f.l() - 1, structureboundingbox.j(), structureboundingbox.k(), this.f.l()));
            }
            for (k2 = 0; k2 < this.f.e() && (k2 += random.a(this.f.e())) + 3 <= this.f.e(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.a(start, holder, random, this.f.g() - 1, this.f.h() + random.a(j2) + 1, this.f.i() + k2, EnumDirection.e, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.f();
                this.b.add(new StructureBoundingBox(this.f.g(), structureboundingbox.h(), structureboundingbox.i(), this.f.g() + 1, structureboundingbox.k(), structureboundingbox.l()));
            }
            for (k2 = 0; k2 < this.f.e() && (k2 += random.a(this.f.e())) + 3 <= this.f.e(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.a(start, holder, random, this.f.j() + 1, this.f.h() + random.a(j2) + 1, this.f.i() + k2, EnumDirection.f, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.f();
                this.b.add(new StructureBoundingBox(this.f.j() - 1, structureboundingbox.h(), structureboundingbox.i(), this.f.j(), structureboundingbox.k(), structureboundingbox.l()));
            }
        }

        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            if (!this.a(world, chunkBox)) {
                this.a(world, chunkBox, this.f.g(), this.f.h() + 1, this.f.i(), this.f.j(), Math.min(this.f.h() + 3, this.f.k()), this.f.l(), StructurePiece.e, StructurePiece.e, false);
                for (StructureBoundingBox structureboundingbox1 : this.b) {
                    this.a(world, chunkBox, structureboundingbox1.g(), structureboundingbox1.k() - 2, structureboundingbox1.i(), structureboundingbox1.j(), structureboundingbox1.k(), structureboundingbox1.l(), StructurePiece.e, StructurePiece.e, false);
                }
                this.a(world, chunkBox, this.f.g(), this.f.h() + 4, this.f.i(), this.f.j(), this.f.k(), this.f.l(), StructurePiece.e, false);
            }
        }

        @Override
        public void a(int x2, int y2, int z2) {
            super.a(x2, y2, z2);
            for (StructureBoundingBox structureboundingbox : this.b) {
                structureboundingbox.a(x2, y2, z2);
            }
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            DataResult dataresult = StructureBoundingBox.a.listOf().encodeStart((DynamicOps)DynamicOpsNBT.a, this.b);
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Entrances", (NBTBase)nbtbase));
        }
    }
}

