/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class RuinedPortalStructure
extends Structure {
    private static final String[] e = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] f = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float g = 0.05f;
    private static final int h = 15;
    private final List<a> i;
    public static final Codec<RuinedPortalStructure> d = RecordCodecBuilder.create(instance -> instance.group(RuinedPortalStructure.a(instance), (App)ExtraCodecs.a(net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure$a.a.listOf()).fieldOf("setups").forGetter(structure -> structure.i)).apply((Applicative)instance, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.c config, List<a> setups) {
        super(config);
        this.i = setups;
    }

    public RuinedPortalStructure(Structure.c config, a setup) {
        this(config, List.of(setup));
    }

    @Override
    @Override
    public Optional<Structure.b> a(Structure.a context) {
        MinecraftKey resourceLocation2;
        RuinedPortalPiece.a properties = new RuinedPortalPiece.a();
        SeededRandom worldgenRandom = context.f();
        a setup = null;
        if (this.i.size() > 1) {
            float f2 = 0.0f;
            for (a a2 : this.i) {
                f2 += a2.h();
            }
            float g2 = worldgenRandom.i();
            for (a setup3 : this.i) {
                if (!((g2 -= setup3.h() / f2) < 0.0f)) continue;
                setup = setup3;
                break;
            }
        } else {
            setup = this.i.get(0);
        }
        if (setup == null) {
            throw new IllegalStateException();
        }
        a setup4 = setup;
        properties.d = RuinedPortalStructure.a(worldgenRandom, setup4.b());
        properties.c = setup4.c();
        properties.e = setup4.d();
        properties.f = setup4.e();
        properties.g = setup4.g();
        if (worldgenRandom.i() < 0.05f) {
            MinecraftKey resourceLocation = new MinecraftKey(f[worldgenRandom.a(f.length)]);
        } else {
            resourceLocation2 = new MinecraftKey(e[worldgenRandom.a(e.length)]);
        }
        DefinedStructure definedStructure = context.e().a(resourceLocation2);
        EnumBlockRotation rotation = SystemUtils.a(EnumBlockRotation.values(), (RandomSource)worldgenRandom);
        EnumBlockMirror mirror = worldgenRandom.i() < 0.5f ? EnumBlockMirror.a : EnumBlockMirror.c;
        BlockPosition blockPos = new BlockPosition(definedStructure.a().u() / 2, 0, definedStructure.a().w() / 2);
        ChunkGenerator chunkGenerator = context.b();
        LevelHeightAccessor levelHeightAccessor = context.i();
        RandomState randomState = context.d();
        BlockPosition blockPos2 = context.h().l();
        StructureBoundingBox boundingBox = definedStructure.a(blockPos2, rotation, blockPos, mirror);
        BlockPosition blockPos3 = boundingBox.f();
        int i2 = chunkGenerator.a(blockPos3.u(), blockPos3.w(), RuinedPortalPiece.a(setup4.a()), levelHeightAccessor, randomState) - 1;
        int j2 = RuinedPortalStructure.a(worldgenRandom, chunkGenerator, setup4.a(), properties.d, i2, boundingBox.d(), boundingBox, levelHeightAccessor, randomState);
        BlockPosition blockPos4 = new BlockPosition(blockPos2.u(), j2, blockPos2.w());
        return Optional.of(new Structure.b(blockPos4, collector -> {
            if (setup4.f()) {
                properties.b = RuinedPortalStructure.a(blockPos4, context.b().c().getNoiseBiome(QuartPos.a(blockPos4.u()), QuartPos.a(blockPos4.v()), QuartPos.a(blockPos4.w()), randomState.b()));
            }
            collector.a(new RuinedPortalPiece(context.e(), blockPos4, setup4.a(), properties, resourceLocation2, structureTemplate, rotation, mirror, blockPos));
        }));
    }

    private static boolean a(SeededRandom random, float probability) {
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        return random.i() < probability;
    }

    private static boolean a(BlockPosition pos, Holder<BiomeBase> biome) {
        return biome.a().b(pos);
    }

    private static int a(RandomSource random, ChunkGenerator chunkGenerator, RuinedPortalPiece.b verticalPlacement, boolean airPocket, int height, int blockCountY, StructureBoundingBox box, LevelHeightAccessor world, RandomState noiseConfig) {
        int s2;
        int i2 = world.H_() + 15;
        if (verticalPlacement == RuinedPortalPiece.b.f) {
            if (airPocket) {
                int j2 = MathHelper.b(random, 32, 100);
            } else if (random.i() < 0.5f) {
                int k2 = MathHelper.b(random, 27, 29);
            } else {
                int l2 = MathHelper.b(random, 29, 100);
            }
        } else if (verticalPlacement == RuinedPortalPiece.b.d) {
            int m2 = height - blockCountY;
            int n2 = RuinedPortalStructure.a(random, 70, m2);
        } else if (verticalPlacement == RuinedPortalPiece.b.e) {
            int o2 = height - blockCountY;
            int p2 = RuinedPortalStructure.a(random, i2, o2);
        } else if (verticalPlacement == RuinedPortalPiece.b.b) {
            int q2 = height - blockCountY + MathHelper.b(random, 2, 8);
        } else {
            int r2 = height;
        }
        ImmutableList list = ImmutableList.of((Object)new BlockPosition(box.g(), 0, box.i()), (Object)new BlockPosition(box.j(), 0, box.i()), (Object)new BlockPosition(box.g(), 0, box.l()), (Object)new BlockPosition(box.j(), 0, box.l()));
        List list2 = list.stream().map(pos -> chunkGenerator.a(pos.u(), pos.w(), world, noiseConfig)).collect(Collectors.toList());
        HeightMap.Type types = verticalPlacement == RuinedPortalPiece.b.c ? HeightMap.Type.c : HeightMap.Type.a;
        block0: for (s2 = r2; s2 > i2; --s2) {
            int t2 = 0;
            for (BlockColumn noiseColumn : list2) {
                IBlockData blockState = noiseColumn.a(s2);
                if (!types.e().test(blockState) || ++t2 != 3) continue;
                break block0;
            }
        }
        return s2;
    }

    private static int a(RandomSource random, int min, int max) {
        if (min < max) {
            return MathHelper.b(random, min, max);
        }
        return max;
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.l;
    }

    public static final class a
    extends Record {
        private final RuinedPortalPiece.b b;
        private final float c;
        private final float d;
        private final boolean e;
        private final boolean f;
        private final boolean g;
        private final boolean h;
        private final float i;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)RuinedPortalPiece.b.g.fieldOf("placement").forGetter(a::a), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(a::b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(a::c), (App)Codec.BOOL.fieldOf("overgrown").forGetter(a::d), (App)Codec.BOOL.fieldOf("vines").forGetter(a::e), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(a::f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(a::g), (App)ExtraCodecs.k.fieldOf("weight").forGetter(a::h)).apply((Applicative)instance, a::new));

        public a(RuinedPortalPiece.b verticalPlacement, float f2, float g2, boolean bl, boolean bl2, boolean bl3, boolean bl4, float h2) {
            this.b = verticalPlacement;
            this.c = f2;
            this.d = g2;
            this.e = bl;
            this.f = bl2;
            this.g = bl3;
            this.h = bl4;
            this.i = h2;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this, object);
        }

        public RuinedPortalPiece.b a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }

        public boolean e() {
            return this.f;
        }

        public boolean f() {
            return this.g;
        }

        public boolean g() {
            return this.h;
        }

        public float h() {
            return this.i;
        }
    }
}

