/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;

public class NoiseGenerator3 {
    private final NoiseGenerator3Handler[] a;
    private final double b;
    private final double c;

    public NoiseGenerator3(RandomSource random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    private NoiseGenerator3(RandomSource random, IntSortedSet octaves) {
        int j2;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i2 = -octaves.firstInt();
        int k2 = i2 + (j2 = octaves.lastInt()) + 1;
        if (k2 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        NoiseGenerator3Handler simplexNoise = new NoiseGenerator3Handler(random);
        int l2 = j2;
        this.a = new NoiseGenerator3Handler[k2];
        if (l2 >= 0 && l2 < k2 && octaves.contains(0)) {
            this.a[l2] = simplexNoise;
        }
        for (int m2 = l2 + 1; m2 < k2; ++m2) {
            if (m2 >= 0 && octaves.contains(l2 - m2)) {
                this.a[m2] = new NoiseGenerator3Handler(random);
                continue;
            }
            random.b(262);
        }
        if (j2 > 0) {
            long n2 = (long)(simplexNoise.a(simplexNoise.b, simplexNoise.c, simplexNoise.d) * 9.223372036854776E18);
            SeededRandom randomSource = new SeededRandom(new LegacyRandomSource(n2));
            for (int o2 = l2 - 1; o2 >= 0; --o2) {
                if (o2 < k2 && octaves.contains(l2 - o2)) {
                    this.a[o2] = new NoiseGenerator3Handler(randomSource);
                    continue;
                }
                randomSource.b(262);
            }
        }
        this.c = Math.pow(2.0, j2);
        this.b = 1.0 / (Math.pow(2.0, k2) - 1.0);
    }

    public double a(double x2, double y2, boolean useOrigin) {
        double d2 = 0.0;
        double e2 = this.c;
        double f2 = this.b;
        for (NoiseGenerator3Handler simplexNoise : this.a) {
            if (simplexNoise != null) {
                d2 += simplexNoise.a(x2 * e2 + (useOrigin ? simplexNoise.b : 0.0), y2 * e2 + (useOrigin ? simplexNoise.c : 0.0)) * f2;
            }
            e2 /= 2.0;
            f2 *= 2.0;
        }
        return d2;
    }
}

