/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageBlock;

public final class LightEngineBlock
extends LightEngine<LightEngineStorageBlock.a, LightEngineStorageBlock> {
    private final BlockPosition.MutableBlockPosition g = new BlockPosition.MutableBlockPosition();

    public LightEngineBlock(ILightAccess chunkProvider) {
        this(chunkProvider, new LightEngineStorageBlock(chunkProvider));
    }

    @VisibleForTesting
    public LightEngineBlock(ILightAccess chunkProvider, LightEngineStorageBlock blockLightStorage) {
        super(chunkProvider, blockLightStorage);
    }

    @Override
    @Override
    protected void a(long blockPos) {
        int j2;
        long l2 = SectionPosition.e(blockPos);
        if (!((LightEngineStorageBlock)this.f).b(l2)) {
            return;
        }
        IBlockData blockState = this.c(this.g.f(blockPos));
        int i2 = this.a(blockPos, blockState);
        if (i2 < (j2 = ((LightEngineStorageBlock)this.f).e(blockPos))) {
            ((LightEngineStorageBlock)this.f).a(blockPos, 0);
            this.b(blockPos, LightEngine.a.a(j2));
        } else {
            this.b(blockPos, LightEngine.c);
        }
        if (i2 > 0) {
            this.c(blockPos, LightEngine.a.a(i2, LightEngineBlock.a(blockState)));
        }
    }

    @Override
    @Override
    protected void a(long blockPos, long l2, int lightLevel) {
        IBlockData blockState = null;
        for (EnumDirection direction : LightEngine.d) {
            int i2;
            int j2;
            long m2;
            if (!LightEngine.a.a(l2, direction) || !((LightEngineStorageBlock)this.f).b(SectionPosition.e(m2 = BlockPosition.a(blockPos, direction))) || (j2 = lightLevel - 1) <= (i2 = ((LightEngineStorageBlock)this.f).e(m2))) continue;
            this.g.f(m2);
            IBlockData blockState2 = this.c(this.g);
            int k2 = lightLevel - this.a(blockState2, this.g);
            if (k2 <= i2) continue;
            if (blockState == null) {
                IBlockData iBlockData = blockState = LightEngine.a.b(l2) ? Blocks.a.n() : this.c(this.g.f(blockPos));
            }
            if (this.a(blockPos, blockState, m2, blockState2, direction)) continue;
            ((LightEngineStorageBlock)this.f).a(m2, k2);
            if (k2 <= 1) continue;
            this.c(m2, LightEngine.a.a(k2, LightEngineBlock.a(blockState2), direction.g()));
        }
    }

    @Override
    @Override
    protected void a(long blockPos, long l2) {
        int i2 = LightEngine.a.a(l2);
        for (EnumDirection direction : LightEngine.d) {
            int j2;
            long m2;
            if (!LightEngine.a.a(l2, direction) || !((LightEngineStorageBlock)this.f).b(SectionPosition.e(m2 = BlockPosition.a(blockPos, direction))) || (j2 = ((LightEngineStorageBlock)this.f).e(m2)) == 0) continue;
            if (j2 <= i2 - 1) {
                IBlockData blockState = this.c(this.g.f(m2));
                int k2 = this.a(m2, blockState);
                ((LightEngineStorageBlock)this.f).a(m2, 0);
                if (k2 < j2) {
                    this.b(m2, LightEngine.a.a(j2, direction.g()));
                }
                if (k2 <= 0) continue;
                this.c(m2, LightEngine.a.a(k2, LightEngineBlock.a(blockState)));
                continue;
            }
            this.c(m2, LightEngine.a.b(j2, false, direction.g()));
        }
    }

    private int a(long blockPos, IBlockData blockState) {
        int i2 = blockState.h();
        if (i2 > 0 && ((LightEngineStorageBlock)this.f).j(SectionPosition.e(blockPos))) {
            return i2;
        }
        return 0;
    }

    @Override
    @Override
    public void b(ChunkCoordIntPair chunkPos) {
        this.a(chunkPos, true);
        LightChunk lightChunk = this.e.c(chunkPos.e, chunkPos.f);
        if (lightChunk != null) {
            lightChunk.a((BlockPosition blockPos, IBlockData blockState) -> {
                int i2 = blockState.h();
                this.c(blockPos.a(), LightEngine.a.a(i2, LightEngineBlock.a(blockState)));
            });
        }
    }
}

