/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageSky;
import org.jetbrains.annotations.VisibleForTesting;

public final class LightEngineSky
extends LightEngine<LightEngineStorageSky.a, LightEngineStorageSky> {
    private static final long g = LightEngine.a.a(15);
    private static final long h = LightEngine.a.a(15, EnumDirection.b);
    private static final long i = LightEngine.a.a(15, false, EnumDirection.b);
    private final BlockPosition.MutableBlockPosition j = new BlockPosition.MutableBlockPosition();
    private final ChunkSkyLightSources k;

    public LightEngineSky(ILightAccess chunkProvider) {
        this(chunkProvider, new LightEngineStorageSky(chunkProvider));
    }

    @VisibleForTesting
    protected LightEngineSky(ILightAccess chunkProvider, LightEngineStorageSky lightStorage) {
        super(chunkProvider, lightStorage);
        this.k = new ChunkSkyLightSources(chunkProvider.q());
    }

    private static boolean a(int i2) {
        return i2 == 15;
    }

    private int a(int x2, int z2, int i2) {
        ChunkSkyLightSources chunkSkyLightSources = this.b(SectionPosition.a(x2), SectionPosition.a(z2));
        if (chunkSkyLightSources == null) {
            return i2;
        }
        return chunkSkyLightSources.a(SectionPosition.b(x2), SectionPosition.b(z2));
    }

    @Nullable
    private ChunkSkyLightSources b(int chunkX, int chunkZ) {
        LightChunk lightChunk = this.e.c(chunkX, chunkZ);
        return lightChunk != null ? lightChunk.B() : null;
    }

    @Override
    @Override
    protected void a(long blockPos) {
        boolean bl;
        int m2;
        int i2 = BlockPosition.a(blockPos);
        int j2 = BlockPosition.b(blockPos);
        int k2 = BlockPosition.c(blockPos);
        long l2 = SectionPosition.e(blockPos);
        int n2 = m2 = ((LightEngineStorageSky)this.f).j(l2) ? this.a(i2, k2, Integer.MAX_VALUE) : Integer.MAX_VALUE;
        if (m2 != Integer.MAX_VALUE) {
            this.b(i2, k2, m2);
        }
        if (!((LightEngineStorageSky)this.f).b(l2)) {
            return;
        }
        boolean bl2 = bl = j2 >= m2;
        if (bl) {
            this.b(blockPos, h);
            this.c(blockPos, i);
        } else {
            int n3 = ((LightEngineStorageSky)this.f).e(blockPos);
            if (n3 > 0) {
                ((LightEngineStorageSky)this.f).a(blockPos, 0);
                this.b(blockPos, LightEngine.a.a(n3));
            } else {
                this.b(blockPos, LightEngine.c);
            }
        }
    }

    private void b(int i2, int j2, int k2) {
        int l2 = SectionPosition.c(((LightEngineStorageSky)this.f).c());
        this.a(i2, j2, k2, l2);
        this.b(i2, j2, k2, l2);
    }

    private void a(int x2, int z2, int i2, int j2) {
        if (i2 <= j2) {
            return;
        }
        int k2 = SectionPosition.a(x2);
        int l2 = SectionPosition.a(z2);
        int m2 = i2 - 1;
        int n2 = SectionPosition.a(m2);
        while (((LightEngineStorageSky)this.f).a(n2)) {
            if (((LightEngineStorageSky)this.f).b(SectionPosition.b(k2, n2, l2))) {
                int o2 = SectionPosition.c(n2);
                int p2 = o2 + 15;
                for (int q2 = Math.min(p2, m2); q2 >= o2; --q2) {
                    long r2 = BlockPosition.a(x2, q2, z2);
                    if (!LightEngineSky.a(((LightEngineStorageSky)this.f).e(r2))) {
                        return;
                    }
                    ((LightEngineStorageSky)this.f).a(r2, 0);
                    this.b(r2, q2 == i2 - 1 ? g : h);
                }
            }
            --n2;
        }
    }

    private void b(int i2, int j2, int k2, int l2) {
        int m2 = SectionPosition.a(i2);
        int n2 = SectionPosition.a(j2);
        int o2 = Math.max(Math.max(this.a(i2 - 1, j2, Integer.MIN_VALUE), this.a(i2 + 1, j2, Integer.MIN_VALUE)), Math.max(this.a(i2, j2 - 1, Integer.MIN_VALUE), this.a(i2, j2 + 1, Integer.MIN_VALUE)));
        int p2 = Math.max(k2, l2);
        long q2 = SectionPosition.b(m2, SectionPosition.a(p2), n2);
        while (!((LightEngineStorageSky)this.f).l(q2)) {
            if (((LightEngineStorageSky)this.f).b(q2)) {
                int r2 = SectionPosition.c(SectionPosition.c(q2));
                int s2 = r2 + 15;
                for (int t2 = Math.max(r2, p2); t2 <= s2; ++t2) {
                    long u2 = BlockPosition.a(i2, t2, j2);
                    if (LightEngineSky.a(((LightEngineStorageSky)this.f).e(u2))) {
                        return;
                    }
                    ((LightEngineStorageSky)this.f).a(u2, 15);
                    if (t2 >= o2 && t2 != k2) continue;
                    this.c(u2, i);
                }
            }
            q2 = SectionPosition.a(q2, EnumDirection.b);
        }
    }

    @Override
    @Override
    protected void a(long blockPos, long l2, int lightLevel) {
        IBlockData blockState = null;
        int i2 = this.d(blockPos);
        for (EnumDirection direction : LightEngine.d) {
            int j2;
            int k2;
            long m2;
            if (!LightEngine.a.a(l2, direction) || !((LightEngineStorageSky)this.f).b(SectionPosition.e(m2 = BlockPosition.a(blockPos, direction))) || (k2 = lightLevel - 1) <= (j2 = ((LightEngineStorageSky)this.f).e(m2))) continue;
            this.j.f(m2);
            IBlockData blockState2 = this.c(this.j);
            int n2 = lightLevel - this.a(blockState2, this.j);
            if (n2 <= j2) continue;
            if (blockState == null) {
                IBlockData iBlockData = blockState = LightEngine.a.b(l2) ? Blocks.a.n() : this.c(this.j.f(blockPos));
            }
            if (this.a(blockPos, blockState, m2, blockState2, direction)) continue;
            ((LightEngineStorageSky)this.f).a(m2, n2);
            if (n2 > 1) {
                this.c(m2, LightEngine.a.a(n2, LightEngineSky.a(blockState2), direction.g()));
            }
            this.a(m2, direction, n2, true, i2);
        }
    }

    @Override
    @Override
    protected void a(long blockPos, long l2) {
        int i2 = this.d(blockPos);
        int j2 = LightEngine.a.a(l2);
        for (EnumDirection direction : LightEngine.d) {
            int k2;
            long m2;
            if (!LightEngine.a.a(l2, direction) || !((LightEngineStorageSky)this.f).b(SectionPosition.e(m2 = BlockPosition.a(blockPos, direction))) || (k2 = ((LightEngineStorageSky)this.f).e(m2)) == 0) continue;
            if (k2 <= j2 - 1) {
                ((LightEngineStorageSky)this.f).a(m2, 0);
                this.b(m2, LightEngine.a.a(k2, direction.g()));
                this.a(m2, direction, k2, false, i2);
                continue;
            }
            this.c(m2, LightEngine.a.b(k2, false, direction.g()));
        }
    }

    private int d(long blockPos) {
        int i2 = BlockPosition.b(blockPos);
        int j2 = SectionPosition.b(i2);
        if (j2 != 0) {
            return 0;
        }
        int k2 = BlockPosition.a(blockPos);
        int l2 = BlockPosition.c(blockPos);
        int m2 = SectionPosition.b(k2);
        int n2 = SectionPosition.b(l2);
        if (m2 == 0 || m2 == 15 || n2 == 0 || n2 == 15) {
            int o2 = SectionPosition.a(k2);
            int p2 = SectionPosition.a(i2);
            int q2 = SectionPosition.a(l2);
            int r2 = 0;
            while (!((LightEngineStorageSky)this.f).b(SectionPosition.b(o2, p2 - r2 - 1, q2)) && ((LightEngineStorageSky)this.f).a(p2 - r2 - 1)) {
                ++r2;
            }
            return r2;
        }
        return 0;
    }

    private void a(long blockPos, EnumDirection direction, int lightLevel, boolean bl, int i2) {
        if (i2 == 0) {
            return;
        }
        int j2 = BlockPosition.a(blockPos);
        int k2 = BlockPosition.c(blockPos);
        if (!LightEngineSky.a(direction, SectionPosition.b(j2), SectionPosition.b(k2))) {
            return;
        }
        int l2 = BlockPosition.b(blockPos);
        int m2 = SectionPosition.a(j2);
        int n2 = SectionPosition.a(k2);
        int o2 = SectionPosition.a(l2) - 1;
        int p2 = o2 - i2 + 1;
        while (o2 >= p2) {
            if (!((LightEngineStorageSky)this.f).b(SectionPosition.b(m2, o2, n2))) {
                --o2;
                continue;
            }
            int q2 = SectionPosition.c(o2);
            for (int r2 = 15; r2 >= 0; --r2) {
                long s2 = BlockPosition.a(j2, q2 + r2, k2);
                if (bl) {
                    ((LightEngineStorageSky)this.f).a(s2, lightLevel);
                    if (lightLevel <= 1) continue;
                    this.c(s2, LightEngine.a.a(lightLevel, true, direction.g()));
                    continue;
                }
                ((LightEngineStorageSky)this.f).a(s2, 0);
                this.b(s2, LightEngine.a.a(lightLevel, direction.g()));
            }
            --o2;
        }
    }

    private static boolean a(EnumDirection direction, int localX, int localZ) {
        return switch (direction) {
            case EnumDirection.c -> {
                if (localZ == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.d -> {
                if (localZ == 0) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.e -> {
                if (localX == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.f -> {
                if (localX == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
        super.a(pos, retainData);
        if (retainData) {
            ChunkSkyLightSources chunkSkyLightSources = Objects.requireNonNullElse(this.b(pos.e, pos.f), this.k);
            int i2 = chunkSkyLightSources.a() - 1;
            int j2 = SectionPosition.a(i2) + 1;
            long l2 = SectionPosition.b(pos.e, pos.f);
            int k2 = ((LightEngineStorageSky)this.f).m(l2);
            int m2 = Math.max(((LightEngineStorageSky)this.f).c(), j2);
            for (int n2 = k2 - 1; n2 >= m2; --n2) {
                NibbleArray dataLayer = ((LightEngineStorageSky)this.f).c(SectionPosition.b(pos.e, n2, pos.f));
                if (dataLayer == null || !dataLayer.d()) continue;
                dataLayer.a(15);
            }
        }
    }

    @Override
    @Override
    public void b(ChunkCoordIntPair chunkPos) {
        long l2 = SectionPosition.b(chunkPos.e, chunkPos.f);
        ((LightEngineStorageSky)this.f).b(l2, true);
        ChunkSkyLightSources chunkSkyLightSources = Objects.requireNonNullElse(this.b(chunkPos.e, chunkPos.f), this.k);
        ChunkSkyLightSources chunkSkyLightSources2 = Objects.requireNonNullElse(this.b(chunkPos.e, chunkPos.f - 1), this.k);
        ChunkSkyLightSources chunkSkyLightSources3 = Objects.requireNonNullElse(this.b(chunkPos.e, chunkPos.f + 1), this.k);
        ChunkSkyLightSources chunkSkyLightSources4 = Objects.requireNonNullElse(this.b(chunkPos.e - 1, chunkPos.f), this.k);
        ChunkSkyLightSources chunkSkyLightSources5 = Objects.requireNonNullElse(this.b(chunkPos.e + 1, chunkPos.f), this.k);
        int i2 = ((LightEngineStorageSky)this.f).m(l2);
        int j2 = ((LightEngineStorageSky)this.f).c();
        int k2 = SectionPosition.c(chunkPos.e);
        int m2 = SectionPosition.c(chunkPos.f);
        for (int n2 = i2 - 1; n2 >= j2; --n2) {
            long o2 = SectionPosition.b(chunkPos.e, n2, chunkPos.f);
            NibbleArray dataLayer = ((LightEngineStorageSky)this.f).c(o2);
            if (dataLayer == null) continue;
            int p2 = SectionPosition.c(n2);
            int q2 = p2 + 15;
            boolean bl = false;
            for (int r2 = 0; r2 < 16; ++r2) {
                for (int s2 = 0; s2 < 16; ++s2) {
                    int t2 = chunkSkyLightSources.a(s2, r2);
                    if (t2 > q2) continue;
                    int u2 = r2 == 0 ? chunkSkyLightSources2.a(s2, 15) : chunkSkyLightSources.a(s2, r2 - 1);
                    int v2 = r2 == 15 ? chunkSkyLightSources3.a(s2, 0) : chunkSkyLightSources.a(s2, r2 + 1);
                    int w2 = s2 == 0 ? chunkSkyLightSources4.a(15, r2) : chunkSkyLightSources.a(s2 - 1, r2);
                    int x2 = s2 == 15 ? chunkSkyLightSources5.a(0, r2) : chunkSkyLightSources.a(s2 + 1, r2);
                    int y2 = Math.max(Math.max(u2, v2), Math.max(w2, x2));
                    for (int z2 = q2; z2 >= Math.max(p2, t2); --z2) {
                        dataLayer.a(s2, SectionPosition.b(z2), r2, 15);
                        if (z2 != t2 && z2 >= y2) continue;
                        long aa2 = BlockPosition.a(k2 + s2, z2, m2 + r2);
                        this.c(aa2, LightEngine.a.a(z2 == t2, z2 < u2, z2 < v2, z2 < w2, z2 < x2));
                    }
                    if (t2 >= p2) continue;
                    bl = true;
                }
            }
            if (!bl) break;
        }
    }
}

