/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathEntity {
    public final List<PathPoint> a;
    @Nullable
    private a b;
    private int c;
    private final BlockPosition d;
    private final float e;
    private final boolean f;

    public boolean hasNext() {
        return this.f() < this.a.size();
    }

    public PathEntity(List<PathPoint> nodes, BlockPosition target, boolean reachesTarget) {
        this.a = nodes;
        this.d = target;
        this.e = nodes.isEmpty() ? Float.MAX_VALUE : this.a.get(this.a.size() - 1).c(this.d);
        this.f = reachesTarget;
    }

    public void a() {
        ++this.c;
    }

    public boolean b() {
        return this.c <= 0;
    }

    public boolean c() {
        return this.c >= this.a.size();
    }

    @Nullable
    public PathPoint d() {
        return !this.a.isEmpty() ? this.a.get(this.a.size() - 1) : null;
    }

    public PathPoint a(int index) {
        return this.a.get(index);
    }

    public void b(int length) {
        if (this.a.size() > length) {
            this.a.subList(length, this.a.size()).clear();
        }
    }

    public void a(int index, PathPoint node) {
        this.a.set(index, node);
    }

    public int e() {
        return this.a.size();
    }

    public int f() {
        return this.c;
    }

    public void c(int nodeIndex) {
        this.c = nodeIndex;
    }

    public Vec3D a(Entity entity, int index) {
        PathPoint node = this.a.get(index);
        double d2 = (double)node.a + (double)((int)(entity.df() + 1.0f)) * 0.5;
        double e2 = node.b;
        double f2 = (double)node.c + (double)((int)(entity.df() + 1.0f)) * 0.5;
        return new Vec3D(d2, e2, f2);
    }

    public BlockPosition d(int index) {
        return this.a.get(index).a();
    }

    public Vec3D a(Entity entity) {
        return this.a(entity, this.c);
    }

    public BlockPosition g() {
        return this.a.get(this.c).a();
    }

    public PathPoint h() {
        return this.a.get(this.c);
    }

    @Nullable
    public PathPoint i() {
        return this.c > 0 ? this.a.get(this.c - 1) : null;
    }

    public boolean a(@Nullable PathEntity o2) {
        if (o2 == null) {
            return false;
        }
        if (o2.a.size() != this.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            PathPoint node = this.a.get(i2);
            PathPoint node2 = o2.a.get(i2);
            if (node.a == node2.a && node.b == node2.b && node.c == node2.c) continue;
            return false;
        }
        return true;
    }

    public boolean j() {
        return this.f;
    }

    @VisibleForDebug
    void a(PathPoint[] debugNodes, PathPoint[] debugSecondNodes, Set<PathDestination> debugTargetNodes) {
        this.b = new a(debugNodes, debugSecondNodes, debugTargetNodes);
    }

    @Nullable
    public a k() {
        return this.b;
    }

    public void a(PacketDataSerializer buf) {
        if (this.b != null && !this.b.c.isEmpty()) {
            buf.a(this.f);
            buf.p(this.c);
            buf.a(this.d);
            buf.a(this.a, (bufx, node) -> node.a((PacketDataSerializer)((Object)bufx)));
            this.b.a(buf);
        }
    }

    public static PathEntity b(PacketDataSerializer buf) {
        boolean bl = buf.readBoolean();
        int i2 = buf.readInt();
        BlockPosition blockPos = buf.e();
        List<PathPoint> list = buf.a(PathPoint::b);
        a debugData = net.minecraft.world.level.pathfinder.PathEntity$a.b(buf);
        PathEntity path = new PathEntity(list, blockPos, bl);
        path.b = debugData;
        path.c = i2;
        return path;
    }

    public String toString() {
        return "Path(length=" + this.a.size() + ")";
    }

    public BlockPosition l() {
        return this.d;
    }

    public float m() {
        return this.e;
    }

    static PathPoint[] c(PacketDataSerializer buf) {
        PathPoint[] nodes = new PathPoint[buf.m()];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            nodes[i2] = PathPoint.b(buf);
        }
        return nodes;
    }

    static void a(PacketDataSerializer buf, PathPoint[] nodes) {
        buf.c(nodes.length);
        for (PathPoint node : nodes) {
            node.a(buf);
        }
    }

    public PathEntity n() {
        PathEntity path = new PathEntity(this.a, this.d, this.f);
        path.b = this.b;
        path.c = this.c;
        return path;
    }

    public record a(PathPoint[] a, PathPoint[] b, Set<PathDestination> c) {
        public void a(PacketDataSerializer buf) {
            buf.a(this.c, (bufx, node) -> node.a((PacketDataSerializer)((Object)bufx)));
            PathEntity.a(buf, this.a);
            PathEntity.a(buf, this.b);
        }

        public static a b(PacketDataSerializer buf) {
            HashSet hashSet = buf.a(HashSet::new, PathDestination::c);
            PathPoint[] nodes = PathEntity.c(buf);
            PathPoint[] nodes2 = PathEntity.c(buf);
            return new a(nodes, nodes2, hashSet);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this, o2);
        }
    }
}

