/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger b = LogUtils.getLogger();
    static final DateTimeFormatter c = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> d = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String e = "Data";
    private static final PathMatcher f = path -> false;
    public static final String a = "allowed_symlinks.txt";
    private static final int g = 0x6400000;
    public final Path h;
    private final Path i;
    final DataFixer j;
    private final DirectoryValidator k;

    public Convertable(Path savesDirectory, Path backupsDirectory, DirectoryValidator symlinkFinder, DataFixer dataFixer) {
        this.j = dataFixer;
        try {
            FileUtils.c(savesDirectory);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.h = savesDirectory;
        this.i = backupsDirectory;
        this.k = symlinkFinder;
    }

    public static DirectoryValidator a(Path allowedSymlinksFile) {
        if (Files.exists(allowedSymlinksFile, new LinkOption[0])) {
            try {
                DirectoryValidator directoryvalidator;
                try (BufferedReader bufferedreader = Files.newBufferedReader(allowedSymlinksFile);){
                    directoryvalidator = new DirectoryValidator(PathAllowList.a(bufferedreader));
                }
                return directoryvalidator;
            }
            catch (Exception exception) {
                b.error("Failed to parse {}, disallowing all symbolic links", (Object)a, (Object)exception);
            }
        }
        return new DirectoryValidator(f);
    }

    public static Convertable b(Path path) {
        DirectoryValidator directoryvalidator = Convertable.a(path.resolve(a));
        return new Convertable(path, path.resolve("../backups"), directoryvalidator, DataConverterRegistry.a());
    }

    private static <T> DataResult<GeneratorSettings> a(Dynamic<T> levelData, DataFixer dataFixer, int version) {
        Dynamic dynamic1 = levelData.get("WorldGenSettings").orElseEmptyMap();
        for (String s2 : d) {
            Optional optional = levelData.get(s2).result();
            if (!optional.isPresent()) continue;
            dynamic1 = dynamic1.set(s2, (Dynamic)((Object)optional.get()));
        }
        Dynamic dynamic2 = DataFixTypes.r.a(dataFixer, dynamic1, version);
        return GeneratorSettings.a.parse(dynamic2);
    }

    private static WorldDataConfiguration a(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.b.parse(dynamic);
        Logger logger = b;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.c);
    }

    public String a() {
        return "Anvil";
    }

    public a b() throws LevelStorageException {
        if (!Files.isDirectory(this.h, new LinkOption[0])) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
        try {
            a convertable_a;
            try (Stream<Path> stream = Files.list(this.h);){
                List<b> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(b::new).filter(convertable_b -> Files.isRegularFile(convertable_b.b(), new LinkOption[0]) || Files.isRegularFile(convertable_b.c(), new LinkOption[0])).toList();
                convertable_a = new a(list);
            }
            return convertable_a;
        }
        catch (IOException ioexception) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<WorldInfo>> a(a levels) {
        ArrayList<CompletableFuture<WorldInfo>> list = new ArrayList<CompletableFuture<WorldInfo>>(levels.a.size());
        for (b convertable_b : levels.a) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = SessionLock.b(convertable_b.f());
                }
                catch (Exception exception) {
                    b.warn("Failed to read {} lock", (Object)convertable_b.f(), (Object)exception);
                    return null;
                }
                try {
                    WorldInfo worldinfo = this.a(convertable_b, this.a(convertable_b, flag));
                    return worldinfo != null ? worldinfo : null;
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.b();
                    System.gc();
                    String s2 = "Ran out of memory trying to read summary of world folder \"" + convertable_b.a() + "\"";
                    b.error(LogUtils.FATAL_MARKER, s2);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.a(outofmemoryerror1, s2);
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("World details");
                    crashreportsystemdetails.a("Folder Name", convertable_b.a());
                    try {
                        long i2 = Files.size(convertable_b.b());
                        crashreportsystemdetails.a("level.dat size", i2);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.a("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, SystemUtils.f()));
        }
        return SystemUtils.d(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int f() {
        return 19133;
    }

    @Nullable
    <T> T a(b levelSave, BiFunction<Path, DataFixer, T> levelDataParser) {
        T t0;
        if (!Files.exists(levelSave.f(), new LinkOption[0])) {
            return null;
        }
        Path path = levelSave.b();
        if (Files.exists(path, new LinkOption[0]) && (t0 = levelDataParser.apply(path, this.j)) != null) {
            return t0;
        }
        path = levelSave.c();
        return Files.exists(path, new LinkOption[0]) ? (T)levelDataParser.apply(path, this.j) : null;
    }

    @Nullable
    private static WorldDataConfiguration a(Path path, DataFixer dataFixer) {
        try {
            NBTBase nbtbase = Convertable.c(path);
            if (nbtbase instanceof NBTTagCompound) {
                NBTTagCompound nbttagcompound = (NBTTagCompound)nbtbase;
                NBTTagCompound nbttagcompound1 = nbttagcompound.p(e);
                int i2 = GameProfileSerializer.b(nbttagcompound1, -1);
                Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a(dataFixer, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2);
                return Convertable.a(dynamic);
            }
        }
        catch (Exception exception) {
            b.error("Exception reading {}", (Object)path, (Object)exception);
        }
        return null;
    }

    static BiFunction<Path, DataFixer, Pair<SaveData, WorldDimensions.b>> a(DynamicOps<NBTBase> ops, WorldDataConfiguration dataConfiguration, IRegistry<WorldDimension> dimensionOptionsRegistry, Lifecycle lifecycle) {
        return (path, datafixer) -> {
            NBTTagCompound nbttagcompound;
            try {
                nbttagcompound = NBTCompressedStreamTools.a(path.toFile());
            }
            catch (IOException ioexception) {
                throw new UncheckedIOException(ioexception);
            }
            NBTTagCompound nbttagcompound1 = nbttagcompound.p(e);
            NBTTagCompound nbttagcompound2 = nbttagcompound1.b("Player", 10) ? nbttagcompound1.p("Player") : null;
            nbttagcompound1.r("Player");
            int i2 = GameProfileSerializer.b(nbttagcompound1, -1);
            Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a((DataFixer)datafixer, new Dynamic<NBTTagCompound>(ops, nbttagcompound1), i2);
            DataResult<GeneratorSettings> dataresult = Convertable.a(dynamic, datafixer, i2);
            Logger logger = b;
            Objects.requireNonNull(logger);
            GeneratorSettings generatorsettings = (GeneratorSettings)dataresult.getOrThrow(false, SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0)));
            LevelVersion levelversion = LevelVersion.a(dynamic);
            WorldSettings worldsettings = WorldSettings.a(dynamic, dataConfiguration);
            WorldDimensions.b worlddimensions_b = generatorsettings.b().a(dimensionOptionsRegistry);
            Lifecycle lifecycle1 = worlddimensions_b.a().add(lifecycle);
            WorldDataServer worlddataserver = WorldDataServer.a(dynamic, datafixer, i2, nbttagcompound2, worldsettings, levelversion, worlddimensions_b.d(), generatorsettings.a(), lifecycle1);
            worlddataserver.pdc = nbttagcompound1.c("BukkitValues");
            return Pair.of((Object)worlddataserver, (Object)worlddimensions_b);
        };
    }

    BiFunction<Path, DataFixer, WorldInfo> a(b levelSave, boolean locked) {
        return (path, datafixer) -> {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.k.a((Path)path)).isEmpty()) {
                    b.warn("{}", (Object)ContentValidationException.a(path, list));
                    return new WorldInfo.b(levelSave.a(), levelSave.d());
                }
                NBTBase nbtbase = Convertable.c(path);
                if (nbtbase instanceof NBTTagCompound) {
                    int i2;
                    NBTTagCompound nbttagcompound = (NBTTagCompound)nbtbase;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.p(e);
                    Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a((DataFixer)datafixer, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2 = GameProfileSerializer.b(nbttagcompound1, -1));
                    LevelVersion levelversion = LevelVersion.a(dynamic);
                    int j2 = levelversion.a();
                    if (j2 == 19132 || j2 == 19133) {
                        boolean flag1 = j2 != this.f();
                        Path path1 = levelSave.d();
                        WorldDataConfiguration worlddataconfiguration = Convertable.a(dynamic);
                        WorldSettings worldsettings = WorldSettings.a(dynamic, worlddataconfiguration);
                        FeatureFlagSet featureflagset = Convertable.b(dynamic);
                        boolean flag2 = FeatureFlags.a(featureflagset);
                        return new WorldInfo(worldsettings, levelversion, levelSave.a(), flag1, locked, flag2, path1);
                    }
                } else {
                    b.warn("Invalid root tag in {}", path);
                }
                return null;
            }
            catch (Exception exception) {
                b.error("Exception reading {}", path, (Object)exception);
                return null;
            }
        };
    }

    private static FeatureFlagSet b(Dynamic<?> levelData) {
        Set<MinecraftKey> set = levelData.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(MinecraftKey::a).stream()).collect(Collectors.toSet());
        return FeatureFlags.d.a(set, (MinecraftKey minecraftkey) -> {});
    }

    @Nullable
    private static NBTBase c(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(e, NBTTagCompound.b, "Player"), new FieldSelector(e, NBTTagCompound.b, "WorldGenSettings"));
        NBTCompressedStreamTools.a(path.toFile(), (StreamTagVisitor)skipfields, NBTReadLimiter.a(0x6400000L));
        return skipfields.d();
    }

    public boolean a(String name) {
        try {
            Path path = this.c(name);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean b(String name) {
        try {
            return Files.isDirectory(this.c(name), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path c(String name) {
        return this.h.resolve(name);
    }

    public Path c() {
        return this.h;
    }

    public Path d() {
        return this.i;
    }

    public ConversionSession validateAndCreateAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException, ContentValidationException {
        Path path = this.c(s2);
        List<ForbiddenSymlinkInfo> list = this.k.a(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new ConversionSession(s2, path, dimensionType);
    }

    public ConversionSession createAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
        Path path = this.c(s2);
        return new ConversionSession(s2, path, dimensionType);
    }

    public DirectoryValidator e() {
        return this.k;
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.b) {
            return path;
        }
        if (dimensionType == WorldDimension.c) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.d) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.a().b()).resolve(dimensionType.a().a());
    }

    public record a(List<b> a) implements Iterable<b>
    {
        private final List<b> a;

        public boolean a() {
            return this.a.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "a"}, this, o2);
        }

        public List<b> b() {
            return this.a;
        }
    }

    public record b(Path a) {
        private final Path a;

        public String a() {
            return this.a.getFileName().toString();
        }

        public Path b() {
            return this.a(SavedFile.e);
        }

        public Path c() {
            return this.a(SavedFile.f);
        }

        public Path a(LocalDateTime dateTime) {
            Path path = this.a;
            String s2 = SavedFile.e.a();
            return path.resolve(s2 + "_corrupted_" + dateTime.format(c));
        }

        public Path d() {
            return this.a(SavedFile.g);
        }

        public Path e() {
            return this.a(SavedFile.h);
        }

        public Path a(SavedFile savePath) {
            return this.a.resolve(savePath.a());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path", "a"}, this, o2);
        }

        public Path f() {
            return this.a;
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock b;
        public final b c;
        private final String d;
        private final Map<SavedFile, Path> e = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        ConversionSession(String s2, Path path, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.d = s2;
            this.c = new b(path);
            this.b = SessionLock.a(path);
        }

        public Convertable a() {
            return Convertable.this;
        }

        public String b() {
            return this.d;
        }

        public Path a(SavedFile savePath) {
            Map<SavedFile, Path> map = this.e;
            b convertable_b = this.c;
            Objects.requireNonNull(this.c);
            return map.computeIfAbsent(savePath, convertable_b::a);
        }

        public Path a(ResourceKey<World> key) {
            return Convertable.getStorageFolder(this.c.f(), this.dimensionType);
        }

        private void i() {
            if (!this.b.a()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage c() {
            this.i();
            return new WorldNBTStorage(this, Convertable.this.j);
        }

        @Nullable
        public WorldInfo d() {
            this.i();
            return Convertable.this.a(this.c, Convertable.this.a(this.c, false));
        }

        @Nullable
        public Pair<SaveData, WorldDimensions.b> a(DynamicOps<NBTBase> ops, WorldDataConfiguration dataConfiguration, IRegistry<WorldDimension> dimensionOptionsRegistry, Lifecycle lifecycle) {
            this.i();
            return Convertable.this.a(this.c, Convertable.a(ops, dataConfiguration, dimensionOptionsRegistry, lifecycle));
        }

        @Nullable
        public WorldDataConfiguration e() {
            this.i();
            return Convertable.this.a(this.c, Convertable::a);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties) {
            this.a(registryManager, saveProperties, null);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties, @Nullable NBTTagCompound nbt) {
            File file = this.c.f().toFile();
            NBTTagCompound nbttagcompound1 = saveProperties.a(registryManager, nbt);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a(Convertable.e, nbttagcompound1);
            try {
                File file1 = File.createTempFile("level", ".dat", file);
                NBTCompressedStreamTools.a(nbttagcompound2, file1);
                File file2 = this.c.c().toFile();
                File file3 = this.c.b().toFile();
                SystemUtils.a(file3, file1, file2);
            }
            catch (Exception exception) {
                b.error("Failed to save level {}", (Object)file, (Object)exception);
            }
        }

        public Optional<Path> f() {
            return !this.b.a() ? Optional.empty() : Optional.of(this.c.d());
        }

        public void g() throws IOException {
            this.i();
            final Path path = this.c.e();
            b.info("Deleting level {}", (Object)this.d);
            for (int i2 = 1; i2 <= 5; ++i2) {
                b.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult a(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                Convertable.b.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(ConversionSession.this.c.f())) {
                                ConversionSession.this.b.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i2 >= 5) {
                        throw ioexception;
                    }
                    b.warn("Failed to delete {}", (Object)this.c.f(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void a(String name) throws IOException {
            this.i();
            Path path = this.c.b();
            if (Files.exists(path, new LinkOption[0])) {
                NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a(path.toFile());
                NBTTagCompound nbttagcompound1 = nbttagcompound.p(Convertable.e);
                nbttagcompound1.a("LevelName", name);
                NBTCompressedStreamTools.a(nbttagcompound, path.toFile());
            }
        }

        public long h() throws IOException {
            this.i();
            String s2 = LocalDateTime.now().format(c);
            String s1 = s2 + "_" + this.d;
            Path path = Convertable.this.d();
            try {
                FileUtils.c(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtils.a(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.d, new String[0]);
                Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(ConversionSession.this.c.f().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }
    }
}

