/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;

@FunctionalInterface
public interface LootDataResolver {
    @Nullable
    public <T> T getElement(LootDataId<T> var1);

    @Nullable
    default public <T> T getElement(LootDataType<T> type, MinecraftKey id) {
        return this.getElement(new LootDataId<T>(type, id));
    }

    default public <T> Optional<T> getElementOptional(LootDataId<T> key) {
        return Optional.ofNullable(this.getElement(key));
    }

    default public <T> Optional<T> getElementOptional(LootDataType<T> type, MinecraftKey id) {
        return this.getElementOptional(new LootDataId<T>(type, id));
    }

    default public LootTable getLootTable(MinecraftKey id) {
        return this.getElementOptional(LootDataType.c, id).orElse(LootTable.a);
    }
}

