/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionApplyBonus
extends LootItemFunctionConditional {
    private static final Map<MinecraftKey, c> b = Stream.of(net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$a.a, net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$d.b, net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$e.b).collect(Collectors.toMap(c::a, Function.identity()));
    static final Codec<c> c = MinecraftKey.a.comapFlatMap(resourceLocation -> {
        c formulaType = b.get(resourceLocation);
        if (formulaType != null) {
            return DataResult.success((Object)formulaType);
        }
        return DataResult.error(() -> "No formula type with id: '" + resourceLocation + "'");
    }, c::a);
    private static final MapCodec<b> d = new MapCodec<b>(){
        private static final String a = "formula";
        private static final String b = "parameters";

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.of(dynamicOps.createString(a), dynamicOps.createString(b));
        }

        public <T> DataResult<b> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            Object object = mapLike.get(a);
            if (object == null) {
                return DataResult.error(() -> "Missing type for formula in: " + mapLike);
            }
            return c.decode(dynamicOps, object).flatMap(pair -> {
                Object object = Objects.requireNonNullElseGet(mapLike.get(b), () -> ((DynamicOps)dynamicOps).emptyMap());
                return ((c)pair.getFirst()).b().decode(dynamicOps, object).map(Pair::getFirst);
            });
        }

        public <T> RecordBuilder<T> a(b formula, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            c formulaType = formula.a();
            recordBuilder.add(a, c.encodeStart(dynamicOps, (Object)formulaType));
            DataResult<T> dataResult = this.a(formulaType.b(), formula, dynamicOps);
            if (dataResult.result().isEmpty() || !Objects.equals(dataResult.result().get(), dynamicOps.emptyMap())) {
                recordBuilder.add(b, dataResult);
            }
            return recordBuilder;
        }

        private <T, F extends b> DataResult<T> a(Codec<F> codec, b formula, DynamicOps<T> dynamicOps) {
            return codec.encodeStart(dynamicOps, (Object)formula);
        }

        public /* synthetic */ RecordBuilder encode(Object object, DynamicOps dynamicOps, RecordBuilder recordBuilder) {
            return this.a((b)object, dynamicOps, recordBuilder);
        }
    };
    public static final Codec<LootItemFunctionApplyBonus> a = RecordCodecBuilder.create(instance -> LootItemFunctionApplyBonus.a(instance).and(instance.group((App)BuiltInRegistries.g.r().fieldOf("enchantment").forGetter(applyBonusCount -> applyBonusCount.e), (App)d.forGetter(applyBonusCount -> applyBonusCount.f))).apply((Applicative)instance, LootItemFunctionApplyBonus::new));
    private final Holder<Enchantment> e;
    private final b f;

    private LootItemFunctionApplyBonus(List<LootItemCondition> conditions, Holder<Enchantment> enchantment, b formula) {
        super(conditions);
        this.e = enchantment;
        this.f = formula;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.r;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return ImmutableSet.of(LootContextParameters.i);
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        ItemStack itemStack = context.c(LootContextParameters.i);
        if (itemStack != null) {
            int i2 = EnchantmentManager.a(this.e.a(), itemStack);
            int j2 = this.f.a(context.b(), stack.L(), i2);
            stack.f(j2);
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment, float probability, int extra) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> conditions) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)conditions, (Holder<Enchantment>)enchantment.j(), new a(extra, probability)));
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> conditions) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)conditions, (Holder<Enchantment>)enchantment.j(), new d()));
    }

    public static LootItemFunctionConditional.a<?> b(Enchantment enchantment) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> conditions) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)conditions, (Holder<Enchantment>)enchantment.j(), new e(1)));
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment, int bonusMultiplier) {
        return LootItemFunctionApplyBonus.a((List<LootItemCondition> conditions) -> new LootItemFunctionApplyBonus((List<LootItemCondition>)conditions, (Holder<Enchantment>)enchantment.j(), new e(bonusMultiplier)));
    }

    static interface b {
        public int a(RandomSource var1, int var2, int var3);

        public c a();
    }

    static final class e
    extends Record
    implements b {
        private final int c;
        public static final Codec<e> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(e::b)).apply((Applicative)instance, e::new));
        public static final c b = new c(new MinecraftKey("uniform_bonus_count"), a);

        e(int bonusMultiplier) {
            this.c = bonusMultiplier;
        }

        @Override
        @Override
        public int a(RandomSource random, int initialCount, int enchantmentLevel) {
            return initialCount + random.a(this.c * enchantmentLevel + 1);
        }

        @Override
        @Override
        public c a() {
            return b;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "bonusMultiplier", "c"}, this, object);
        }

        public int b() {
            return this.c;
        }
    }

    record d() implements b
    {
        public static final Codec<d> a = Codec.unit(d::new);
        public static final c b = new c(new MinecraftKey("ore_drops"), a);

        @Override
        @Override
        public int a(RandomSource random, int initialCount, int enchantmentLevel) {
            if (enchantmentLevel > 0) {
                int i2 = random.a(enchantmentLevel + 2) - 1;
                if (i2 < 0) {
                    i2 = 0;
                }
                return initialCount * (i2 + 1);
            }
            return initialCount;
        }

        @Override
        @Override
        public c a() {
            return b;
        }
    }

    record a(int b, float c) implements b
    {
        private static final Codec<a> d = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("extra").forGetter(a::b), (App)Codec.FLOAT.fieldOf("probability").forGetter(a::c)).apply((Applicative)instance, a::new));
        public static final c a = new c(new MinecraftKey("binomial_with_bonus_count"), d);

        @Override
        @Override
        public int a(RandomSource random, int initialCount, int enchantmentLevel) {
            for (int i2 = 0; i2 < enchantmentLevel + this.b; ++i2) {
                if (!(random.i() < this.c)) continue;
                ++initialCount;
            }
            return initialCount;
        }

        @Override
        @Override
        public c a() {
            return a;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "extraRounds;probability", "b", "c"}, this, object);
        }
    }

    record c(MinecraftKey a, Codec<? extends b> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;codec", "a", "b"}, this, object);
        }
    }
}

