/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyState
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionCopyState> a = RecordCodecBuilder.create(instance -> LootItemFunctionCopyState.a(instance).and(instance.group((App)BuiltInRegistries.f.r().fieldOf("block").forGetter(copyBlockState -> copyBlockState.b), (App)Codec.STRING.listOf().fieldOf("properties").forGetter(copyBlockState -> copyBlockState.c.stream().map(IBlockState::f).toList()))).apply((Applicative)instance, LootItemFunctionCopyState::new));
    private final Holder<Block> b;
    private final Set<IBlockState<?>> c;

    LootItemFunctionCopyState(List<LootItemCondition> conditions, Holder<Block> block, Set<IBlockState<?>> properties) {
        super(conditions);
        this.b = block;
        this.c = properties;
    }

    private LootItemFunctionCopyState(List<LootItemCondition> conditions, Holder<Block> block, List<String> properties) {
        this(conditions, block, properties.stream().map(block.a().l()::a).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.x;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return ImmutableSet.of(LootContextParameters.g);
    }

    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        IBlockData blockState = context.c(LootContextParameters.g);
        if (blockState != null) {
            NBTTagCompound compoundTag3;
            NBTTagCompound compoundTag = stack.w();
            if (compoundTag.b("BlockStateTag", 10)) {
                NBTTagCompound compoundTag2 = compoundTag.p("BlockStateTag");
            } else {
                compoundTag3 = new NBTTagCompound();
                compoundTag.a("BlockStateTag", compoundTag3);
            }
            for (IBlockState<?> property : this.c) {
                if (!blockState.b(property)) continue;
                compoundTag3.a(property.f(), LootItemFunctionCopyState.a(blockState, property));
            }
        }
        return stack;
    }

    public static a a(Block block) {
        return new a(block);
    }

    private static <T extends Comparable<T>> String a(IBlockData state, IBlockState<T> property) {
        T comparable = state.c(property);
        return property.a(comparable);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Holder<Block> a;
        private final ImmutableSet.Builder<IBlockState<?>> b = ImmutableSet.builder();

        a(Block block) {
            this.a = block.q();
        }

        public a a(IBlockState<?> property) {
            if (!this.a.a().l().d().contains(property)) {
                throw new IllegalStateException("Property " + property + " is not present on block " + this.a);
            }
            this.b.add(property);
            return this;
        }

        @Override
        protected a a() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionCopyState(this.g(), this.a, (Set<IBlockState<?>>)this.b.build());
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }
}

