/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    private static final Codec<HolderSet<Enchantment>> c = BuiltInRegistries.g.r().listOf().xmap(HolderSet::a, holderSet -> holderSet.a().toList());
    public static final Codec<LootItemFunctionEnchant> a = RecordCodecBuilder.create(instance -> LootItemFunctionEnchant.a(instance).and((App)ExtraCodecs.a(c, "enchantments").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.d)).apply((Applicative)instance, LootItemFunctionEnchant::new));
    private final Optional<HolderSet<Enchantment>> d;

    LootItemFunctionEnchant(List<LootItemCondition> conditions, Optional<HolderSet<Enchantment>> enchantments) {
        super(conditions);
        this.d = enchantments;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.e;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        RandomSource randomSource = context.b();
        Optional optional = this.d.flatMap(holderSet -> holderSet.a(randomSource)).or(() -> {
            boolean bl = stack.a(Items.qb);
            List<Holder.c> list = BuiltInRegistries.g.h().filter(reference -> ((Enchantment)reference.a()).i()).filter(enchantment -> bl || ((Enchantment)enchantment.a()).a(stack)).toList();
            return SystemUtils.b(list, randomSource);
        });
        if (optional.isEmpty()) {
            b.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        return LootItemFunctionEnchant.a(stack, (Enchantment)((Holder)optional.get()).a(), randomSource);
    }

    private static ItemStack a(ItemStack stack, Enchantment enchantment, RandomSource random) {
        int i2 = MathHelper.a(random, enchantment.e(), enchantment.a());
        if (stack.a(Items.qb)) {
            stack = new ItemStack(Items.tC);
            ItemEnchantedBook.a(stack, new WeightedRandomEnchant(enchantment, i2));
        } else {
            stack.a(enchantment, i2);
        }
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static LootItemFunctionConditional.a<?> d() {
        return LootItemFunctionEnchant.a((List<LootItemCondition> conditions) -> new LootItemFunctionEnchant((List<LootItemCondition>)conditions, Optional.empty()));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<Holder<Enchantment>> a = new ArrayList<Holder<Enchantment>>();

        @Override
        protected a a() {
            return this;
        }

        public a a(Enchantment enchantment) {
            this.a.add(enchantment.j());
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionEnchant(this.g(), this.a.isEmpty() ? Optional.empty() : Optional.of(HolderSet.a(this.a)));
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }
}

