/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;

public class LootItemFunctionExplorationMap
extends LootItemFunctionConditional {
    public static final TagKey<Structure> a = StructureTags.l;
    public static final MapIcon.Type b = MapIcon.Type.i;
    public static final byte c = 2;
    public static final int d = 50;
    public static final boolean e = true;
    public static final Codec<LootItemFunctionExplorationMap> f = RecordCodecBuilder.create(instance -> LootItemFunctionExplorationMap.a(instance).and(instance.group((App)ExtraCodecs.a(TagKey.a(Registries.az), "destination", a).forGetter(explorationMapFunction -> explorationMapFunction.h), (App)MapIcon.Type.I.optionalFieldOf("decoration", (Object)b).forGetter(explorationMapFunction -> explorationMapFunction.i), (App)ExtraCodecs.a(Codec.BYTE, "zoom", Byte.valueOf((byte)2)).forGetter(explorationMapFunction -> explorationMapFunction.j), (App)ExtraCodecs.a(Codec.INT, "search_radius", Integer.valueOf(50)).forGetter(explorationMapFunction -> explorationMapFunction.k), (App)ExtraCodecs.a(Codec.BOOL, "skip_existing_chunks", true).forGetter(explorationMapFunction -> explorationMapFunction.l))).apply((Applicative)instance, LootItemFunctionExplorationMap::new));
    private final TagKey<Structure> h;
    private final MapIcon.Type i;
    private final byte j;
    private final int k;
    private final boolean l;

    LootItemFunctionExplorationMap(List<LootItemCondition> conditions, TagKey<Structure> destination, MapIcon.Type decoration, byte zoom, int searchRadius, boolean skipExistingChunks) {
        super(conditions);
        this.h = destination;
        this.i = decoration;
        this.j = zoom;
        this.k = searchRadius;
        this.l = skipExistingChunks;
    }

    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.m;
    }

    @Override
    public Set<LootContextParameter<?>> a() {
        return ImmutableSet.of(LootContextParameters.f);
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (!stack.a(Items.tp)) {
            return stack;
        }
        Vec3D vec3 = context.c(LootContextParameters.f);
        if (vec3 != null) {
            WorldServer serverLevel = context.d();
            if (!serverLevel.paperConfig().environment.treasureMaps.enabled) {
                return stack;
            }
            BlockPosition blockPos = serverLevel.a(this.h, BlockPosition.a(vec3), this.k, !serverLevel.paperConfig().environment.treasureMaps.findAlreadyDiscoveredLootTable.or(!this.l));
            if (blockPos != null) {
                ItemStack itemStack = ItemWorldMap.a(serverLevel, blockPos.u(), blockPos.w(), this.j, true, true);
                ItemWorldMap.a(serverLevel, itemStack);
                WorldMap.a(itemStack, blockPos, "+", this.i);
                return itemStack;
            }
        }
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private TagKey<Structure> a = a;
        private MapIcon.Type b = b;
        private byte c = (byte)2;
        private int d = 50;
        private boolean e = true;

        protected a a() {
            return this;
        }

        public a a(TagKey<Structure> destination) {
            this.a = destination;
            return this;
        }

        public a a(MapIcon.Type decoration) {
            this.b = decoration;
            return this;
        }

        public a a(byte zoom) {
            this.c = zoom;
            return this;
        }

        public a a(int searchRadius) {
            this.d = searchRadius;
            return this;
        }

        public a a(boolean skipExistingChunks) {
            this.e = skipExistingChunks;
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new LootItemFunctionExplorationMap(this.g(), this.a, this.b, this.c, this.d, this.e);
        }
    }
}

