/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<LootItemFunctionSetName> a = RecordCodecBuilder.create(instance -> LootItemFunctionSetName.a(instance).and(instance.group((App)ExtraCodecs.a(ExtraCodecs.b, "name").forGetter(setNameFunction -> setNameFunction.c), (App)ExtraCodecs.a(LootTableInfo.EntityTarget.e, "entity").forGetter(setNameFunction -> setNameFunction.d))).apply((Applicative)instance, LootItemFunctionSetName::new));
    private final Optional<IChatBaseComponent> c;
    private final Optional<LootTableInfo.EntityTarget> d;

    private LootItemFunctionSetName(List<LootItemCondition> conditions, Optional<IChatBaseComponent> name, Optional<LootTableInfo.EntityTarget> entity) {
        super(conditions);
        this.c = name;
        this.d = entity;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.l;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return this.d.map(entityTarget -> Set.of(entityTarget.a())).orElse(Set.of());
    }

    public static UnaryOperator<IChatBaseComponent> a(LootTableInfo context, @Nullable LootTableInfo.EntityTarget sourceEntity) {
        Entity entity;
        if (sourceEntity != null && (entity = context.c(sourceEntity.a())) != null) {
            CommandListenerWrapper commandSourceStack = entity.dc().a(2);
            return textComponent -> {
                try {
                    return ChatComponentUtils.a(commandSourceStack, textComponent, entity, 0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    b.warn("Failed to resolve text component", (Throwable)commandSyntaxException);
                    return textComponent;
                }
            };
        }
        return textComponent -> textComponent;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        this.c.ifPresent(component -> stack.a((IChatBaseComponent)LootItemFunctionSetName.a(context, (LootTableInfo.EntityTarget)this.d.orElse(null)).apply((IChatBaseComponent)component)));
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name) {
        return LootItemFunctionSetName.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetName((List<LootItemCondition>)conditions, Optional.of(name), Optional.empty()));
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, LootTableInfo.EntityTarget target) {
        return LootItemFunctionSetName.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetName((List<LootItemCondition>)conditions, Optional.of(name), Optional.of(target)));
    }
}

