/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetTable
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetTable> a = RecordCodecBuilder.create(instance -> LootItemFunctionSetTable.a(instance).and(instance.group((App)MinecraftKey.a.fieldOf("name").forGetter(setContainerLootTable -> setContainerLootTable.b), (App)ExtraCodecs.a(Codec.LONG, "seed", 0L).forGetter(setContainerLootTable -> setContainerLootTable.c), (App)BuiltInRegistries.l.r().fieldOf("type").forGetter(setContainerLootTable -> setContainerLootTable.d))).apply((Applicative)instance, LootItemFunctionSetTable::new));
    private final MinecraftKey b;
    private final long c;
    private final Holder<TileEntityTypes<?>> d;

    private LootItemFunctionSetTable(List<LootItemCondition> conditions, MinecraftKey id, long seed, Holder<TileEntityTypes<?>> blockEntityType) {
        super(conditions);
        this.b = id;
        this.c = seed;
        this.d = blockEntityType;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.s;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (stack.b()) {
            return stack;
        }
        NBTTagCompound compoundTag = ItemBlock.a(stack);
        if (compoundTag == null) {
            compoundTag = new NBTTagCompound();
        }
        compoundTag.a("LootTable", this.b.toString());
        if (this.c != 0L) {
            compoundTag.a("LootTableSeed", this.c);
        }
        ItemBlock.a(stack, this.d.a(), compoundTag);
        return stack;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        super.a(reporter);
        LootDataId<LootTable> lootDataId = new LootDataId<LootTable>(LootDataType.c, this.b);
        if (reporter.b().getElementOptional(lootDataId).isEmpty()) {
            reporter.a("Missing loot table used for container: " + this.b);
        }
    }

    public static LootItemFunctionConditional.a<?> a(TileEntityTypes<?> type, MinecraftKey id) {
        return LootItemFunctionSetTable.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetTable((List<LootItemCondition>)conditions, id, 0L, (Holder<TileEntityTypes<?>>)type.a()));
    }

    public static LootItemFunctionConditional.a<?> a(TileEntityTypes<?> type, MinecraftKey id, long seed) {
        return LootItemFunctionSetTable.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetTable((List<LootItemCondition>)conditions, id, seed, (Holder<TileEntityTypes<?>>)type.a()));
    }
}

