/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTag;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> a = (stack, context) -> stack;
    private static final Codec<LootItemFunction> D = BuiltInRegistries.H.q().dispatch("function", LootItemFunction::b, LootItemFunctionType::a);
    public static final Codec<LootItemFunction> b = ExtraCodecs.a(() -> ExtraCodecs.e(D, SequenceFunction.b));
    public static final LootItemFunctionType c = LootItemFunctions.a("set_count", LootItemFunctionSetCount.a);
    public static final LootItemFunctionType d = LootItemFunctions.a("enchant_with_levels", LootEnchantLevel.a);
    public static final LootItemFunctionType e = LootItemFunctions.a("enchant_randomly", LootItemFunctionEnchant.a);
    public static final LootItemFunctionType f = LootItemFunctions.a("set_enchantments", SetEnchantmentsFunction.a);
    public static final LootItemFunctionType g = LootItemFunctions.a("set_nbt", LootItemFunctionSetTag.a);
    public static final LootItemFunctionType h = LootItemFunctions.a("furnace_smelt", LootItemFunctionSmelt.a);
    public static final LootItemFunctionType i = LootItemFunctions.a("looting_enchant", LootEnchantFunction.b);
    public static final LootItemFunctionType j = LootItemFunctions.a("set_damage", LootItemFunctionSetDamage.a);
    public static final LootItemFunctionType k = LootItemFunctions.a("set_attributes", LootItemFunctionSetAttribute.a);
    public static final LootItemFunctionType l = LootItemFunctions.a("set_name", LootItemFunctionSetName.a);
    public static final LootItemFunctionType m = LootItemFunctions.a("exploration_map", LootItemFunctionExplorationMap.f);
    public static final LootItemFunctionType n = LootItemFunctions.a("set_stew_effect", LootItemFunctionSetStewEffect.a);
    public static final LootItemFunctionType o = LootItemFunctions.a("copy_name", LootItemFunctionCopyName.a);
    public static final LootItemFunctionType p = LootItemFunctions.a("set_contents", LootItemFunctionSetContents.a);
    public static final LootItemFunctionType q = LootItemFunctions.a("limit_count", LootItemFunctionLimitCount.a);
    public static final LootItemFunctionType r = LootItemFunctions.a("apply_bonus", LootItemFunctionApplyBonus.a);
    public static final LootItemFunctionType s = LootItemFunctions.a("set_loot_table", LootItemFunctionSetTable.a);
    public static final LootItemFunctionType t = LootItemFunctions.a("explosion_decay", LootItemFunctionExplosionDecay.a);
    public static final LootItemFunctionType u = LootItemFunctions.a("set_lore", LootItemFunctionSetLore.a);
    public static final LootItemFunctionType v = LootItemFunctions.a("fill_player_head", LootItemFunctionFillPlayerHead.a);
    public static final LootItemFunctionType w = LootItemFunctions.a("copy_nbt", LootItemFunctionCopyNBT.a);
    public static final LootItemFunctionType x = LootItemFunctions.a("copy_state", LootItemFunctionCopyState.a);
    public static final LootItemFunctionType y = LootItemFunctions.a("set_banner_pattern", SetBannerPatternFunction.a);
    public static final LootItemFunctionType z = LootItemFunctions.a("set_potion", SetPotionFunction.a);
    public static final LootItemFunctionType A = LootItemFunctions.a("set_instrument", SetInstrumentFunction.a);
    public static final LootItemFunctionType B = LootItemFunctions.a("reference", FunctionReference.a);
    public static final LootItemFunctionType C = LootItemFunctions.a("sequence", SequenceFunction.a);

    private static LootItemFunctionType a(String id, Codec<? extends LootItemFunction> codec) {
        return IRegistry.a(BuiltInRegistries.H, new MinecraftKey(id), new LootItemFunctionType(codec));
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> a(List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> list) {
        List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> list2 = List.copyOf(list);
        return switch (list2.size()) {
            case 0 -> a;
            case 1 -> list2.get(0);
            case 2 -> {
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction = list2.get(0);
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction2 = list2.get(1);
                yield (stack, context) -> (ItemStack)biFunction2.apply((ItemStack)biFunction.apply((ItemStack)stack, (LootTableInfo)context), (LootTableInfo)context);
            }
            default -> (itemStack, lootContext) -> {
                for (BiFunction biFunction : list2) {
                    itemStack = (ItemStack)biFunction.apply(itemStack, lootContext);
                }
                return itemStack;
            };
        };
    }
}

